/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="Arguments to run ping test.")
public class ApiPerfInspectorPingArgs {
    @SerializedName(value="pingTimeoutSecs")
    private BigDecimal pingTimeoutSecs = null;
    @SerializedName(value="pingCount")
    private BigDecimal pingCount = null;
    @SerializedName(value="pingPacketSizeBytes")
    private BigDecimal pingPacketSizeBytes = null;

    public ApiPerfInspectorPingArgs pingTimeoutSecs(BigDecimal pingTimeoutSecs) {
        this.pingTimeoutSecs = pingTimeoutSecs;
        return this;
    }

    @ApiModelProperty(example="10.0", value="Timeout in seconds for the ping request to each target host. If not specified, defaults to 10 seconds. Must be a value between 1 and 3600 seconds, inclusive.")
    public BigDecimal getPingTimeoutSecs() {
        return this.pingTimeoutSecs;
    }

    public void setPingTimeoutSecs(BigDecimal pingTimeoutSecs) {
        this.pingTimeoutSecs = pingTimeoutSecs;
    }

    public ApiPerfInspectorPingArgs pingCount(BigDecimal pingCount) {
        this.pingCount = pingCount;
        return this;
    }

    @ApiModelProperty(example="10.0", value="Number of iterations of the ping request to each target host. If not specified, defaults to 10 count.")
    public BigDecimal getPingCount() {
        return this.pingCount;
    }

    public void setPingCount(BigDecimal pingCount) {
        this.pingCount = pingCount;
    }

    public ApiPerfInspectorPingArgs pingPacketSizeBytes(BigDecimal pingPacketSizeBytes) {
        this.pingPacketSizeBytes = pingPacketSizeBytes;
        return this;
    }

    @ApiModelProperty(example="56.0", value="Packet size in bytes for each ping request. If not specified, defaults to 56 bytes. Must be a value between 1 and 65507 bytes, inclusive.")
    public BigDecimal getPingPacketSizeBytes() {
        return this.pingPacketSizeBytes;
    }

    public void setPingPacketSizeBytes(BigDecimal pingPacketSizeBytes) {
        this.pingPacketSizeBytes = pingPacketSizeBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiPerfInspectorPingArgs apiPerfInspectorPingArgs = (ApiPerfInspectorPingArgs)o;
        return Objects.equals(this.pingTimeoutSecs, apiPerfInspectorPingArgs.pingTimeoutSecs) && Objects.equals(this.pingCount, apiPerfInspectorPingArgs.pingCount) && Objects.equals(this.pingPacketSizeBytes, apiPerfInspectorPingArgs.pingPacketSizeBytes);
    }

    public int hashCode() {
        return Objects.hash(this.pingTimeoutSecs, this.pingCount, this.pingPacketSizeBytes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiPerfInspectorPingArgs {\n");
        sb.append("    pingTimeoutSecs: ").append(this.toIndentedString(this.pingTimeoutSecs)).append("\n");
        sb.append("    pingCount: ").append(this.toIndentedString(this.pingCount)).append("\n");
        sb.append("    pingPacketSizeBytes: ").append(this.toIndentedString(this.pingPacketSizeBytes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

