/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiHBaseSnapshotPolicyArguments;
import com.cloudera.api.swagger.model.ApiHdfsSnapshotPolicyArguments;
import com.cloudera.api.swagger.model.ApiSnapshotCommand;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A snapshot policy. <p/> Snapshot policies have service specific arguments. This object has methods to retrieve arguments for all supported types of snapshots, but only one argument type is allowed to be set; the backend will check that the provided argument matches the type of the service with which the snapshot policy is associated.")
public class ApiSnapshotPolicy {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="hourlySnapshots")
    private BigDecimal hourlySnapshots = null;
    @SerializedName(value="dailySnapshots")
    private BigDecimal dailySnapshots = null;
    @SerializedName(value="weeklySnapshots")
    private BigDecimal weeklySnapshots = null;
    @SerializedName(value="monthlySnapshots")
    private BigDecimal monthlySnapshots = null;
    @SerializedName(value="yearlySnapshots")
    private BigDecimal yearlySnapshots = null;
    @SerializedName(value="minuteOfHour")
    private BigDecimal minuteOfHour = null;
    @SerializedName(value="hoursForHourlySnapshots")
    private List<BigDecimal> hoursForHourlySnapshots = null;
    @SerializedName(value="hourOfDay")
    private BigDecimal hourOfDay = null;
    @SerializedName(value="dayOfWeek")
    private BigDecimal dayOfWeek = null;
    @SerializedName(value="dayOfMonth")
    private BigDecimal dayOfMonth = null;
    @SerializedName(value="monthOfYear")
    private BigDecimal monthOfYear = null;
    @SerializedName(value="alertOnStart")
    private Boolean alertOnStart = null;
    @SerializedName(value="alertOnSuccess")
    private Boolean alertOnSuccess = null;
    @SerializedName(value="alertOnFail")
    private Boolean alertOnFail = null;
    @SerializedName(value="alertOnAbort")
    private Boolean alertOnAbort = null;
    @SerializedName(value="hbaseArguments")
    private ApiHBaseSnapshotPolicyArguments hbaseArguments = null;
    @SerializedName(value="hdfsArguments")
    private ApiHdfsSnapshotPolicyArguments hdfsArguments = null;
    @SerializedName(value="lastCommand")
    private ApiSnapshotCommand lastCommand = null;
    @SerializedName(value="lastSuccessfulCommand")
    private ApiSnapshotCommand lastSuccessfulCommand = null;
    @SerializedName(value="paused")
    private Boolean paused = null;

    public ApiSnapshotPolicy name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the snapshot policy.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiSnapshotPolicy description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the snapshot policy.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ApiSnapshotPolicy hourlySnapshots(BigDecimal hourlySnapshots) {
        this.hourlySnapshots = hourlySnapshots;
        return this;
    }

    @ApiModelProperty(value="Number of hourly snapshots to be retained.")
    public BigDecimal getHourlySnapshots() {
        return this.hourlySnapshots;
    }

    public void setHourlySnapshots(BigDecimal hourlySnapshots) {
        this.hourlySnapshots = hourlySnapshots;
    }

    public ApiSnapshotPolicy dailySnapshots(BigDecimal dailySnapshots) {
        this.dailySnapshots = dailySnapshots;
        return this;
    }

    @ApiModelProperty(value="Number of daily snapshots to be retained.")
    public BigDecimal getDailySnapshots() {
        return this.dailySnapshots;
    }

    public void setDailySnapshots(BigDecimal dailySnapshots) {
        this.dailySnapshots = dailySnapshots;
    }

    public ApiSnapshotPolicy weeklySnapshots(BigDecimal weeklySnapshots) {
        this.weeklySnapshots = weeklySnapshots;
        return this;
    }

    @ApiModelProperty(value="Number of weekly snapshots to be retained.")
    public BigDecimal getWeeklySnapshots() {
        return this.weeklySnapshots;
    }

    public void setWeeklySnapshots(BigDecimal weeklySnapshots) {
        this.weeklySnapshots = weeklySnapshots;
    }

    public ApiSnapshotPolicy monthlySnapshots(BigDecimal monthlySnapshots) {
        this.monthlySnapshots = monthlySnapshots;
        return this;
    }

    @ApiModelProperty(value="Number of monthly snapshots to be retained.")
    public BigDecimal getMonthlySnapshots() {
        return this.monthlySnapshots;
    }

    public void setMonthlySnapshots(BigDecimal monthlySnapshots) {
        this.monthlySnapshots = monthlySnapshots;
    }

    public ApiSnapshotPolicy yearlySnapshots(BigDecimal yearlySnapshots) {
        this.yearlySnapshots = yearlySnapshots;
        return this;
    }

    @ApiModelProperty(value="Number of yearly snapshots to be retained.")
    public BigDecimal getYearlySnapshots() {
        return this.yearlySnapshots;
    }

    public void setYearlySnapshots(BigDecimal yearlySnapshots) {
        this.yearlySnapshots = yearlySnapshots;
    }

    public ApiSnapshotPolicy minuteOfHour(BigDecimal minuteOfHour) {
        this.minuteOfHour = minuteOfHour;
        return this;
    }

    @ApiModelProperty(value="Minute in the hour that hourly, daily, weekly, monthly and yearly snapshots should be created. Valid values are 0 to 59. Default value is 0.")
    public BigDecimal getMinuteOfHour() {
        return this.minuteOfHour;
    }

    public void setMinuteOfHour(BigDecimal minuteOfHour) {
        this.minuteOfHour = minuteOfHour;
    }

    public ApiSnapshotPolicy hoursForHourlySnapshots(List<BigDecimal> hoursForHourlySnapshots) {
        this.hoursForHourlySnapshots = hoursForHourlySnapshots;
        return this;
    }

    public ApiSnapshotPolicy addHoursForHourlySnapshotsItem(BigDecimal hoursForHourlySnapshotsItem) {
        if (this.hoursForHourlySnapshots == null) {
            this.hoursForHourlySnapshots = new ArrayList<BigDecimal>();
        }
        this.hoursForHourlySnapshots.add(hoursForHourlySnapshotsItem);
        return this;
    }

    @ApiModelProperty(value="Hours of the day that hourly snapshots should be created. Valid values are 0 to 23. If this list is null or empty, then hourly snapshots are created for every hour.")
    public List<BigDecimal> getHoursForHourlySnapshots() {
        return this.hoursForHourlySnapshots;
    }

    public void setHoursForHourlySnapshots(List<BigDecimal> hoursForHourlySnapshots) {
        this.hoursForHourlySnapshots = hoursForHourlySnapshots;
    }

    public ApiSnapshotPolicy hourOfDay(BigDecimal hourOfDay) {
        this.hourOfDay = hourOfDay;
        return this;
    }

    @ApiModelProperty(value="Hour in the day that daily, weekly, monthly and yearly snapshots should be created. Valid values are 0 to 23. Default value is 0.")
    public BigDecimal getHourOfDay() {
        return this.hourOfDay;
    }

    public void setHourOfDay(BigDecimal hourOfDay) {
        this.hourOfDay = hourOfDay;
    }

    public ApiSnapshotPolicy dayOfWeek(BigDecimal dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
        return this;
    }

    @ApiModelProperty(value="Day of the week that weekly snapshots should be created. Valid values are 1 to 7, 1 representing Sunday. Default value is 1.")
    public BigDecimal getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(BigDecimal dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public ApiSnapshotPolicy dayOfMonth(BigDecimal dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
        return this;
    }

    @ApiModelProperty(value="Day of the month that monthly and yearly snapshots should be created. Values from 1 to 31 are allowed. Additionally 0 to -30 can be used to specify offsets from the last day of the month. Default value is 1. <p/> If this value is invalid for any month for which snapshots are required, the backend will throw an exception.")
    public BigDecimal getDayOfMonth() {
        return this.dayOfMonth;
    }

    public void setDayOfMonth(BigDecimal dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    public ApiSnapshotPolicy monthOfYear(BigDecimal monthOfYear) {
        this.monthOfYear = monthOfYear;
        return this;
    }

    @ApiModelProperty(value="Month of the year that yearly snapshots should be created. Valid values are 1 to 12, 1 representing January. Default value is 1.")
    public BigDecimal getMonthOfYear() {
        return this.monthOfYear;
    }

    public void setMonthOfYear(BigDecimal monthOfYear) {
        this.monthOfYear = monthOfYear;
    }

    public ApiSnapshotPolicy alertOnStart(Boolean alertOnStart) {
        this.alertOnStart = alertOnStart;
        return this;
    }

    @ApiModelProperty(value="Whether to alert on start of snapshot creation/deletion activity.")
    public Boolean getAlertOnStart() {
        return this.alertOnStart;
    }

    public void setAlertOnStart(Boolean alertOnStart) {
        this.alertOnStart = alertOnStart;
    }

    public ApiSnapshotPolicy alertOnSuccess(Boolean alertOnSuccess) {
        this.alertOnSuccess = alertOnSuccess;
        return this;
    }

    @ApiModelProperty(value="Whether to alert on successful completion of snapshot creation/deletion activity.")
    public Boolean getAlertOnSuccess() {
        return this.alertOnSuccess;
    }

    public void setAlertOnSuccess(Boolean alertOnSuccess) {
        this.alertOnSuccess = alertOnSuccess;
    }

    public ApiSnapshotPolicy alertOnFail(Boolean alertOnFail) {
        this.alertOnFail = alertOnFail;
        return this;
    }

    @ApiModelProperty(value="Whether to alert on failure of snapshot creation/deletion activity.")
    public Boolean getAlertOnFail() {
        return this.alertOnFail;
    }

    public void setAlertOnFail(Boolean alertOnFail) {
        this.alertOnFail = alertOnFail;
    }

    public ApiSnapshotPolicy alertOnAbort(Boolean alertOnAbort) {
        this.alertOnAbort = alertOnAbort;
        return this;
    }

    @ApiModelProperty(value="Whether to alert on abort of snapshot creation/deletion activity.")
    public Boolean getAlertOnAbort() {
        return this.alertOnAbort;
    }

    public void setAlertOnAbort(Boolean alertOnAbort) {
        this.alertOnAbort = alertOnAbort;
    }

    public ApiSnapshotPolicy hbaseArguments(ApiHBaseSnapshotPolicyArguments hbaseArguments) {
        this.hbaseArguments = hbaseArguments;
        return this;
    }

    @ApiModelProperty(value="Arguments specific to HBase snapshot policies.")
    public ApiHBaseSnapshotPolicyArguments getHbaseArguments() {
        return this.hbaseArguments;
    }

    public void setHbaseArguments(ApiHBaseSnapshotPolicyArguments hbaseArguments) {
        this.hbaseArguments = hbaseArguments;
    }

    public ApiSnapshotPolicy hdfsArguments(ApiHdfsSnapshotPolicyArguments hdfsArguments) {
        this.hdfsArguments = hdfsArguments;
        return this;
    }

    @ApiModelProperty(value="Arguments specific to Hdfs snapshot policies.")
    public ApiHdfsSnapshotPolicyArguments getHdfsArguments() {
        return this.hdfsArguments;
    }

    public void setHdfsArguments(ApiHdfsSnapshotPolicyArguments hdfsArguments) {
        this.hdfsArguments = hdfsArguments;
    }

    public ApiSnapshotPolicy lastCommand(ApiSnapshotCommand lastCommand) {
        this.lastCommand = lastCommand;
        return this;
    }

    @ApiModelProperty(value="Latest command of this policy. The command might still be active.")
    public ApiSnapshotCommand getLastCommand() {
        return this.lastCommand;
    }

    public void setLastCommand(ApiSnapshotCommand lastCommand) {
        this.lastCommand = lastCommand;
    }

    public ApiSnapshotPolicy lastSuccessfulCommand(ApiSnapshotCommand lastSuccessfulCommand) {
        this.lastSuccessfulCommand = lastSuccessfulCommand;
        return this;
    }

    @ApiModelProperty(value="Last successful command of this policy. Returns null if there has been no successful command.")
    public ApiSnapshotCommand getLastSuccessfulCommand() {
        return this.lastSuccessfulCommand;
    }

    public void setLastSuccessfulCommand(ApiSnapshotCommand lastSuccessfulCommand) {
        this.lastSuccessfulCommand = lastSuccessfulCommand;
    }

    public ApiSnapshotPolicy paused(Boolean paused) {
        this.paused = paused;
        return this;
    }

    @ApiModelProperty(value="Whether to pause a snapshot policy, available since V11.")
    public Boolean getPaused() {
        return this.paused;
    }

    public void setPaused(Boolean paused) {
        this.paused = paused;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiSnapshotPolicy apiSnapshotPolicy = (ApiSnapshotPolicy)o;
        return Objects.equals(this.name, apiSnapshotPolicy.name) && Objects.equals(this.description, apiSnapshotPolicy.description) && Objects.equals(this.hourlySnapshots, apiSnapshotPolicy.hourlySnapshots) && Objects.equals(this.dailySnapshots, apiSnapshotPolicy.dailySnapshots) && Objects.equals(this.weeklySnapshots, apiSnapshotPolicy.weeklySnapshots) && Objects.equals(this.monthlySnapshots, apiSnapshotPolicy.monthlySnapshots) && Objects.equals(this.yearlySnapshots, apiSnapshotPolicy.yearlySnapshots) && Objects.equals(this.minuteOfHour, apiSnapshotPolicy.minuteOfHour) && Objects.equals(this.hoursForHourlySnapshots, apiSnapshotPolicy.hoursForHourlySnapshots) && Objects.equals(this.hourOfDay, apiSnapshotPolicy.hourOfDay) && Objects.equals(this.dayOfWeek, apiSnapshotPolicy.dayOfWeek) && Objects.equals(this.dayOfMonth, apiSnapshotPolicy.dayOfMonth) && Objects.equals(this.monthOfYear, apiSnapshotPolicy.monthOfYear) && Objects.equals(this.alertOnStart, apiSnapshotPolicy.alertOnStart) && Objects.equals(this.alertOnSuccess, apiSnapshotPolicy.alertOnSuccess) && Objects.equals(this.alertOnFail, apiSnapshotPolicy.alertOnFail) && Objects.equals(this.alertOnAbort, apiSnapshotPolicy.alertOnAbort) && Objects.equals(this.hbaseArguments, apiSnapshotPolicy.hbaseArguments) && Objects.equals(this.hdfsArguments, apiSnapshotPolicy.hdfsArguments) && Objects.equals(this.lastCommand, apiSnapshotPolicy.lastCommand) && Objects.equals(this.lastSuccessfulCommand, apiSnapshotPolicy.lastSuccessfulCommand) && Objects.equals(this.paused, apiSnapshotPolicy.paused);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.hourlySnapshots, this.dailySnapshots, this.weeklySnapshots, this.monthlySnapshots, this.yearlySnapshots, this.minuteOfHour, this.hoursForHourlySnapshots, this.hourOfDay, this.dayOfWeek, this.dayOfMonth, this.monthOfYear, this.alertOnStart, this.alertOnSuccess, this.alertOnFail, this.alertOnAbort, this.hbaseArguments, this.hdfsArguments, this.lastCommand, this.lastSuccessfulCommand, this.paused);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiSnapshotPolicy {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    hourlySnapshots: ").append(this.toIndentedString(this.hourlySnapshots)).append("\n");
        sb.append("    dailySnapshots: ").append(this.toIndentedString(this.dailySnapshots)).append("\n");
        sb.append("    weeklySnapshots: ").append(this.toIndentedString(this.weeklySnapshots)).append("\n");
        sb.append("    monthlySnapshots: ").append(this.toIndentedString(this.monthlySnapshots)).append("\n");
        sb.append("    yearlySnapshots: ").append(this.toIndentedString(this.yearlySnapshots)).append("\n");
        sb.append("    minuteOfHour: ").append(this.toIndentedString(this.minuteOfHour)).append("\n");
        sb.append("    hoursForHourlySnapshots: ").append(this.toIndentedString(this.hoursForHourlySnapshots)).append("\n");
        sb.append("    hourOfDay: ").append(this.toIndentedString(this.hourOfDay)).append("\n");
        sb.append("    dayOfWeek: ").append(this.toIndentedString(this.dayOfWeek)).append("\n");
        sb.append("    dayOfMonth: ").append(this.toIndentedString(this.dayOfMonth)).append("\n");
        sb.append("    monthOfYear: ").append(this.toIndentedString(this.monthOfYear)).append("\n");
        sb.append("    alertOnStart: ").append(this.toIndentedString(this.alertOnStart)).append("\n");
        sb.append("    alertOnSuccess: ").append(this.toIndentedString(this.alertOnSuccess)).append("\n");
        sb.append("    alertOnFail: ").append(this.toIndentedString(this.alertOnFail)).append("\n");
        sb.append("    alertOnAbort: ").append(this.toIndentedString(this.alertOnAbort)).append("\n");
        sb.append("    hbaseArguments: ").append(this.toIndentedString(this.hbaseArguments)).append("\n");
        sb.append("    hdfsArguments: ").append(this.toIndentedString(this.hdfsArguments)).append("\n");
        sb.append("    lastCommand: ").append(this.toIndentedString(this.lastCommand)).append("\n");
        sb.append("    lastSuccessfulCommand: ").append(this.toIndentedString(this.lastSuccessfulCommand)).append("\n");
        sb.append("    paused: ").append(this.toIndentedString(this.paused)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

