/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger;

import com.cloudera.api.swagger.client.ApiCallback;
import com.cloudera.api.swagger.client.ApiClient;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.client.ApiResponse;
import com.cloudera.api.swagger.client.Configuration;
import com.cloudera.api.swagger.client.Pair;
import com.cloudera.api.swagger.client.ProgressRequestBody;
import com.cloudera.api.swagger.client.ProgressResponseBody;
import com.cloudera.api.swagger.model.ApiCommand;
import com.cloudera.api.swagger.model.ApiReplicationCommandList;
import com.cloudera.api.swagger.model.ApiReplicationDiagnosticsCollectionArgs;
import com.cloudera.api.swagger.model.ApiReplicationSchedule;
import com.cloudera.api.swagger.model.ApiReplicationScheduleList;
import com.cloudera.api.swagger.model.ApiReplicationState;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;

public class ReplicationsResourceApi {
    private ApiClient apiClient;

    public ReplicationsResourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ReplicationsResourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call collectDiagnosticDataCall(String clusterName, BigDecimal scheduleId, String serviceName, String view, ApiReplicationDiagnosticsCollectionArgs body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiReplicationDiagnosticsCollectionArgs localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/{scheduleId}/collectDiagnosticData".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{scheduleId\\}", this.apiClient.escapeString(scheduleId.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call collectDiagnosticDataValidateBeforeCall(String clusterName, BigDecimal scheduleId, String serviceName, String view, ApiReplicationDiagnosticsCollectionArgs body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling collectDiagnosticData(Async)");
        }
        if (scheduleId == null) {
            throw new ApiException("Missing the required parameter 'scheduleId' when calling collectDiagnosticData(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling collectDiagnosticData(Async)");
        }
        Call call = this.collectDiagnosticDataCall(clusterName, scheduleId, serviceName, view, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand collectDiagnosticData(String clusterName, BigDecimal scheduleId, String serviceName, String view, ApiReplicationDiagnosticsCollectionArgs body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.collectDiagnosticDataWithHttpInfo(clusterName, scheduleId, serviceName, view, body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> collectDiagnosticDataWithHttpInfo(String clusterName, BigDecimal scheduleId, String serviceName, String view, ApiReplicationDiagnosticsCollectionArgs body) throws ApiException {
        Call call = this.collectDiagnosticDataValidateBeforeCall(clusterName, scheduleId, serviceName, view, body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call collectDiagnosticDataAsync(String clusterName, BigDecimal scheduleId, String serviceName, String view, ApiReplicationDiagnosticsCollectionArgs body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.collectDiagnosticDataValidateBeforeCall(clusterName, scheduleId, serviceName, view, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createSchedulesCall(String clusterName, String serviceName, ApiReplicationScheduleList body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiReplicationScheduleList localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createSchedulesValidateBeforeCall(String clusterName, String serviceName, ApiReplicationScheduleList body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling createSchedules(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling createSchedules(Async)");
        }
        Call call = this.createSchedulesCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiReplicationScheduleList createSchedules(String clusterName, String serviceName, ApiReplicationScheduleList body) throws ApiException {
        ApiResponse<ApiReplicationScheduleList> resp = this.createSchedulesWithHttpInfo(clusterName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiReplicationScheduleList> createSchedulesWithHttpInfo(String clusterName, String serviceName, ApiReplicationScheduleList body) throws ApiException {
        Call call = this.createSchedulesValidateBeforeCall(clusterName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiReplicationScheduleList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createSchedulesAsync(String clusterName, String serviceName, ApiReplicationScheduleList body, final ApiCallback<ApiReplicationScheduleList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSchedulesValidateBeforeCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiReplicationScheduleList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteAllSchedulesCall(String clusterName, String serviceName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteAllSchedulesValidateBeforeCall(String clusterName, String serviceName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling deleteAllSchedules(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling deleteAllSchedules(Async)");
        }
        Call call = this.deleteAllSchedulesCall(clusterName, serviceName, progressListener, progressRequestListener);
        return call;
    }

    public ApiReplicationScheduleList deleteAllSchedules(String clusterName, String serviceName) throws ApiException {
        ApiResponse<ApiReplicationScheduleList> resp = this.deleteAllSchedulesWithHttpInfo(clusterName, serviceName);
        return resp.getData();
    }

    public ApiResponse<ApiReplicationScheduleList> deleteAllSchedulesWithHttpInfo(String clusterName, String serviceName) throws ApiException {
        Call call = this.deleteAllSchedulesValidateBeforeCall(clusterName, serviceName, null, null);
        Type localVarReturnType = new TypeToken<ApiReplicationScheduleList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteAllSchedulesAsync(String clusterName, String serviceName, final ApiCallback<ApiReplicationScheduleList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteAllSchedulesValidateBeforeCall(clusterName, serviceName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiReplicationScheduleList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteScheduleCall(String clusterName, BigDecimal scheduleId, String serviceName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/{scheduleId}".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{scheduleId\\}", this.apiClient.escapeString(scheduleId.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteScheduleValidateBeforeCall(String clusterName, BigDecimal scheduleId, String serviceName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling deleteSchedule(Async)");
        }
        if (scheduleId == null) {
            throw new ApiException("Missing the required parameter 'scheduleId' when calling deleteSchedule(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling deleteSchedule(Async)");
        }
        Call call = this.deleteScheduleCall(clusterName, scheduleId, serviceName, progressListener, progressRequestListener);
        return call;
    }

    public ApiReplicationSchedule deleteSchedule(String clusterName, BigDecimal scheduleId, String serviceName) throws ApiException {
        ApiResponse<ApiReplicationSchedule> resp = this.deleteScheduleWithHttpInfo(clusterName, scheduleId, serviceName);
        return resp.getData();
    }

    public ApiResponse<ApiReplicationSchedule> deleteScheduleWithHttpInfo(String clusterName, BigDecimal scheduleId, String serviceName) throws ApiException {
        Call call = this.deleteScheduleValidateBeforeCall(clusterName, scheduleId, serviceName, null, null);
        Type localVarReturnType = new TypeToken<ApiReplicationSchedule>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteScheduleAsync(String clusterName, BigDecimal scheduleId, String serviceName, final ApiCallback<ApiReplicationSchedule> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteScheduleValidateBeforeCall(clusterName, scheduleId, serviceName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiReplicationSchedule>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getReplicationStateCall(String clusterName, String serviceName, String view, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/replicationState".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getReplicationStateValidateBeforeCall(String clusterName, String serviceName, String view, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling getReplicationState(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling getReplicationState(Async)");
        }
        Call call = this.getReplicationStateCall(clusterName, serviceName, view, progressListener, progressRequestListener);
        return call;
    }

    public ApiReplicationState getReplicationState(String clusterName, String serviceName, String view) throws ApiException {
        ApiResponse<ApiReplicationState> resp = this.getReplicationStateWithHttpInfo(clusterName, serviceName, view);
        return resp.getData();
    }

    public ApiResponse<ApiReplicationState> getReplicationStateWithHttpInfo(String clusterName, String serviceName, String view) throws ApiException {
        Call call = this.getReplicationStateValidateBeforeCall(clusterName, serviceName, view, null, null);
        Type localVarReturnType = new TypeToken<ApiReplicationState>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getReplicationStateAsync(String clusterName, String serviceName, String view, final ApiCallback<ApiReplicationState> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getReplicationStateValidateBeforeCall(clusterName, serviceName, view, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiReplicationState>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readHistoryCall(String clusterName, BigDecimal scheduleId, String serviceName, Integer limit, Integer offset, String view, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/{scheduleId}/history".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{scheduleId\\}", this.apiClient.escapeString(scheduleId.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readHistoryValidateBeforeCall(String clusterName, BigDecimal scheduleId, String serviceName, Integer limit, Integer offset, String view, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling readHistory(Async)");
        }
        if (scheduleId == null) {
            throw new ApiException("Missing the required parameter 'scheduleId' when calling readHistory(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling readHistory(Async)");
        }
        Call call = this.readHistoryCall(clusterName, scheduleId, serviceName, limit, offset, view, progressListener, progressRequestListener);
        return call;
    }

    public ApiReplicationCommandList readHistory(String clusterName, BigDecimal scheduleId, String serviceName, Integer limit, Integer offset, String view) throws ApiException {
        ApiResponse<ApiReplicationCommandList> resp = this.readHistoryWithHttpInfo(clusterName, scheduleId, serviceName, limit, offset, view);
        return resp.getData();
    }

    public ApiResponse<ApiReplicationCommandList> readHistoryWithHttpInfo(String clusterName, BigDecimal scheduleId, String serviceName, Integer limit, Integer offset, String view) throws ApiException {
        Call call = this.readHistoryValidateBeforeCall(clusterName, scheduleId, serviceName, limit, offset, view, null, null);
        Type localVarReturnType = new TypeToken<ApiReplicationCommandList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readHistoryAsync(String clusterName, BigDecimal scheduleId, String serviceName, Integer limit, Integer offset, String view, final ApiCallback<ApiReplicationCommandList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readHistoryValidateBeforeCall(clusterName, scheduleId, serviceName, limit, offset, view, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiReplicationCommandList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readScheduleCall(String clusterName, BigDecimal scheduleId, String serviceName, String view, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/{scheduleId}".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{scheduleId\\}", this.apiClient.escapeString(scheduleId.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readScheduleValidateBeforeCall(String clusterName, BigDecimal scheduleId, String serviceName, String view, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling readSchedule(Async)");
        }
        if (scheduleId == null) {
            throw new ApiException("Missing the required parameter 'scheduleId' when calling readSchedule(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling readSchedule(Async)");
        }
        Call call = this.readScheduleCall(clusterName, scheduleId, serviceName, view, progressListener, progressRequestListener);
        return call;
    }

    public ApiReplicationSchedule readSchedule(String clusterName, BigDecimal scheduleId, String serviceName, String view) throws ApiException {
        ApiResponse<ApiReplicationSchedule> resp = this.readScheduleWithHttpInfo(clusterName, scheduleId, serviceName, view);
        return resp.getData();
    }

    public ApiResponse<ApiReplicationSchedule> readScheduleWithHttpInfo(String clusterName, BigDecimal scheduleId, String serviceName, String view) throws ApiException {
        Call call = this.readScheduleValidateBeforeCall(clusterName, scheduleId, serviceName, view, null, null);
        Type localVarReturnType = new TypeToken<ApiReplicationSchedule>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readScheduleAsync(String clusterName, BigDecimal scheduleId, String serviceName, String view, final ApiCallback<ApiReplicationSchedule> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readScheduleValidateBeforeCall(clusterName, scheduleId, serviceName, view, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiReplicationSchedule>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readSchedulesCall(String clusterName, String serviceName, String view, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readSchedulesValidateBeforeCall(String clusterName, String serviceName, String view, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling readSchedules(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling readSchedules(Async)");
        }
        Call call = this.readSchedulesCall(clusterName, serviceName, view, progressListener, progressRequestListener);
        return call;
    }

    public ApiReplicationScheduleList readSchedules(String clusterName, String serviceName, String view) throws ApiException {
        ApiResponse<ApiReplicationScheduleList> resp = this.readSchedulesWithHttpInfo(clusterName, serviceName, view);
        return resp.getData();
    }

    public ApiResponse<ApiReplicationScheduleList> readSchedulesWithHttpInfo(String clusterName, String serviceName, String view) throws ApiException {
        Call call = this.readSchedulesValidateBeforeCall(clusterName, serviceName, view, null, null);
        Type localVarReturnType = new TypeToken<ApiReplicationScheduleList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readSchedulesAsync(String clusterName, String serviceName, String view, final ApiCallback<ApiReplicationScheduleList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readSchedulesValidateBeforeCall(clusterName, serviceName, view, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiReplicationScheduleList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call runCopyListingCall(String clusterName, String serviceName, String body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/hdfsCopyListing".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call runCopyListingValidateBeforeCall(String clusterName, String serviceName, String body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling runCopyListing(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling runCopyListing(Async)");
        }
        Call call = this.runCopyListingCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand runCopyListing(String clusterName, String serviceName, String body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.runCopyListingWithHttpInfo(clusterName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> runCopyListingWithHttpInfo(String clusterName, String serviceName, String body) throws ApiException {
        Call call = this.runCopyListingValidateBeforeCall(clusterName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call runCopyListingAsync(String clusterName, String serviceName, String body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.runCopyListingValidateBeforeCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call runScheduleCall(String clusterName, BigDecimal scheduleId, String serviceName, Boolean dryRun, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/{scheduleId}/run".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{scheduleId\\}", this.apiClient.escapeString(scheduleId.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "dryRun", dryRun));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call runScheduleValidateBeforeCall(String clusterName, BigDecimal scheduleId, String serviceName, Boolean dryRun, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling runSchedule(Async)");
        }
        if (scheduleId == null) {
            throw new ApiException("Missing the required parameter 'scheduleId' when calling runSchedule(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling runSchedule(Async)");
        }
        Call call = this.runScheduleCall(clusterName, scheduleId, serviceName, dryRun, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand runSchedule(String clusterName, BigDecimal scheduleId, String serviceName, Boolean dryRun) throws ApiException {
        ApiResponse<ApiCommand> resp = this.runScheduleWithHttpInfo(clusterName, scheduleId, serviceName, dryRun);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> runScheduleWithHttpInfo(String clusterName, BigDecimal scheduleId, String serviceName, Boolean dryRun) throws ApiException {
        Call call = this.runScheduleValidateBeforeCall(clusterName, scheduleId, serviceName, dryRun, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call runScheduleAsync(String clusterName, BigDecimal scheduleId, String serviceName, Boolean dryRun, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.runScheduleValidateBeforeCall(clusterName, scheduleId, serviceName, dryRun, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateScheduleCall(String clusterName, BigDecimal scheduleId, String serviceName, ApiReplicationSchedule body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiReplicationSchedule localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/{scheduleId}".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{scheduleId\\}", this.apiClient.escapeString(scheduleId.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateScheduleValidateBeforeCall(String clusterName, BigDecimal scheduleId, String serviceName, ApiReplicationSchedule body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling updateSchedule(Async)");
        }
        if (scheduleId == null) {
            throw new ApiException("Missing the required parameter 'scheduleId' when calling updateSchedule(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling updateSchedule(Async)");
        }
        Call call = this.updateScheduleCall(clusterName, scheduleId, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiReplicationSchedule updateSchedule(String clusterName, BigDecimal scheduleId, String serviceName, ApiReplicationSchedule body) throws ApiException {
        ApiResponse<ApiReplicationSchedule> resp = this.updateScheduleWithHttpInfo(clusterName, scheduleId, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiReplicationSchedule> updateScheduleWithHttpInfo(String clusterName, BigDecimal scheduleId, String serviceName, ApiReplicationSchedule body) throws ApiException {
        Call call = this.updateScheduleValidateBeforeCall(clusterName, scheduleId, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiReplicationSchedule>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateScheduleAsync(String clusterName, BigDecimal scheduleId, String serviceName, ApiReplicationSchedule body, final ApiCallback<ApiReplicationSchedule> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateScheduleValidateBeforeCall(clusterName, scheduleId, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiReplicationSchedule>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

