/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.trace;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletInputStream;
import org.apache.knox.gateway.servlet.SynchronousServletInputStreamAdapter;
import org.apache.knox.gateway.trace.TraceUtil;
import org.apache.log4j.Logger;

class TraceInput
extends SynchronousServletInputStreamAdapter {
    private static final Logger log = Logger.getLogger((String)"org.apache.knox.gateway.http.request");
    private static final Logger bodyLog = Logger.getLogger((String)"org.apache.knox.gateway.http.request.body");
    private ServletInputStream delegate;
    private static final int BUFFER_LIMIT = 1024;
    private StringBuilder buffer = new StringBuilder(1024);

    TraceInput(ServletInputStream delegate) {
        this.delegate = delegate;
    }

    public int read() throws IOException {
        int b = this.delegate.read();
        if (b >= 0) {
            this.buffer.append((char)b);
            if (this.buffer.length() == 1024 || this.delegate.available() == 0) {
                this.traceBody();
            }
        }
        return b;
    }

    public void close() throws IOException {
        this.traceBody();
        this.delegate.close();
    }

    private synchronized void traceBody() {
        if (this.buffer.length() > 0) {
            String body = this.buffer.toString();
            this.buffer.setLength(0);
            StringBuilder sb = new StringBuilder();
            TraceUtil.appendCorrelationContext(sb);
            sb.append(String.format(Locale.ROOT, "|RequestBody[%d]%n\t%s", body.length(), body));
            if (bodyLog.isTraceEnabled()) {
                log.trace((Object)sb.toString());
            }
        }
    }
}

