/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.token.impl;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.token.UnknownTokenException;
import org.apache.knox.gateway.services.token.TokenStateServiceStatistics;
import org.apache.knox.gateway.services.token.impl.DefaultTokenStateService;
import org.apache.knox.gateway.services.token.impl.state.TokenStateJournalFactory;
import org.apache.knox.gateway.services.token.state.JournalEntry;
import org.apache.knox.gateway.services.token.state.TokenStateJournal;

public class AliasBasedTokenStateService
extends DefaultTokenStateService {
    static final String TOKEN_MAX_LIFETIME_POSTFIX = "--max";
    private AliasService aliasService;
    private long statePersistenceInterval = TimeUnit.SECONDS.toSeconds(15L);
    private ScheduledExecutorService statePersistenceScheduler;
    private final List<TokenState> unpersistedState = new ArrayList<TokenState>();
    private final AtomicBoolean readyForEviction = new AtomicBoolean(false);
    private TokenStateJournal journal;
    private Path gatewayCredentialsFilePath;

    public void setAliasService(AliasService aliasService) {
        this.aliasService = aliasService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        super.init(config, options);
        if (this.aliasService == null) {
            throw new ServiceLifecycleException("The required AliasService reference has not been set.");
        }
        try {
            this.journal = TokenStateJournalFactory.create(config);
            List<JournalEntry> entries = this.journal.get();
            for (JournalEntry entry : entries) {
                String id = entry.getTokenId();
                try {
                    long issueTime = Long.parseLong(entry.getIssueTime());
                    long expiration = Long.parseLong(entry.getExpiration());
                    long maxLifetime = Long.parseLong(entry.getMaxLifetime());
                    super.addToken(id, issueTime, expiration, maxLifetime);
                    List<TokenState> list = this.unpersistedState;
                    synchronized (list) {
                        this.unpersistedState.add(new TokenExpiration(id, expiration));
                    }
                }
                catch (Exception e) {
                    log.failedToLoadJournalEntry(id, e);
                }
            }
        }
        catch (IOException e) {
            throw new ServiceLifecycleException("Failed to load persisted state from the token state journal", (Exception)e);
        }
        this.statePersistenceInterval = config.getKnoxTokenStateAliasPersistenceInterval();
        if (this.statePersistenceInterval > 0L) {
            this.statePersistenceScheduler = Executors.newScheduledThreadPool(1);
        }
        if (this.tokenStateServiceStatistics != null) {
            this.gatewayCredentialsFilePath = Paths.get(config.getGatewayKeystoreDir(), new String[0]).resolve("__gateway-credentials." + config.getCredentialStoreType().toLowerCase(Locale.ROOT));
            this.tokenStateServiceStatistics.setGatewayCredentialsFileSize(this.gatewayCredentialsFilePath.toFile().length());
        }
    }

    @Override
    public void start() throws ServiceLifecycleException {
        super.start();
        if (this.statePersistenceScheduler != null) {
            this.statePersistenceScheduler.scheduleAtFixedRate(this::persistTokenState, this.statePersistenceInterval, this.statePersistenceInterval, TimeUnit.SECONDS);
        }
        ExecutorService gatewayCredentialsLoader = Executors.newSingleThreadExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("GatewayCredentialsLoader").build());
        gatewayCredentialsLoader.execute(this::loadGatewayCredentialsOnStartup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGatewayCredentialsOnStartup() {
        try {
            log.loadingGatewayCredentialsOnStartup();
            long start = System.currentTimeMillis();
            Map passwordAliasMap = this.aliasService.getPasswordsForGateway();
            int count = 0;
            for (Map.Entry passwordAliasMapEntry : passwordAliasMap.entrySet()) {
                String alias = (String)passwordAliasMapEntry.getKey();
                if (!alias.endsWith(TOKEN_MAX_LIFETIME_POSTFIX)) continue;
                String tokenId = alias.substring(0, alias.indexOf(TOKEN_MAX_LIFETIME_POSTFIX));
                long expiration = this.convertCharArrayToLong((char[])passwordAliasMap.get(tokenId));
                long maxLifeTime = this.convertCharArrayToLong((char[])passwordAliasMapEntry.getValue());
                super.updateExpiration(tokenId, expiration);
                super.setMaxLifetime(tokenId, maxLifeTime);
                ++count;
            }
            log.loadedGatewayCredentialsOnStartup(count * 2, System.currentTimeMillis() - start);
        }
        catch (AliasServiceException e) {
            log.errorWhileLoadingGatewayCredentialsOnStartup(e.getMessage(), (Exception)((Object)e));
        }
        finally {
            this.readyForEviction.set(true);
        }
    }

    @Override
    protected boolean readyForEviction() {
        return this.readyForEviction.get();
    }

    @Override
    public void stop() throws ServiceLifecycleException {
        super.stop();
        if (this.statePersistenceScheduler != null) {
            this.statePersistenceScheduler.shutdown();
        }
        this.persistTokenState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistTokenState() {
        ArrayList<TokenState> processing;
        HashSet<String> tokenIds = new HashSet<String>();
        List<TokenState> list = this.unpersistedState;
        synchronized (list) {
            processing = new ArrayList<TokenState>(this.unpersistedState);
            this.unpersistedState.clear();
        }
        HashMap<String, String> aliases = new HashMap<String, String>();
        for (TokenState state : processing) {
            tokenIds.add(state.getTokenId());
            aliases.put(state.getAlias(), state.getAliasValue());
        }
        for (String tokenId : tokenIds) {
            log.creatingTokenStateAliases(tokenId);
        }
        if (!aliases.isEmpty()) {
            log.creatingTokenStateAliases();
            try {
                this.aliasService.addAliasesForCluster("__gateway", aliases);
                if (this.tokenStateServiceStatistics != null) {
                    this.tokenStateServiceStatistics.interactKeystore(TokenStateServiceStatistics.KeystoreInteraction.SAVE_ALIAS);
                    this.tokenStateServiceStatistics.setGatewayCredentialsFileSize(this.gatewayCredentialsFilePath.toFile().length());
                }
                for (String tokenId : tokenIds) {
                    log.createdTokenStateAliases(tokenId);
                    try {
                        this.journal.remove(tokenId);
                    }
                    catch (IOException e) {
                        log.failedToRemoveJournalEntry(tokenId, e);
                    }
                }
            }
            catch (AliasServiceException e) {
                log.failedToCreateTokenStateAliases((Exception)((Object)e));
                List<TokenState> list2 = this.unpersistedState;
                synchronized (list2) {
                    this.unpersistedState.addAll(processing);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToken(String tokenId, long issueTime, long expiration, long maxLifetimeDuration) {
        super.addToken(tokenId, issueTime, expiration, maxLifetimeDuration);
        List<TokenState> list = this.unpersistedState;
        synchronized (list) {
            this.unpersistedState.add(new TokenExpiration(tokenId, expiration));
        }
        try {
            this.journal.add(tokenId, issueTime, expiration, maxLifetimeDuration);
        }
        catch (IOException e) {
            log.failedToAddJournalEntry(tokenId, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setMaxLifetime(String tokenId, long issueTime, long maxLifetimeDuration) {
        super.setMaxLifetime(tokenId, issueTime, maxLifetimeDuration);
        List<TokenState> list = this.unpersistedState;
        synchronized (list) {
            this.unpersistedState.add(new TokenMaxLifetime(tokenId, issueTime, maxLifetimeDuration));
        }
    }

    @Override
    protected long getMaxLifetime(String tokenId) {
        long result = super.getMaxLifetime(tokenId);
        if (result < 1L) {
            try {
                char[] maxLifetimeStr = this.getPasswordUsingAliasService(tokenId + TOKEN_MAX_LIFETIME_POSTFIX);
                if (maxLifetimeStr != null) {
                    result = this.convertCharArrayToLong(maxLifetimeStr);
                }
            }
            catch (AliasServiceException e) {
                log.errorAccessingTokenState(tokenId, (Exception)((Object)e));
            }
        }
        return result;
    }

    private char[] getPasswordUsingAliasService(String tokenId) throws AliasServiceException {
        char[] password = this.aliasService.getPasswordFromAliasForCluster("__gateway", tokenId);
        if (this.tokenStateServiceStatistics != null) {
            this.tokenStateServiceStatistics.interactKeystore(TokenStateServiceStatistics.KeystoreInteraction.GET_PASSWORD);
        }
        return password;
    }

    private long convertCharArrayToLong(char[] charArray) {
        return Long.parseLong(new String(charArray));
    }

    @Override
    public long getTokenExpiration(String tokenId, boolean validate) throws UnknownTokenException {
        try {
            return super.getTokenExpiration(tokenId, validate);
        }
        catch (UnknownTokenException unknownTokenException) {
            if (validate) {
                this.validateToken(tokenId);
            }
            long expiration = 0L;
            try {
                char[] expStr = this.getPasswordUsingAliasService(tokenId);
                if (expStr == null) {
                    throw new UnknownTokenException(tokenId);
                }
                expiration = Long.parseLong(new String(expStr));
                super.updateExpiration(tokenId, expiration);
            }
            catch (UnknownTokenException e) {
                throw e;
            }
            catch (Exception e) {
                log.errorAccessingTokenState(tokenId, e);
            }
            return expiration;
        }
    }

    @Override
    protected boolean isUnknown(String tokenId) {
        boolean isUnknown = super.isUnknown(tokenId);
        if (isUnknown) {
            try {
                isUnknown = this.getPasswordUsingAliasService(tokenId) == null;
            }
            catch (AliasServiceException e) {
                log.errorAccessingTokenState(tokenId, (Exception)((Object)e));
            }
        }
        return isUnknown;
    }

    @Override
    protected void removeToken(String tokenId) throws UnknownTokenException {
        this.removeTokens(Collections.singleton(tokenId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeTokens(Set<String> tokenIds) throws UnknownTokenException {
        List<TokenState> list = this.unpersistedState;
        synchronized (list) {
            ArrayList<TokenState> unpersistedToRemove = new ArrayList<TokenState>();
            for (TokenState state : this.unpersistedState) {
                if (!tokenIds.contains(state.getTokenId())) continue;
                unpersistedToRemove.add(state);
            }
            this.unpersistedState.removeAll(unpersistedToRemove);
        }
        HashSet<String> aliasesToRemove = new HashSet<String>(tokenIds);
        for (String tokenId : tokenIds) {
            aliasesToRemove.add(tokenId + TOKEN_MAX_LIFETIME_POSTFIX);
        }
        if (!aliasesToRemove.isEmpty()) {
            log.removingTokenStateAliases();
            try {
                this.aliasService.removeAliasesForCluster("__gateway", aliasesToRemove);
                if (this.tokenStateServiceStatistics != null) {
                    this.tokenStateServiceStatistics.interactKeystore(TokenStateServiceStatistics.KeystoreInteraction.REMOVE_ALIAS);
                    this.tokenStateServiceStatistics.setGatewayCredentialsFileSize(this.gatewayCredentialsFilePath.toFile().length());
                }
                log.removedTokenStateAliases(String.join((CharSequence)", ", tokenIds));
            }
            catch (AliasServiceException e) {
                log.failedToRemoveTokenStateAliases((Exception)((Object)e));
            }
        }
        super.removeTokens(tokenIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateExpiration(String tokenId, long expiration) {
        super.updateExpiration(tokenId, expiration);
        List<TokenState> list = this.unpersistedState;
        synchronized (list) {
            Optional<TokenState> tokenStateToRemove = this.unpersistedState.stream().filter(tokenState -> tokenState.getTokenId().equals(tokenId)).findFirst();
            if (tokenStateToRemove.isPresent()) {
                this.unpersistedState.remove(tokenStateToRemove.get());
            }
            this.unpersistedState.add(new TokenExpiration(tokenId, expiration));
        }
    }

    private static final class TokenExpiration
    implements TokenState {
        private String tokenId;
        private long expiration;

        TokenExpiration(String tokenId, long expiration) {
            this.tokenId = tokenId;
            this.expiration = expiration;
        }

        @Override
        public String getTokenId() {
            return this.tokenId;
        }

        @Override
        public String getAlias() {
            return this.tokenId;
        }

        @Override
        public String getAliasValue() {
            return String.valueOf(this.expiration);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }
    }

    private static final class TokenMaxLifetime
    implements TokenState {
        private String tokenId;
        private long issueTime;
        private long maxLifetime;

        TokenMaxLifetime(String tokenId, long issueTime, long maxLifetime) {
            this.tokenId = tokenId;
            this.issueTime = issueTime;
            this.maxLifetime = maxLifetime;
        }

        @Override
        public String getTokenId() {
            return this.tokenId;
        }

        @Override
        public String getAlias() {
            return this.tokenId + AliasBasedTokenStateService.TOKEN_MAX_LIFETIME_POSTFIX;
        }

        @Override
        public String getAliasValue() {
            return String.valueOf(this.issueTime + this.maxLifetime);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }
    }

    static interface TokenState {
        public String getTokenId();

        public String getAlias();

        public String getAliasValue();
    }
}

