/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.provider.federation.jwt;

import org.apache.knox.gateway.i18n.messages.Message;
import org.apache.knox.gateway.i18n.messages.MessageLevel;
import org.apache.knox.gateway.i18n.messages.Messages;
import org.apache.knox.gateway.i18n.messages.StackTrace;

@Messages(logger="org.apache.knox.gateway.provider.federation.jwt")
public interface JWTMessages {
    @Message(level=MessageLevel.WARN, text="Failed to validate the audience attribute for token {1} ({2})")
    public void failedToValidateAudience(String var1, String var2);

    @Message(level=MessageLevel.WARN, text="Failed to verify the token signature of {1} ({2})")
    public void failedToVerifyTokenSignature(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Access token {1} ({2}) has expired; a new one must be acquired.")
    public void tokenHasExpired(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="The NotBefore check failed.")
    public void notBeforeCheckFailed();

    @Message(level=MessageLevel.WARN, text="Expected Bearer token is missing.")
    public void missingBearerToken();

    @Message(level=MessageLevel.INFO, text="Unable to verify token: {0}")
    public void unableToVerifyToken(@StackTrace(level=MessageLevel.ERROR) Exception var1);

    @Message(level=MessageLevel.WARN, text="Unable to verify token expiration: {0}")
    public void unableToVerifyExpiration(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.ERROR, text="Unable to issue token: {0}")
    public void unableToIssueToken(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.DEBUG, text="Sending redirect to: {0}")
    public void sendRedirectToLoginURL(String var1);

    @Message(level=MessageLevel.WARN, text="Configuration for authentication provider URL is missing - will derive default URL.")
    public void missingAuthenticationProviderUrlConfiguration();

    @Message(level=MessageLevel.DEBUG, text="Audience claim has been validated.")
    public void jwtAudienceValidated();

    @Message(level=MessageLevel.INFO, text="Path {0} is configured as unauthenticated path, letting the request {1} through")
    public void unauthenticatedPathBypass(String var1, String var2);

    @Message(level=MessageLevel.WARN, text="Unable to vderive authentication provider url: {0}")
    public void failedToDeriveAuthenticationProviderUrl(@StackTrace(level=MessageLevel.ERROR) Exception var1);
}

