/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.j2e.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.engine.DefaultLogoutLogic;
import org.pac4j.core.engine.LogoutLogic;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.j2e.filter.AbstractConfigFilter;

public class LogoutFilter
extends AbstractConfigFilter {
    private LogoutLogic<Object, J2EContext> logoutLogic = new DefaultLogoutLogic();
    private String defaultUrl;
    private String logoutUrlPattern;
    private Boolean localLogout;
    private Boolean destroySession;
    private Boolean centralLogout;

    public LogoutFilter() {
    }

    public LogoutFilter(Config config) {
        this.setConfig(config);
    }

    public LogoutFilter(Config config, String defaultUrl) {
        this(config);
        this.defaultUrl = defaultUrl;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.defaultUrl = this.getStringParam(filterConfig, "defaultUrl", this.defaultUrl);
        this.logoutUrlPattern = this.getStringParam(filterConfig, "logoutUrlPattern", this.logoutUrlPattern);
        this.localLogout = this.getBooleanParam(filterConfig, "localLogout", this.localLogout);
        this.destroySession = this.getBooleanParam(filterConfig, "destroySession", this.destroySession);
        this.centralLogout = this.getBooleanParam(filterConfig, "centralLogout", this.centralLogout);
    }

    @Override
    protected void internalFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        CommonHelper.assertNotNull((String)"applicationLogoutLogic", this.logoutLogic);
        Config config = this.getConfig();
        CommonHelper.assertNotNull((String)"config", (Object)config);
        J2EContext context = new J2EContext(request, response, config.getSessionStore());
        this.retrieveLogoutLogic().perform((WebContext)context, config, this.retrieveHttpActionAdapter(), this.defaultUrl, this.logoutUrlPattern, this.localLogout, this.destroySession, this.centralLogout);
    }

    protected LogoutLogic<Object, J2EContext> retrieveLogoutLogic() {
        LogoutLogic configLogoutLogic;
        if (this.getConfig() != null && (configLogoutLogic = this.getConfig().getLogoutLogic()) != null) {
            return configLogoutLogic;
        }
        return this.logoutLogic;
    }

    public String getDefaultUrl() {
        return this.defaultUrl;
    }

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public String getLogoutUrlPattern() {
        return this.logoutUrlPattern;
    }

    public void setLogoutUrlPattern(String logoutUrlPattern) {
        this.logoutUrlPattern = logoutUrlPattern;
    }

    public LogoutLogic<Object, J2EContext> getLogoutLogic() {
        return this.logoutLogic;
    }

    public void setLogoutLogic(LogoutLogic<Object, J2EContext> logoutLogic) {
        this.logoutLogic = logoutLogic;
    }

    public Boolean getLocalLogout() {
        return this.localLogout;
    }

    public void setLocalLogout(Boolean localLogout) {
        this.localLogout = localLogout;
    }

    public Boolean getDestroySession() {
        return this.destroySession;
    }

    public void setDestroySession(Boolean destroySession) {
        this.destroySession = destroySession;
    }

    public Boolean getCentralLogout() {
        return this.centralLogout;
    }

    public void setCentralLogout(Boolean centralLogout) {
        this.centralLogout = centralLogout;
    }
}

