"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const schematics_1 = require("@angular-devkit/schematics");
exports.configPath = '/.angular-cli.json';
function getConfig(host) {
    const configBuffer = host.read(exports.configPath);
    if (configBuffer === null) {
        throw new schematics_1.SchematicsException('Could not find .angular-cli.json');
    }
    const config = JSON.parse(configBuffer.toString());
    return config;
}
exports.getConfig = getConfig;
function getAppFromConfig(config, appIndexOrName) {
    if (!config.apps) {
        return null;
    }
    if (parseInt(appIndexOrName) >= 0) {
        return config.apps[parseInt(appIndexOrName)];
    }
    return config.apps.filter((app) => app.name === appIndexOrName)[0];
}
exports.getAppFromConfig = getAppFromConfig;
//# sourceMappingURL=data:application/json;base64,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