/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@angular/core"),require("@angular/cdk/coercion"),require("@angular/cdk/table"),require("rxjs/observable/merge"),require("@angular/material/core"),require("rxjs/Subject"),require("@angular/animations"),require("@angular/common")):"function"==typeof define&&define.amd?define(["exports","@angular/core","@angular/cdk/coercion","@angular/cdk/table","rxjs/observable/merge","@angular/material/core","rxjs/Subject","@angular/animations","@angular/common"],e):e((t.ng=t.ng||{},t.ng.material=t.ng.material||{},t.ng.material.sort=t.ng.material.sort||{}),t.ng.core,t.ng.cdk.coercion,t.ng.cdk.table,t.Rx.Observable,t.ng.material.core,t.Rx,t.ng.animations,t.ng.common)}(this,function(t,e,r,i,a,o,n,s,c){"use strict";function d(t,e){function r(){this.constructor=t}g(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}function l(t){return Error("Cannot have two MatSortables with the same id ("+t+").")}function h(){return Error("MatSortHeader must be placed within a parent element with the MatSort directive.")}function u(){return Error("MatSortHeader must be provided with a unique id.")}function p(t){return Error(t+" is not a valid sort direction ('asc' or 'desc').")}function m(t,e){var r=["asc","desc"];return"desc"==t&&r.reverse(),e||r.push(""),r}function f(t){return t||new S}var g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var r in e)e.hasOwnProperty(r)&&(t[r]=e[r])},_=function(){function t(){}return t}(),b=o.mixinDisabled(_),y=function(t){function i(){var r=null!==t&&t.apply(this,arguments)||this;return r.sortables=new Map,r._stateChanges=new n.Subject,r.start="asc",r._direction="",r.sortChange=new e.EventEmitter,r}return d(i,t),Object.defineProperty(i.prototype,"direction",{get:function(){return this._direction},set:function(t){if(e.isDevMode()&&t&&"asc"!==t&&"desc"!==t)throw p(t);this._direction=t},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"disableClear",{get:function(){return this._disableClear},set:function(t){this._disableClear=r.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),i.prototype.register=function(t){if(!t.id)throw u();if(this.sortables.has(t.id))throw l(t.id);this.sortables.set(t.id,t)},i.prototype.deregister=function(t){this.sortables.delete(t.id)},i.prototype.sort=function(t){this.active!=t.id?(this.active=t.id,this.direction=t.start?t.start:this.start):this.direction=this.getNextSortDirection(t),this.sortChange.emit({active:this.active,direction:this.direction})},i.prototype.getNextSortDirection=function(t){if(!t)return"";var e=null!=t.disableClear?t.disableClear:this.disableClear,r=m(t.start||this.start,e),i=r.indexOf(this.direction)+1;return i>=r.length&&(i=0),r[i]},i.prototype.ngOnChanges=function(){this._stateChanges.next()},i.prototype.ngOnDestroy=function(){this._stateChanges.complete()},i.decorators=[{type:e.Directive,args:[{selector:"[matSort]",exportAs:"matSort",inputs:["disabled: matSortDisabled"]}]}],i.ctorParameters=function(){return[]},i.propDecorators={active:[{type:e.Input,args:["matSortActive"]}],start:[{type:e.Input,args:["matSortStart"]}],direction:[{type:e.Input,args:["matSortDirection"]}],disableClear:[{type:e.Input,args:["matSortDisableClear"]}],sortChange:[{type:e.Output,args:["matSortChange"]}]},i}(b),S=function(){function t(){this.changes=new n.Subject,this.sortButtonLabel=function(t){return"Change sorting for "+t},this.sortDescriptionLabel=function(t,e){return"Sorted by "+t+" "+("asc"==e?"ascending":"descending")}}return t.decorators=[{type:e.Injectable}],t.ctorParameters=function(){return[]},t}(),v={provide:S,deps:[[new e.Optional,new e.SkipSelf,S]],useFactory:f},w=o.AnimationDurations.ENTERING+" "+o.AnimationCurves.STANDARD_CURVE,D={indicator:s.trigger("indicator",[s.state("active-asc, asc",s.style({transform:"translateY(0px)"})),s.state("active-desc, desc",s.style({transform:"translateY(10px)"})),s.transition("active-asc <=> active-desc",s.animate(w))]),leftPointer:s.trigger("leftPointer",[s.state("active-asc, asc",s.style({transform:"rotate(-45deg)"})),s.state("active-desc, desc",s.style({transform:"rotate(45deg)"})),s.transition("active-asc <=> active-desc",s.animate(w))]),rightPointer:s.trigger("rightPointer",[s.state("active-asc, asc",s.style({transform:"rotate(45deg)"})),s.state("active-desc, desc",s.style({transform:"rotate(-45deg)"})),s.transition("active-asc <=> active-desc",s.animate(w))]),arrowOpacity:s.trigger("arrowOpacity",[s.state("desc-to-active, asc-to-active, active",s.style({opacity:1})),s.state("desc-to-hint, asc-to-hint, hint",s.style({opacity:.54})),s.state("hint-to-desc, active-to-desc, desc, hint-to-asc, active-to-asc, asc",s.style({opacity:0})),s.transition("* => asc, * => desc, * => active, * => hint",s.animate("0ms")),s.transition("* <=> *",s.animate(w))]),arrowPosition:s.trigger("arrowPosition",[s.transition("* => desc-to-hint, * => desc-to-active",s.animate(w,s.keyframes([s.style({transform:"translateY(-25%)"}),s.style({transform:"translateY(0)"})]))),s.transition("* => hint-to-desc, * => active-to-desc",s.animate(w,s.keyframes([s.style({transform:"translateY(0)"}),s.style({transform:"translateY(25%)"})]))),s.transition("* => asc-to-hint, * => asc-to-active",s.animate(w,s.keyframes([s.style({transform:"translateY(25%)"}),s.style({transform:"translateY(0)"})]))),s.transition("* => hint-to-asc, * => active-to-asc",s.animate(w,s.keyframes([s.style({transform:"translateY(0)"}),s.style({transform:"translateY(-25%)"})]))),s.state("desc-to-hint, asc-to-hint, hint, desc-to-active, asc-to-active, active",s.style({transform:"translateY(0)"})),s.state("hint-to-desc, active-to-desc, desc",s.style({transform:"translateY(-25%)"})),s.state("hint-to-asc, active-to-asc, asc",s.style({transform:"translateY(25%)"}))]),allowChildren:s.trigger("allowChildren",[s.transition("* <=> *",[s.query("@*",s.animateChild(),{optional:!0})])])},C=function(){function t(){}return t}(),x=o.mixinDisabled(C),A=function(t){function o(e,r,i,o){var n=t.call(this)||this;if(n._intl=e,n._sort=i,n._cdkColumnDef=o,n._showIndicatorHint=!1,n._arrowDirection="",n._disableViewStateAnimation=!1,n.arrowPosition="after",!i)throw h();return n._rerenderSubscription=a.merge(i.sortChange,i._stateChanges,e.changes).subscribe(function(){n._isSorted()&&n._updateArrowDirection(),!n._isSorted()&&n._viewState&&"active"===n._viewState.toState&&(n._disableViewStateAnimation=!1,n._setAnimationTransitionState({fromState:"active",toState:n._arrowDirection})),r.markForCheck()}),n}return d(o,t),Object.defineProperty(o.prototype,"disableClear",{get:function(){return this._disableClear},set:function(t){this._disableClear=r.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),o.prototype.ngOnInit=function(){!this.id&&this._cdkColumnDef&&(this.id=this._cdkColumnDef.name),this._updateArrowDirection(),this._setAnimationTransitionState({toState:this._isSorted()?"active":this._arrowDirection}),this._sort.register(this)},o.prototype.ngOnDestroy=function(){this._sort.deregister(this),this._rerenderSubscription.unsubscribe()},o.prototype._setIndicatorHintVisible=function(t){this._isDisabled()&&t||(this._showIndicatorHint=t,this._isSorted()||(this._updateArrowDirection(),this._showIndicatorHint?this._setAnimationTransitionState({fromState:this._arrowDirection,toState:"hint"}):this._setAnimationTransitionState({fromState:"hint",toState:this._arrowDirection})))},o.prototype._setAnimationTransitionState=function(t){this._viewState=t,this._disableViewStateAnimation&&(this._viewState={toState:t.toState})},o.prototype._handleClick=function(){if(!this._isDisabled()){this._sort.sort(this),"hint"!==this._viewState.toState&&"active"!==this._viewState.toState||(this._disableViewStateAnimation=!0);var t=this._isSorted()?{fromState:this._arrowDirection,toState:"active"}:{fromState:"active",toState:this._arrowDirection};this._setAnimationTransitionState(t),this._showIndicatorHint=!1}},o.prototype._isSorted=function(){return this._sort.active==this.id&&("asc"===this._sort.direction||"desc"===this._sort.direction)},o.prototype._getArrowDirectionState=function(){return(this._isSorted()?"active-":"")+this._arrowDirection},o.prototype._getArrowViewState=function(){var t=this._viewState.fromState;return(t?t+"-to-":"")+this._viewState.toState},o.prototype._updateArrowDirection=function(){this._arrowDirection=this._isSorted()?this._sort.direction:this.start||this._sort.start},o.prototype._isDisabled=function(){return this._sort.disabled||this.disabled},o.decorators=[{type:e.Component,args:[{selector:"[mat-sort-header]",exportAs:"matSortHeader",template:'<div class="mat-sort-header-container" [class.mat-sort-header-sorted]="_isSorted()" [class.mat-sort-header-position-before]="arrowPosition == \'before\'"><button class="mat-sort-header-button" type="button" [attr.disabled]="_isDisabled() || null" [attr.aria-label]="_intl.sortButtonLabel(id)" (focus)="_setIndicatorHintVisible(true)" (blur)="_setIndicatorHintVisible(false)"><ng-content></ng-content></button><div class="mat-sort-header-arrow" [@arrowOpacity]="_getArrowViewState()" [@arrowPosition]="_getArrowViewState()" [@allowChildren]="_getArrowDirectionState()" (@arrowPosition.start)="_disableViewStateAnimation = true" (@arrowPosition.done)="_disableViewStateAnimation = false"><div class="mat-sort-header-stem"></div><div class="mat-sort-header-indicator" [@indicator]="_getArrowDirectionState()"><div class="mat-sort-header-pointer-left" [@leftPointer]="_getArrowDirectionState()"></div><div class="mat-sort-header-pointer-right" [@rightPointer]="_getArrowDirectionState()"></div><div class="mat-sort-header-pointer-middle"></div></div></div></div><span class="cdk-visually-hidden" *ngIf="_isSorted()">&nbsp;{{_intl.sortDescriptionLabel(id, _sort.direction)}}</span>',styles:[".mat-sort-header-container{display:flex;cursor:pointer}.mat-sort-header-disabled .mat-sort-header-container{cursor:default}.mat-sort-header-position-before{flex-direction:row-reverse}.mat-sort-header-button{border:none;background:0 0;display:flex;align-items:center;padding:0;cursor:inherit;outline:0;font:inherit;color:currentColor}.mat-sort-header-arrow{height:12px;width:12px;min-width:12px;margin:0 0 0 6px;position:relative;display:flex}.mat-sort-header-position-before .mat-sort-header-arrow{margin:0 6px 0 0}.mat-sort-header-stem{background:currentColor;height:10px;width:2px;margin:auto;display:flex;align-items:center}.mat-sort-header-indicator{width:100%;height:2px;display:flex;align-items:center;position:absolute;top:0;left:0}.mat-sort-header-pointer-middle{margin:auto;height:2px;width:2px;background:currentColor;transform:rotate(45deg)}.mat-sort-header-pointer-left,.mat-sort-header-pointer-right{background:currentColor;width:6px;height:2px;position:absolute;top:0}.mat-sort-header-pointer-left{transform-origin:right;left:0}.mat-sort-header-pointer-right{transform-origin:left;right:0}"],host:{"(click)":"_handleClick()","(mouseenter)":"_setIndicatorHintVisible(true)","(longpress)":"_setIndicatorHintVisible(true)","(mouseleave)":"_setIndicatorHintVisible(false)","[class.mat-sort-header-disabled]":"_isDisabled()"},encapsulation:e.ViewEncapsulation.None,preserveWhitespaces:!1,changeDetection:e.ChangeDetectionStrategy.OnPush,inputs:["disabled"],animations:[D.indicator,D.leftPointer,D.rightPointer,D.arrowOpacity,D.arrowPosition,D.allowChildren]}]}],o.ctorParameters=function(){return[{type:S},{type:e.ChangeDetectorRef},{type:y,decorators:[{type:e.Optional}]},{type:i.CdkColumnDef,decorators:[{type:e.Optional}]}]},o.propDecorators={id:[{type:e.Input,args:["mat-sort-header"]}],arrowPosition:[{type:e.Input}],start:[{type:e.Input}],disableClear:[{type:e.Input}]},o}(x),P=function(){function t(){}return t.decorators=[{type:e.NgModule,args:[{imports:[c.CommonModule],exports:[y,A],declarations:[y,A],providers:[v]}]}],t.ctorParameters=function(){return[]},t}();t.MatSortModule=P,t.MatSortHeaderBase=C,t._MatSortHeaderMixinBase=x,t.MatSortHeader=A,t.MatSortHeaderIntl=S,t.MAT_SORT_HEADER_INTL_PROVIDER_FACTORY=f,t.MAT_SORT_HEADER_INTL_PROVIDER=v,t.MatSortBase=_,t._MatSortMixinBase=b,t.MatSort=y,t.matSortAnimations=D,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=material-sort.umd.min.js.map
