/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/common"),require("@angular/core"),require("@angular/material/button"),require("@angular/material/select"),require("@angular/material/tooltip"),require("@angular/cdk/coercion"),require("rxjs/Subject")):"function"==typeof define&&define.amd?define(["exports","@angular/common","@angular/core","@angular/material/button","@angular/material/select","@angular/material/tooltip","@angular/cdk/coercion","rxjs/Subject"],t):t((e.ng=e.ng||{},e.ng.material=e.ng.material||{},e.ng.material.paginator=e.ng.material.paginator||{}),e.ng.common,e.ng.core,e.ng.material.button,e.ng.material.select,e.ng.material.tooltip,e.ng.cdk.coercion,e.Rx)}(this,function(e,t,a,i,n,o,r,s){"use strict";function p(e){return e||new g}var g=function(){function e(){this.changes=new s.Subject,this.itemsPerPageLabel="Items per page:",this.nextPageLabel="Next page",this.previousPageLabel="Previous page",this.firstPageLabel="First page",this.lastPageLabel="Last page",this.getRangeLabel=function(e,t,a){if(0==a||0==t)return"0 of "+a;a=Math.max(a,0);var i=e*t;return i+1+" - "+(i<a?Math.min(i+t,a):i+t)+" of "+a}}return e.decorators=[{type:a.Injectable}],e.ctorParameters=function(){return[]},e}(),l={provide:g,deps:[[new a.Optional,new a.SkipSelf,g]],useFactory:p},u=function(){function e(){}return e}(),c=function(){function e(e,t){var i=this;this._intl=e,this._changeDetectorRef=t,this._pageIndex=0,this._length=0,this._pageSizeOptions=[],this._hidePageSize=!1,this._showFirstLastButtons=!1,this.page=new a.EventEmitter,this._intlChanges=e.changes.subscribe(function(){return i._changeDetectorRef.markForCheck()})}return Object.defineProperty(e.prototype,"pageIndex",{get:function(){return this._pageIndex},set:function(e){this._pageIndex=r.coerceNumberProperty(e),this._changeDetectorRef.markForCheck()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"length",{get:function(){return this._length},set:function(e){this._length=r.coerceNumberProperty(e),this._changeDetectorRef.markForCheck()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"pageSize",{get:function(){return this._pageSize},set:function(e){this._pageSize=r.coerceNumberProperty(e),this._updateDisplayedPageSizeOptions()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"pageSizeOptions",{get:function(){return this._pageSizeOptions},set:function(e){this._pageSizeOptions=(e||[]).map(function(e){return r.coerceNumberProperty(e)}),this._updateDisplayedPageSizeOptions()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"hidePageSize",{get:function(){return this._hidePageSize},set:function(e){this._hidePageSize=r.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"showFirstLastButtons",{get:function(){return this._showFirstLastButtons},set:function(e){this._showFirstLastButtons=r.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),e.prototype.ngOnInit=function(){this._initialized=!0,this._updateDisplayedPageSizeOptions()},e.prototype.ngOnDestroy=function(){this._intlChanges.unsubscribe()},e.prototype.nextPage=function(){this.hasNextPage()&&(this.pageIndex++,this._emitPageEvent())},e.prototype.previousPage=function(){this.hasPreviousPage()&&(this.pageIndex--,this._emitPageEvent())},e.prototype.firstPage=function(){this.hasPreviousPage()&&(this.pageIndex=0,this._emitPageEvent())},e.prototype.lastPage=function(){this.hasNextPage()&&(this.pageIndex=this.getNumberOfPages(),this._emitPageEvent())},e.prototype.hasPreviousPage=function(){return this.pageIndex>=1&&0!=this.pageSize},e.prototype.hasNextPage=function(){var e=this.getNumberOfPages();return this.pageIndex<e&&0!=this.pageSize},e.prototype.getNumberOfPages=function(){return Math.ceil(this.length/this.pageSize)-1},e.prototype._changePageSize=function(e){var t=this.pageIndex*this.pageSize;this.pageIndex=Math.floor(t/e)||0,this.pageSize=e,this._emitPageEvent()},e.prototype._updateDisplayedPageSizeOptions=function(){this._initialized&&(this.pageSize||(this._pageSize=0!=this.pageSizeOptions.length?this.pageSizeOptions[0]:50),this._displayedPageSizeOptions=this.pageSizeOptions.slice(),-1==this._displayedPageSizeOptions.indexOf(this.pageSize)&&this._displayedPageSizeOptions.push(this.pageSize),this._displayedPageSizeOptions.sort(function(e,t){return e-t}),this._changeDetectorRef.markForCheck())},e.prototype._emitPageEvent=function(){this.page.emit({pageIndex:this.pageIndex,pageSize:this.pageSize,length:this.length})},e.decorators=[{type:a.Component,args:[{selector:"mat-paginator",exportAs:"matPaginator",template:'<div class="mat-paginator-container"><div class="mat-paginator-page-size" *ngIf="!hidePageSize"><div class="mat-paginator-page-size-label">{{_intl.itemsPerPageLabel}}</div><mat-form-field *ngIf="_displayedPageSizeOptions.length > 1" class="mat-paginator-page-size-select"><mat-select [value]="pageSize" [aria-label]="_intl.itemsPerPageLabel" (change)="_changePageSize($event.value)"><mat-option *ngFor="let pageSizeOption of _displayedPageSizeOptions" [value]="pageSizeOption">{{pageSizeOption}}</mat-option></mat-select></mat-form-field><div *ngIf="_displayedPageSizeOptions.length <= 1">{{pageSize}}</div></div><div class="mat-paginator-range-actions"><div class="mat-paginator-range-label">{{_intl.getRangeLabel(pageIndex, pageSize, length)}}</div><button mat-icon-button type="button" class="mat-paginator-navigation-first" (click)="firstPage()" [attr.aria-label]="_intl.firstPageLabel" [matTooltip]="_intl.firstPageLabel" [matTooltipPosition]="\'above\'" [disabled]="!hasPreviousPage()" *ngIf="showFirstLastButtons"><svg class="mat-paginator-icon" viewBox="0 0 24 24" focusable="false"><path d="M18.41 16.59L13.82 12l4.59-4.59L17 6l-6 6 6 6zM6 6h2v12H6z"/></svg></button> <button mat-icon-button type="button" class="mat-paginator-navigation-previous" (click)="previousPage()" [attr.aria-label]="_intl.previousPageLabel" [matTooltip]="_intl.previousPageLabel" [matTooltipPosition]="\'above\'" [disabled]="!hasPreviousPage()"><svg class="mat-paginator-icon" viewBox="0 0 24 24" focusable="false"><path d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"/></svg></button> <button mat-icon-button type="button" class="mat-paginator-navigation-next" (click)="nextPage()" [attr.aria-label]="_intl.nextPageLabel" [matTooltip]="_intl.nextPageLabel" [matTooltipPosition]="\'above\'" [disabled]="!hasNextPage()"><svg class="mat-paginator-icon" viewBox="0 0 24 24" focusable="false"><path d="M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6z"/></svg></button> <button mat-icon-button type="button" class="mat-paginator-navigation-last" (click)="lastPage()" [attr.aria-label]="_intl.lastPageLabel" [matTooltip]="_intl.lastPageLabel" [matTooltipPosition]="\'above\'" [disabled]="!hasNextPage()" *ngIf="showFirstLastButtons"><svg class="mat-paginator-icon" viewBox="0 0 24 24" focusable="false"><path d="M5.59 7.41L10.18 12l-4.59 4.59L7 18l6-6-6-6zM16 6h2v12h-2z"/></svg></button></div></div>',styles:[".mat-paginator{display:block}.mat-paginator-container{display:flex;align-items:center;justify-content:flex-end;min-height:56px;padding:0 8px;flex-wrap:wrap-reverse}.mat-paginator-page-size{display:flex;align-items:baseline;margin-right:8px}.mat-paginator-page-size-label{margin:0 4px}.mat-paginator-page-size-select{margin:6px 4px 0 4px;width:56px}.mat-paginator-range-label{margin:0 32px 0 24px}.mat-paginator-range-actions{display:flex;align-items:center;min-height:48px}.mat-paginator-icon{width:28px;fill:currentColor}[dir=rtl] .mat-paginator-icon{transform:rotate(180deg)}"],host:{class:"mat-paginator"},changeDetection:a.ChangeDetectionStrategy.OnPush,encapsulation:a.ViewEncapsulation.None,preserveWhitespaces:!1}]}],e.ctorParameters=function(){return[{type:g},{type:a.ChangeDetectorRef}]},e.propDecorators={pageIndex:[{type:a.Input}],length:[{type:a.Input}],pageSize:[{type:a.Input}],pageSizeOptions:[{type:a.Input}],hidePageSize:[{type:a.Input}],showFirstLastButtons:[{type:a.Input}],page:[{type:a.Output}]},e}(),h=function(){function e(){}return e.decorators=[{type:a.NgModule,args:[{imports:[t.CommonModule,i.MatButtonModule,n.MatSelectModule,o.MatTooltipModule],exports:[c],declarations:[c],providers:[l]}]}],e.ctorParameters=function(){return[]},e}();e.MatPaginatorModule=h,e.PageEvent=u,e.MatPaginator=c,e.MatPaginatorIntl=g,e.MAT_PAGINATOR_INTL_PROVIDER_FACTORY=p,e.MAT_PAGINATOR_INTL_PROVIDER=l,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=material-paginator.umd.min.js.map
