/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.provider.federation.jwt.filter;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.text.ParseException;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.filter.security.AbstractIdentityAssertionFilter;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.provider.federation.jwt.JWTMessages;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.registry.ServiceRegistry;
import org.apache.knox.gateway.services.security.token.JWTokenAuthority;
import org.apache.knox.gateway.services.security.token.TokenServiceException;
import org.apache.knox.gateway.services.security.token.impl.JWT;
import org.apache.knox.gateway.services.security.token.impl.JWTToken;
import org.apache.knox.gateway.util.JsonUtils;

public class JWTAccessTokenAssertionFilter
extends AbstractIdentityAssertionFilter {
    private static final String SVC_URL = "svc";
    private static final String EXPIRES_IN = "expires_in";
    private static final String TOKEN_TYPE = "token_type";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String BEARER = "Bearer ";
    private static JWTMessages log = (JWTMessages)MessagesFactory.get(JWTMessages.class);
    private long validity;
    private JWTokenAuthority authority;
    private ServiceRegistry sr;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        String validityStr = filterConfig.getInitParameter("validity");
        if (validityStr == null) {
            validityStr = "3600";
        }
        this.validity = Long.parseLong(validityStr);
        GatewayServices services = (GatewayServices)filterConfig.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        this.authority = (JWTokenAuthority)services.getService(ServiceType.TOKEN_SERVICE);
        this.sr = (ServiceRegistry)services.getService(ServiceType.SERVICE_REGISTRY_SERVICE);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String header = ((HttpServletRequest)request).getHeader("Authorization");
        if (header != null && header.startsWith(BEARER)) {
            JWTToken token;
            String wireToken = header.substring(BEARER.length());
            try {
                token = JWTToken.parseToken((String)wireToken);
            }
            catch (ParseException e) {
                throw new ServletException("ParseException encountered while processing the JWT token: ", (Throwable)e);
            }
            if (token != null) {
                try {
                    this.authority.verifyToken((JWT)token);
                }
                catch (TokenServiceException e) {
                    log.unableToVerifyToken((Exception)((Object)e));
                }
            } else {
                throw new ServletException("Expected JWT Token not provided as Bearer token");
            }
            Subject subject = Subject.getSubject(AccessController.getContext());
            String principalName = this.getPrincipalName(subject);
            principalName = this.mapper.mapUserPrincipal(principalName);
            long expires = System.currentTimeMillis() + this.validity * 1000L;
            String serviceName = request.getParameter("service-name");
            String clusterName = request.getParameter("cluster-name");
            String accessToken = this.getAccessToken(principalName, serviceName, expires);
            String serviceURL = this.sr.lookupServiceURL(clusterName, serviceName);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(ACCESS_TOKEN, accessToken);
            map.put(TOKEN_TYPE, BEARER);
            map.put(EXPIRES_IN, expires);
            map.put(SVC_URL, serviceURL);
            String jsonResponse = JsonUtils.renderAsJsonString(map);
            response.getWriter().write(jsonResponse);
        } else {
            ((HttpServletResponse)response).sendError(401);
        }
    }

    private String getAccessToken(final String principalName, String serviceName, long expires) {
        String accessToken = null;
        Principal p = new Principal(){

            @Override
            public String getName() {
                return principalName;
            }
        };
        try {
            JWT token = this.authority.issueToken(p, serviceName, "RS256", expires);
            if (token != null) {
                accessToken = token.toString();
            }
        }
        catch (TokenServiceException e) {
            log.unableToIssueToken((Exception)((Object)e));
        }
        return accessToken;
    }
}

