/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.ext.saml2alg.DigestMethod;
import org.opensaml.saml.ext.saml2alg.SigningMethod;
import org.opensaml.saml.ext.saml2mdreqinit.RequestInitiator;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.pac4j.saml.crypto.CredentialProvider;
import org.pac4j.saml.metadata.SAML2ServiceProvicerRequestedAttribute;
import org.pac4j.saml.metadata.SAMLMetadataGenerator;
import org.pac4j.saml.util.Configuration;
import org.pac4j.saml.util.SAML2Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML2MetadataGenerator
implements SAMLMetadataGenerator {
    protected static final Logger logger = LoggerFactory.getLogger(SAML2MetadataGenerator.class);
    protected final XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
    protected final MarshallerFactory marshallerFactory = Configuration.getMarshallerFactory();
    protected final AlgorithmRegistry globalAlgorithmRegistry = AlgorithmSupport.getGlobalAlgorithmRegistry();
    protected CredentialProvider credentialProvider;
    protected String entityId;
    protected String assertionConsumerServiceUrl;
    protected String singleLogoutServiceUrl;
    protected boolean authnRequestSigned = false;
    protected boolean wantAssertionSigned = true;
    protected int defaultACSIndex = 0;
    protected String requestInitiatorLocation = null;
    protected String nameIdPolicyFormat = null;
    protected List<SAML2ServiceProvicerRequestedAttribute> requestedAttributes = new ArrayList<SAML2ServiceProvicerRequestedAttribute>();
    protected SignatureSigningConfiguration defaultSignatureSigningConfiguration = DefaultSecurityConfigurationBootstrap.buildDefaultSignatureSigningConfiguration();
    protected List<String> blackListedSignatureSigningAlgorithms = null;
    protected List<String> signatureAlgorithms = null;
    protected List<String> signatureReferenceDigestMethods = null;

    @Override
    public final MetadataResolver buildMetadataResolver(Resource metadataResource) throws Exception {
        FilesystemMetadataResolver resolver;
        if (metadataResource != null) {
            resolver = new FilesystemMetadataResolver(metadataResource.getFile());
        } else {
            EntityDescriptor md = this.buildEntityDescriptor();
            Element entityDescriptorElement = this.marshallerFactory.getMarshaller((XMLObject)md).marshall((XMLObject)md);
            resolver = new DOMMetadataResolver(entityDescriptorElement);
        }
        resolver.setRequireValidMetadata(true);
        resolver.setFailFastInitialization(true);
        resolver.setId(resolver.getClass().getCanonicalName());
        resolver.setParserPool(Configuration.getParserPool());
        resolver.initialize();
        return resolver;
    }

    @Override
    public final String getMetadata(EntityDescriptor entityDescriptor) throws Exception {
        Element entityDescriptorElement = this.marshallerFactory.getMarshaller(EntityDescriptor.DEFAULT_ELEMENT_NAME).marshall((XMLObject)entityDescriptor);
        return SerializeSupport.nodeToString((Node)entityDescriptorElement);
    }

    @Override
    public final EntityDescriptor buildEntityDescriptor() {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        EntityDescriptor descriptor = (EntityDescriptor)builder.buildObject();
        descriptor.setEntityID(this.entityId);
        descriptor.setValidUntil(DateTime.now((DateTimeZone)DateTimeZone.UTC).plusYears(20));
        descriptor.setID(SAML2Utils.generateID());
        descriptor.setExtensions(this.generateMetadataExtensions());
        descriptor.getRoleDescriptors().add(this.buildSPSSODescriptor());
        return descriptor;
    }

    protected final Extensions generateMetadataExtensions() {
        SAMLObjectBuilder builderExt = (SAMLObjectBuilder)this.builderFactory.getBuilder(Extensions.DEFAULT_ELEMENT_NAME);
        Extensions extensions = (Extensions)builderExt.buildObject();
        extensions.getNamespaceManager().registerAttributeName(SigningMethod.TYPE_NAME);
        extensions.getNamespaceManager().registerAttributeName(DigestMethod.TYPE_NAME);
        List<String> filteredSignatureAlgorithms = this.filterSignatureAlgorithms(this.getSignatureAlgorithms());
        List<String> filteredSignatureReferenceDigestMethods = this.filterSignatureAlgorithms(this.getSignatureReferenceDigestMethods());
        SAMLObjectBuilder signingMethodBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(SigningMethod.DEFAULT_ELEMENT_NAME);
        for (String signingMethod : filteredSignatureAlgorithms) {
            SigningMethod method = (SigningMethod)signingMethodBuilder.buildObject();
            method.setAlgorithm(signingMethod);
            extensions.getUnknownXMLObjects().add(method);
        }
        SAMLObjectBuilder digestMethodBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(DigestMethod.DEFAULT_ELEMENT_NAME);
        for (String digestMethod : filteredSignatureReferenceDigestMethods) {
            DigestMethod method = (DigestMethod)digestMethodBuilder.buildObject();
            method.setAlgorithm(digestMethod);
            extensions.getUnknownXMLObjects().add(method);
        }
        return extensions;
    }

    protected final SPSSODescriptor buildSPSSODescriptor() {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        SPSSODescriptor spDescriptor = (SPSSODescriptor)builder.buildObject();
        spDescriptor.setAuthnRequestsSigned(Boolean.valueOf(this.authnRequestSigned));
        spDescriptor.setWantAssertionsSigned(Boolean.valueOf(this.wantAssertionSigned));
        spDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        spDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:1.0:protocol");
        spDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:1.1:protocol");
        SAMLObjectBuilder builderExt = (SAMLObjectBuilder)this.builderFactory.getBuilder(Extensions.DEFAULT_ELEMENT_NAME);
        Extensions extensions = (Extensions)builderExt.buildObject();
        extensions.getNamespaceManager().registerAttributeName(RequestInitiator.DEFAULT_ELEMENT_NAME);
        SAMLObjectBuilder builderReq = (SAMLObjectBuilder)this.builderFactory.getBuilder(RequestInitiator.DEFAULT_ELEMENT_NAME);
        RequestInitiator requestInitiator = (RequestInitiator)builderReq.buildObject();
        requestInitiator.setLocation(this.requestInitiatorLocation);
        requestInitiator.setBinding(RequestInitiator.DEFAULT_ELEMENT_NAME.getNamespaceURI());
        extensions.getUnknownXMLObjects().add(requestInitiator);
        spDescriptor.setExtensions(extensions);
        spDescriptor.getNameIDFormats().addAll(this.buildNameIDFormat());
        int index = 0;
        spDescriptor.getAssertionConsumerServices().add(this.getAssertionConsumerService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", index++, this.defaultACSIndex == index));
        spDescriptor.getSingleLogoutServices().add(this.getSingleLogoutService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST"));
        spDescriptor.getSingleLogoutServices().add(this.getSingleLogoutService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign"));
        spDescriptor.getSingleLogoutServices().add(this.getSingleLogoutService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect"));
        spDescriptor.getSingleLogoutServices().add(this.getSingleLogoutService("urn:oasis:names:tc:SAML:2.0:bindings:SOAP"));
        if (this.credentialProvider != null) {
            spDescriptor.getKeyDescriptors().add(this.getKeyDescriptor(UsageType.SIGNING, this.credentialProvider.getKeyInfo()));
            spDescriptor.getKeyDescriptors().add(this.getKeyDescriptor(UsageType.ENCRYPTION, this.credentialProvider.getKeyInfo()));
        }
        if (!this.requestedAttributes.isEmpty()) {
            SAMLObjectBuilder attrServiceBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(AttributeConsumingService.DEFAULT_ELEMENT_NAME);
            AttributeConsumingService attributeService = (AttributeConsumingService)attrServiceBuilder.buildObject(AttributeConsumingService.DEFAULT_ELEMENT_NAME);
            for (SAML2ServiceProvicerRequestedAttribute attr : this.requestedAttributes) {
                SAMLObjectBuilder attrBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(RequestedAttribute.DEFAULT_ELEMENT_NAME);
                RequestedAttribute requestAttribute = (RequestedAttribute)attrBuilder.buildObject(RequestedAttribute.DEFAULT_ELEMENT_NAME);
                requestAttribute.setIsRequired(Boolean.valueOf(attr.isRequired()));
                requestAttribute.setName(attr.getName());
                requestAttribute.setFriendlyName(attr.getFriendlyName());
                requestAttribute.setNameFormat(attr.getNameFormat());
                attributeService.getRequestAttributes().add(requestAttribute);
            }
            spDescriptor.getAttributeConsumingServices().add(attributeService);
        }
        return spDescriptor;
    }

    protected final Collection<NameIDFormat> buildNameIDFormat() {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(NameIDFormat.DEFAULT_ELEMENT_NAME);
        ArrayList<NameIDFormat> formats = new ArrayList<NameIDFormat>();
        if (this.nameIdPolicyFormat != null) {
            NameIDFormat nameID = (NameIDFormat)builder.buildObject();
            nameID.setFormat(this.nameIdPolicyFormat);
            formats.add(nameID);
        } else {
            NameIDFormat transientNameID = (NameIDFormat)builder.buildObject();
            transientNameID.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
            formats.add(transientNameID);
            NameIDFormat persistentNameID = (NameIDFormat)builder.buildObject();
            persistentNameID.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
            formats.add(persistentNameID);
            NameIDFormat emailNameID = (NameIDFormat)builder.buildObject();
            emailNameID.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
            formats.add(emailNameID);
            NameIDFormat unspecNameID = (NameIDFormat)builder.buildObject();
            unspecNameID.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            formats.add(unspecNameID);
        }
        return formats;
    }

    protected AssertionConsumerService getAssertionConsumerService(String binding, int index, boolean isDefault) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        AssertionConsumerService consumer = (AssertionConsumerService)builder.buildObject();
        consumer.setLocation(this.assertionConsumerServiceUrl);
        consumer.setBinding(binding);
        if (isDefault) {
            consumer.setIsDefault(Boolean.valueOf(true));
        }
        consumer.setIndex(Integer.valueOf(index));
        return consumer;
    }

    protected SingleLogoutService getSingleLogoutService(String binding) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(SingleLogoutService.DEFAULT_ELEMENT_NAME);
        SingleLogoutService logoutService = (SingleLogoutService)builder.buildObject();
        logoutService.setLocation(this.singleLogoutServiceUrl);
        logoutService.setBinding(binding);
        return logoutService;
    }

    protected final KeyDescriptor getKeyDescriptor(UsageType type, KeyInfo key) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(KeyDescriptor.DEFAULT_ELEMENT_NAME);
        KeyDescriptor descriptor = (KeyDescriptor)builder.buildObject();
        descriptor.setUse(type);
        descriptor.setKeyInfo(key);
        return descriptor;
    }

    public CredentialProvider getCredentialProvider() {
        return this.credentialProvider;
    }

    public final void setCredentialProvider(CredentialProvider credentialProvider) {
        this.credentialProvider = credentialProvider;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public final void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public boolean isAuthnRequestSigned() {
        return this.authnRequestSigned;
    }

    public final void setAuthnRequestSigned(boolean authnRequestSigned) {
        this.authnRequestSigned = authnRequestSigned;
    }

    public boolean isWantAssertionSigned() {
        return this.wantAssertionSigned;
    }

    public void setWantAssertionSigned(boolean wantAssertionSigned) {
        this.wantAssertionSigned = wantAssertionSigned;
    }

    public int getDefaultACSIndex() {
        return this.defaultACSIndex;
    }

    public void setDefaultACSIndex(int defaultACSIndex) {
        this.defaultACSIndex = defaultACSIndex;
    }

    public final void setAssertionConsumerServiceUrl(String assertionConsumerServiceUrl) {
        this.assertionConsumerServiceUrl = assertionConsumerServiceUrl;
    }

    public final void setSingleLogoutServiceUrl(String singleLogoutServiceUrl) {
        this.singleLogoutServiceUrl = singleLogoutServiceUrl;
    }

    public final void setRequestInitiatorLocation(String requestInitiatorLocation) {
        this.requestInitiatorLocation = requestInitiatorLocation;
    }

    public String getNameIdPolicyFormat() {
        return this.nameIdPolicyFormat;
    }

    public void setNameIdPolicyFormat(String nameIdPolicyFormat) {
        this.nameIdPolicyFormat = nameIdPolicyFormat;
    }

    public List<SAML2ServiceProvicerRequestedAttribute> getRequestedAttributes() {
        return this.requestedAttributes;
    }

    public void setRequestedAttributes(List<SAML2ServiceProvicerRequestedAttribute> requestedAttributes) {
        this.requestedAttributes = requestedAttributes;
    }

    public List<String> getBlackListedSignatureSigningAlgorithms() {
        if (this.blackListedSignatureSigningAlgorithms == null) {
            this.blackListedSignatureSigningAlgorithms = new ArrayList<String>(this.defaultSignatureSigningConfiguration.getBlacklistedAlgorithms());
        }
        return this.blackListedSignatureSigningAlgorithms;
    }

    public void setBlackListedSignatureSigningAlgorithms(List<String> blackListedSignatureSigningAlgorithms) {
        this.blackListedSignatureSigningAlgorithms = blackListedSignatureSigningAlgorithms;
    }

    public List<String> getSignatureAlgorithms() {
        if (this.signatureAlgorithms == null) {
            this.signatureAlgorithms = this.defaultSignatureSigningConfiguration.getSignatureAlgorithms();
        }
        return this.signatureAlgorithms;
    }

    public void setSignatureAlgorithms(List<String> signatureAlgorithms) {
        this.signatureAlgorithms = signatureAlgorithms;
    }

    public List<String> getSignatureReferenceDigestMethods() {
        if (this.signatureReferenceDigestMethods == null) {
            this.signatureReferenceDigestMethods = this.defaultSignatureSigningConfiguration.getSignatureReferenceDigestMethods();
        }
        return this.signatureReferenceDigestMethods;
    }

    public void setSignatureReferenceDigestMethods(List<String> signatureReferenceDigestMethods) {
        this.signatureReferenceDigestMethods = signatureReferenceDigestMethods;
    }

    private List<String> filterForRuntimeSupportedAlgorithms(List<String> algorithms) {
        ArrayList<String> filteredAlgorithms = new ArrayList<String>(algorithms);
        return filteredAlgorithms.stream().filter(uri -> this.globalAlgorithmRegistry.isRuntimeSupported(uri)).collect(Collectors.toList());
    }

    private List<String> filterSignatureAlgorithms(List<String> algorithms) {
        List<String> filteredAlgorithms = this.filterForRuntimeSupportedAlgorithms(algorithms);
        this.signatureAlgorithms.removeAll(this.blackListedSignatureSigningAlgorithms);
        return filteredAlgorithms;
    }
}

