/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services;

import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.service.config.remote.RemoteConfigurationRegistryClientServiceFactory;
import org.apache.knox.gateway.services.AbstractGatewayServices;
import org.apache.knox.gateway.services.DefaultServerInfoService;
import org.apache.knox.gateway.services.GatewayMetricsServletContextListener;
import org.apache.knox.gateway.services.GatewayServicesContextListener;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.config.client.RemoteConfigurationRegistryClientService;
import org.apache.knox.gateway.services.hostmap.impl.DefaultHostMapperService;
import org.apache.knox.gateway.services.metrics.impl.DefaultMetricsService;
import org.apache.knox.gateway.services.registry.impl.DefaultServiceDefinitionRegistry;
import org.apache.knox.gateway.services.registry.impl.DefaultServiceRegistryService;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.services.security.impl.DefaultAliasService;
import org.apache.knox.gateway.services.security.impl.DefaultCryptoService;
import org.apache.knox.gateway.services.security.impl.DefaultKeystoreService;
import org.apache.knox.gateway.services.security.impl.DefaultMasterService;
import org.apache.knox.gateway.services.security.impl.JettySSLService;
import org.apache.knox.gateway.services.security.impl.RemoteAliasService;
import org.apache.knox.gateway.services.token.impl.DefaultTokenAuthorityService;
import org.apache.knox.gateway.services.topology.impl.DefaultClusterConfigurationMonitorService;
import org.apache.knox.gateway.services.topology.impl.DefaultTopologyService;
import org.apache.knox.gateway.topology.Provider;

public class DefaultGatewayServices
extends AbstractGatewayServices {
    private static GatewayMessages log = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);

    public DefaultGatewayServices() {
        super("Services", "GatewayServices");
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        DefaultMasterService ms = new DefaultMasterService();
        ms.init(config, options);
        this.addService(ServiceType.MASTER_SERVICE, ms);
        DefaultKeystoreService ks = new DefaultKeystoreService();
        ks.setMasterService(ms);
        ks.init(config, options);
        this.addService(ServiceType.KEYSTORE_SERVICE, ks);
        DefaultAliasService defaultAlias = new DefaultAliasService();
        defaultAlias.setKeystoreService(ks);
        defaultAlias.setMasterService(ms);
        defaultAlias.init(config, options);
        RemoteConfigurationRegistryClientService registryClientService = RemoteConfigurationRegistryClientServiceFactory.newInstance((GatewayConfig)config);
        registryClientService.setAliasService((AliasService)defaultAlias);
        registryClientService.init(config, options);
        this.addService(ServiceType.REMOTE_REGISTRY_CLIENT_SERVICE, (Service)registryClientService);
        RemoteAliasService alias = new RemoteAliasService(defaultAlias, ms);
        alias.init(config, options);
        this.addService(ServiceType.ALIAS_SERVICE, (Service)alias);
        DefaultCryptoService crypto = new DefaultCryptoService();
        crypto.setKeystoreService(ks);
        crypto.setAliasService(alias);
        crypto.init(config, options);
        this.addService(ServiceType.CRYPTO_SERVICE, (Service)crypto);
        JettySSLService ssl = new JettySSLService();
        ssl.setAliasService(alias);
        ssl.setKeystoreService(ks);
        ssl.init(config, options);
        this.addService(ServiceType.SSL_SERVICE, (Service)ssl);
        DefaultTokenAuthorityService ts = new DefaultTokenAuthorityService();
        ts.setAliasService(alias);
        ts.setKeystoreService(ks);
        ts.init(config, options);
        this.addService(ServiceType.TOKEN_SERVICE, ts);
        DefaultServiceRegistryService sr = new DefaultServiceRegistryService();
        sr.setCryptoService(crypto);
        sr.init(config, options);
        this.addService(ServiceType.SERVICE_REGISTRY_SERVICE, sr);
        DefaultHostMapperService hm = new DefaultHostMapperService();
        hm.init(config, options);
        this.addService(ServiceType.HOST_MAPPING_SERVICE, (Service)hm);
        DefaultServerInfoService sis = new DefaultServerInfoService();
        sis.init(config, options);
        this.addService(ServiceType.SERVER_INFO_SERVICE, (Service)sis);
        DefaultClusterConfigurationMonitorService ccs = new DefaultClusterConfigurationMonitorService();
        ccs.setAliasService(alias);
        ccs.init(config, options);
        this.addService(ServiceType.CLUSTER_CONFIGURATION_MONITOR_SERVICE, (Service)ccs);
        DefaultTopologyService tops = new DefaultTopologyService();
        tops.setAliasService(alias);
        tops.init(config, options);
        this.addService(ServiceType.TOPOLOGY_SERVICE, (Service)tops);
        DefaultServiceDefinitionRegistry sdr = new DefaultServiceDefinitionRegistry();
        sdr.init(config, options);
        this.addService(ServiceType.SERVICE_DEFINITION_REGISTRY, sdr);
        DefaultMetricsService metricsService = new DefaultMetricsService();
        metricsService.init(config, options);
        this.addService(ServiceType.METRICS_SERVICE, (Service)metricsService);
    }

    public void initializeContribution(DeploymentContext context) {
        String clusterName = context.getTopology().getName();
        try {
            KeystoreService ks = (KeystoreService)this.getService(ServiceType.KEYSTORE_SERVICE);
            if (!ks.isCredentialStoreForClusterAvailable(clusterName)) {
                log.creatingCredentialStoreForCluster(clusterName);
                ks.createCredentialStoreForCluster(clusterName);
            } else {
                log.credentialStoreForClusterFoundNotCreating(clusterName);
            }
        }
        catch (KeystoreServiceException e) {
            throw new RuntimeException("Credential store was found but was unable to be loaded - the provided (or persisted) master secret may not match the password for the credential store.", e);
        }
    }

    public void contributeProvider(DeploymentContext context, Provider provider) {
    }

    public void contributeFilter(DeploymentContext context, Provider provider, org.apache.knox.gateway.topology.Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
    }

    public void finalizeContribution(DeploymentContext context) {
        context.getWebAppDescriptor().createListener().listenerClass(GatewayServicesContextListener.class.getName());
        context.getWebAppDescriptor().createListener().listenerClass(GatewayMetricsServletContextListener.class.getName());
    }
}

