/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.ldapResult;

import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreErrorMessage
extends GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreErrorMessage.class);

    public StoreErrorMessage() {
        super("Store error message");
    }

    public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) {
        TLV tlv = container.getCurrentTLV();
        String errorMessage = tlv.getLength() == 0 ? "" : Strings.utf8ToString((byte[])tlv.getValue().getData());
        ResultResponse response = (ResultResponse)container.getMessage();
        LdapResult ldapResult = response.getLdapResult();
        ldapResult.setDiagnosticMessage(errorMessage);
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05106_ERROR_MESSAGE_IS, (Object[])new Object[]{errorMessage}));
        }
    }
}

