/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.objectweb.howl.log.InvalidLogBufferException;
import org.objectweb.howl.log.LogBuffer;

public class LogRecord {
    LogBuffer buffer = null;
    public short type = 0;
    public short length = 0;
    public long key = 0L;
    protected byte[][] fields = null;
    public byte[] data = null;
    public long tod;
    public ByteBuffer dataBuffer = null;
    private boolean filterCtrlRecords = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LogRecord(int size) {
        this.data = new byte[size];
        this.dataBuffer = ByteBuffer.wrap(this.data);
    }

    public boolean isEOB() {
        return this.type == 19979;
    }

    public boolean isCTRL() {
        return (this.type & 0x4000) != 0;
    }

    public void setFilterCtrlRecords(boolean filterCtrlRecords) {
        this.filterCtrlRecords = filterCtrlRecords;
    }

    public final int capacity() {
        return this.data.length;
    }

    protected LogRecord get(LogBuffer lb) throws InvalidLogBufferException {
        do {
            this.getNext(lb);
        } while (!this.isEOB() && this.isCTRL() && this.filterCtrlRecords);
        return this;
    }

    private LogRecord getNext(LogBuffer lb) throws InvalidLogBufferException {
        int type = 0;
        short length = 0;
        long key = 0L;
        ByteBuffer buffer = lb.buffer;
        this.fields = null;
        if (buffer.position() < lb.bytesUsed) {
            buffer.mark();
            long logKey = (long)lb.bsn << 24 | (long)(buffer.position() & 0xFFFFFF);
            try {
                type = buffer.getShort();
                length = buffer.getShort();
            }
            catch (BufferUnderflowException e) {
                buffer.reset();
                throw new InvalidLogBufferException();
            }
            if (buffer.position() + length > lb.bytesUsed) {
                buffer.reset();
                throw new InvalidLogBufferException();
            }
            if (length > this.data.length) {
                this.data = new byte[length];
                this.dataBuffer = ByteBuffer.wrap(this.data);
                this.dataBuffer.clear();
            }
            if (length > 0) {
                buffer.get(this.data, 0, length);
            }
            key = logKey;
        } else {
            type = 19979;
            key = (long)(lb.bsn + 1) << 24;
        }
        this.type = (short)type;
        this.length = length;
        this.key = key;
        this.tod = lb.tod;
        this.dataBuffer.clear().limit(length);
        return this;
    }

    public byte[][] getFields() {
        if (this.fields != null) {
            return this.fields;
        }
        int count = 0;
        this.dataBuffer.rewind();
        while (this.dataBuffer.hasRemaining()) {
            short len = this.dataBuffer.getShort();
            this.dataBuffer.position(len + this.dataBuffer.position());
            ++count;
        }
        this.fields = new byte[count][];
        if (count > 0) {
            this.dataBuffer.rewind();
            for (int i = 0; i < count; ++i) {
                short len = this.dataBuffer.getShort();
                this.fields[i] = new byte[len];
                this.dataBuffer.get(this.fields[i]);
            }
        }
        if (!$assertionsDisabled && this.dataBuffer.hasRemaining()) {
            throw new AssertionError((Object)"Unexpected data remaining in buffer");
        }
        return this.fields;
    }

    static {
        $assertionsDisabled = !LogRecord.class.desiredAssertionStatus();
    }
}

