/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.exceptions.FunctionWithException;
import aQute.bnd.stream.DropWhile;
import aQute.lib.strings.Strings;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WorkspaceLock
extends ReentrantReadWriteLock {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(WorkspaceLock.class);
    private final AtomicInteger progress = new AtomicInteger();
    private final Queue<Thread> readLockHolders = new ConcurrentLinkedQueue<Thread>();

    WorkspaceLock(boolean fair) {
        super(fair);
    }

    private String type(Lock lock) {
        if (lock == this.readLock()) {
            return "read";
        }
        if (lock == this.writeLock()) {
            return "write";
        }
        return "unknown_lock";
    }

    private void trace(String name, Lock lock) {
        if (logger.isDebugEnabled()) {
            String trace = DropWhile.dropWhile(Arrays.stream(new Exception().getStackTrace()), ste -> {
                String methodName;
                String className = ste.getClassName();
                if (Objects.equals(className, "aQute.bnd.build.WorkspaceLock")) {
                    return true;
                }
                return Objects.equals(className, "aQute.bnd.build.Workspace") && (Objects.equals(methodName = ste.getMethodName(), "readLocked") || Objects.equals(methodName, "writeLocked"));
            }).limit(5L).map(Object::toString).collect(Strings.joining("\n\tat ", "\n\tat ", "", ""));
            logger.debug("{} {} @{}[Write locks = {}, Read locks = {}]; owner {}; waiting {}{}", new Object[]{name, this.type(lock), Integer.toHexString(this.hashCode()), this.getWriteHoldCount(), this.getReadLockCount(), this.getOwner(), this.getQueuedThreads(), trace});
        }
    }

    private Throwable getOwnerCause() {
        Thread owner = this.getOwner();
        if (owner == null) {
            return null;
        }
        Throwable cause = new Throwable(owner + " owns the WorkspaceLock\n\nFull thread dump:\n" + this.dumpAllThreads() + "Owner stacktrace:");
        cause.setStackTrace(owner.getStackTrace());
        return cause;
    }

    private String dumpAllThreads() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        return Arrays.stream(threadMXBean.dumpAllThreads(threadMXBean.isObjectMonitorUsageSupported(), threadMXBean.isSynchronizerUsageSupported())).map(Object::toString).collect(Collectors.joining());
    }

    private CancellationException canceled(Lock lock) {
        CancellationException e = new CancellationException(String.format("Canceled waiting to %s acquire %s; owner %s; waiting %s", this.type(lock), this, this.getOwner(), this.getQueuedThreads()));
        e.initCause(this.getOwnerCause());
        return e;
    }

    private TimeoutException timeout(Lock lock) {
        TimeoutException e = new TimeoutException(String.format("Timeout waiting to %s acquire %s; owner %s; waiting %s", this.type(lock), this, this.getOwner(), this.getQueuedThreads()));
        e.initCause(this.getOwnerCause());
        return e;
    }

    private IllegalStateException deadlock(Lock lock) {
        IllegalStateException e = new IllegalStateException(String.format("Deadlock situation detected trying to %s acquire %s. The current thread already holds a read lock: %s", this.type(lock), this, Thread.currentThread()));
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T, U> T writeReadLocked(long timeoutInMs, Callable<U> underWrite, FunctionWithException<U, T> underRead, BooleanSupplier canceled) throws Exception {
        Callable<Object> writeLocked = () -> {
            Object writeResult = underWrite.call();
            this.trace("Downgrading", this.writeLock());
            this.readLock().lock();
            return writeResult;
        };
        Object writeResult = this.locked(this.writeLock(), timeoutInMs, writeLocked, canceled);
        try {
            Callable<Object> readLocked = () -> underRead.apply(writeResult);
            Object object = this.locked(this.readLock(), timeoutInMs, readLocked, canceled);
            return (T)object;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * Exception decompiling
     */
    <T> T locked(Lock lock, long timeoutInMs, Callable<T> callable, BooleanSupplier canceled) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 18[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

