/*
 * Decompiled with CFR 0.152.
 */
package org.jledit.terminal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jline.TerminalSupport;
import jline.UnixTerminal;
import org.jledit.jline.TerminalLineSettings;

public class JlEditUnixTerminal
extends TerminalSupport {
    private final UnixTerminal delegate;
    private final boolean preExists;
    private final TerminalLineSettings settings = new TerminalLineSettings();

    JlEditUnixTerminal(UnixTerminal delegate, boolean preExists) throws Exception {
        super(true);
        this.delegate = delegate;
        this.preExists = preExists;
        this.setUpControlKeys();
    }

    public final void setUpControlKeys() throws Exception {
        this.settings.set("intr undef");
        this.settings.set("susp undef");
        this.settings.set("stop undef");
        this.settings.set("discard undef");
        this.settings.set("lnext undef");
    }

    public void restore() throws Exception {
        if (this.preExists) {
            this.delegate.reset();
        } else {
            this.delegate.restore();
        }
    }

    public int getWidth() {
        int w = this.settings.getProperty("columns");
        return w < 1 ? 80 : w;
    }

    public int getHeight() {
        int h = this.settings.getProperty("rows");
        return h < 1 ? 24 : h;
    }

    public OutputStream wrapOutIfNeeded(OutputStream out) {
        return this.delegate.wrapOutIfNeeded(out);
    }

    public InputStream wrapInIfNeeded(InputStream in) throws IOException {
        return this.delegate.wrapInIfNeeded(in);
    }
}

