/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console.osgi;

import java.util.Collection;
import java.util.Collections;
import org.apache.felix.gogo.api.CommandSessionListener;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.api.console.CommandLoggingFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingCommandSessionListener
implements CommandSessionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingCommandSessionListener.class);
    private Collection<CommandLoggingFilter> filters = Collections.emptyList();

    public Collection<CommandLoggingFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<CommandLoggingFilter> filters) {
        this.filters = filters;
    }

    private CharSequence filter(CharSequence command) {
        for (CommandLoggingFilter filter : this.filters) {
            command = filter.filter(command);
        }
        return command;
    }

    @Override
    public void beforeExecute(CommandSession session, CharSequence command) {
        if (LOGGER.isDebugEnabled()) {
            command = this.filter(command);
            LOGGER.debug("Executing command: '" + command + "'");
        }
    }

    @Override
    public void afterExecute(CommandSession session, CharSequence command, Exception exception) {
        if (LOGGER.isDebugEnabled()) {
            command = this.filter(command);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.debug("Command: '" + command + "' failed", (Throwable)exception);
            } else {
                LOGGER.debug("Command: '" + command + "' failed: " + exception);
            }
        }
    }

    @Override
    public void afterExecute(CommandSession session, CharSequence command, Object result) {
        if (LOGGER.isDebugEnabled()) {
            command = this.filter(command);
            LOGGER.debug("Command: '" + command + "' returned '" + result + "'");
        }
    }
}

