/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.logger;

import jakarta.servlet.http.HttpServletRequest;
import java.util.logging.Level;
import org.apache.juneau.Enablement;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.rest.logger.CallLogger;
import org.apache.juneau.rest.logger.CallLoggerRule;
import org.apache.juneau.rest.logger.CallLoggingDetail;

public class BasicTestCallLogger
extends CallLogger {
    public BasicTestCallLogger(BeanStore beanStore) {
        super(beanStore);
    }

    @Override
    protected CallLogger.Builder init(BeanStore beanStore) {
        return super.init(beanStore).normalRules((CallLoggerRule)CallLoggerRule.create(beanStore).statusFilter(x -> x >= 400).level(Level.SEVERE).requestDetail(CallLoggingDetail.HEADER).responseDetail(CallLoggingDetail.HEADER).enabled(Enablement.CONDITIONAL).enabledPredicate(x -> !BasicTestCallLogger.isNoTrace(x)).logStackTrace().build(), (CallLoggerRule)CallLoggerRule.create(beanStore).statusFilter(x -> x >= 400).level(Level.WARNING).requestDetail(CallLoggingDetail.STATUS_LINE).responseDetail(CallLoggingDetail.STATUS_LINE).enabled(Enablement.CONDITIONAL).enabledPredicate(x -> !BasicTestCallLogger.isNoTrace(x)).logStackTrace().build()).debugRules((CallLoggerRule)CallLoggerRule.create(beanStore).level(Level.SEVERE).requestDetail(CallLoggingDetail.ENTITY).responseDetail(CallLoggingDetail.ENTITY).logStackTrace().build());
    }

    private static boolean isNoTrace(HttpServletRequest req) {
        Object o = req.getAttribute("NoTrace");
        if (o != null) {
            return "true".equalsIgnoreCase(o.toString());
        }
        String s = req.getHeader("No-Trace");
        if (s != null) {
            return "true".equalsIgnoreCase(s);
        }
        return StringUtils.emptyIfNull(req.getQueryString()).contains("noTrace=true");
    }
}

