/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.EofSensorInputStream;
import org.apache.http.conn.EofSensorWatcher;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.BeanSessionArgs;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.httppart.bean.ResponseBeanPropertyMeta;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.ByteArrayInOutStream;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.TeeOutputStream;
import org.apache.juneau.internal.TeeWriter;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.rest.client.NameValuePairs;
import org.apache.juneau.rest.client.ResponsePattern;
import org.apache.juneau.rest.client.RestCallException;
import org.apache.juneau.rest.client.RestCallInterceptor;
import org.apache.juneau.rest.client.RestCallLogger;
import org.apache.juneau.rest.client.RestClient;
import org.apache.juneau.rest.client.RestRequestEntity;
import org.apache.juneau.rest.client.RetryOn;
import org.apache.juneau.rest.client.SerializedNameValuePair;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.utils.IOPipe;
import org.apache.juneau.utils.PojoRest;

@Deprecated
public final class RestCall
extends BeanSession
implements Closeable {
    private static final ContentType TEXT_PLAIN = ContentType.create((String)"text/plain");
    private final RestClient client;
    private final HttpRequestBase request;
    private HttpResponse response;
    private List<RestCallInterceptor> interceptors = new ArrayList<RestCallInterceptor>();
    private boolean isConnected = false;
    private boolean allowRedirectsOnPosts;
    private int retries = 1;
    private int redirectOnPostsTries = 5;
    private long retryInterval = -1L;
    private RetryOn retryOn;
    private boolean ignoreErrors;
    private boolean byLines = false;
    private TeeWriter writers = new TeeWriter(new Writer[0]);
    private StringWriter capturedResponseWriter;
    private String capturedResponse;
    private TeeOutputStream outputStreams = new TeeOutputStream(new OutputStream[0]);
    private boolean isClosed = false;
    private boolean isFailed = false;
    private Object input;
    private boolean hasInput;
    private Serializer serializer;
    private Parser parser;
    private HttpPartSerializer partSerializer;
    private HttpPartParser partParser;
    private HttpPartSchema requestBodySchema;
    private HttpPartSchema responseBodySchema;
    private URIBuilder uriBuilder;
    private NameValuePairs formData;
    private boolean softClose = false;

    protected RestCall(RestClient client, HttpRequestBase request, URI uri) throws RestCallException {
        super(client, BeanSessionArgs.DEFAULT);
        this.client = client;
        this.request = request;
        for (RestCallInterceptor i : this.client.interceptors) {
            this.interceptor(i);
        }
        this.retryOn = client.retryOn;
        this.retries = client.retries;
        this.retryInterval = client.retryInterval;
        this.serializer = client.serializer;
        this.parser = client.parser;
        this.partSerializer = client.getPartSerializer();
        this.partParser = client.getPartParser();
        this.uriBuilder = new URIBuilder(uri);
    }

    public RestCall uri(Object uri) throws RestCallException {
        try {
            if (uri != null) {
                this.uriBuilder = new URIBuilder(this.client.toURI(uri));
            }
            return this;
        }
        catch (URISyntaxException e) {
            throw new RestCallException(e);
        }
    }

    public RestCall scheme(String scheme) {
        this.uriBuilder.setScheme(scheme);
        return this;
    }

    public RestCall host(String host) {
        this.uriBuilder.setHost(host);
        return this;
    }

    public RestCall port(int port) {
        this.uriBuilder.setPort(port);
        return this;
    }

    public RestCall query(String name, Object value, boolean skipIfEmpty, HttpPartSerializer serializer, HttpPartSchema schema) throws RestCallException {
        boolean isMulti;
        if (serializer == null) {
            serializer = this.client.getPartSerializer();
        }
        if (schema == null) {
            schema = HttpPartSchema.DEFAULT;
        }
        boolean bl = isMulti = StringUtils.isEmpty(name) || "*".equals(name) || value instanceof NameValuePairs;
        if (!isMulti) {
            if (this.canAdd(value, schema, skipIfEmpty)) {
                try {
                    this.uriBuilder.addParameter(name, serializer.createPartSession(null).serialize(HttpPartType.QUERY, schema, value));
                }
                catch (SchemaValidationException e) {
                    throw new RestCallException(e, "Validation error on request query parameter ''{0}''=''{1}''", name, value);
                }
                catch (SerializeException e) {
                    throw new RestCallException(e, "Serialization error on request query parameter ''{0}''", name);
                }
            }
        } else if (value instanceof NameValuePairs) {
            for (NameValuePair p : (NameValuePairs)value) {
                HttpPartSchema s;
                String n = p.getName();
                String v = p.getValue();
                if (!this.canAdd(v, s = schema.getProperty(n), skipIfEmpty)) continue;
                this.query(n, v, skipIfEmpty, serializer, s);
            }
        } else if (value instanceof Map) {
            for (Map.Entry p : ((Map)value).entrySet()) {
                HttpPartSchema s;
                String n = (String)p.getKey();
                Object v = p.getValue();
                if (!this.canAdd(v, s = schema.getProperty(n), skipIfEmpty)) continue;
                this.query(n, v, skipIfEmpty, serializer, s);
            }
        } else {
            if (this.isBean(value)) {
                return this.query(name, this.toBeanMap(value), skipIfEmpty, serializer, schema);
            }
            if (value instanceof Reader || value instanceof InputStream) {
                try {
                    this.uriBuilder.setCustomQuery(IOUtils.read(value));
                }
                catch (IOException e) {
                    throw new RestCallException(e);
                }
            } else if (value instanceof CharSequence) {
                String s = value.toString();
                if (StringUtils.isNotEmpty(s)) {
                    this.uriBuilder.setCustomQuery(s);
                }
            } else {
                throw new RestCallException("Invalid name ''{0}'' passed to query(name,value,skipIfEmpty) for data type ''{1}''", name, RestCall.className(value));
            }
        }
        return this;
    }

    public RestCall query(String name, Object value) throws RestCallException {
        return this.query(name, value, false, null, null);
    }

    public RestCall query(Map<String, Object> params) throws RestCallException {
        return this.query(null, params);
    }

    public RestCall queryIfNE(String name, Object value) throws RestCallException {
        return this.query(name, value, true, null, null);
    }

    public RestCall queryIfNE(Map<String, Object> params) throws RestCallException {
        return this.query(null, params, true, null, null);
    }

    public RestCall query(String query) {
        this.uriBuilder.setCustomQuery(query);
        return this;
    }

    public RestCall formData(String name, Object value, boolean skipIfEmpty, HttpPartSerializer serializer, HttpPartSchema schema) throws RestCallException {
        boolean isMulti;
        if (this.formData == null) {
            this.formData = new NameValuePairs();
        }
        if (serializer == null) {
            serializer = this.client.getPartSerializer();
        }
        if (schema == null) {
            schema = HttpPartSchema.DEFAULT;
        }
        boolean bl = isMulti = StringUtils.isEmpty(name) || "*".equals(name) || value instanceof NameValuePairs;
        if (!isMulti) {
            if (this.canAdd(value, schema, skipIfEmpty)) {
                this.formData.add(new SerializedNameValuePair(name, value, serializer, schema));
            }
        } else if (value instanceof NameValuePairs) {
            for (NameValuePair p : (NameValuePairs)value) {
                HttpPartSchema s;
                String n = p.getName();
                String v = p.getValue();
                if (!this.canAdd(v, s = schema.getProperty(n), skipIfEmpty)) continue;
                this.formData.add(p);
            }
        } else if (value instanceof Map) {
            for (Map.Entry p : ((Map)value).entrySet()) {
                HttpPartSchema s;
                String n = (String)p.getKey();
                Object v = p.getValue();
                if (!this.canAdd(v, s = schema.getProperty(n), skipIfEmpty)) continue;
                this.formData(n, v, skipIfEmpty, serializer, s);
            }
        } else {
            if (this.isBean(value)) {
                return this.formData(name, this.toBeanMap(value), skipIfEmpty, serializer, schema);
            }
            if (value instanceof Reader || value instanceof InputStream) {
                this.contentType("application/x-www-form-urlencoded");
                this.body(value);
            } else if (value instanceof CharSequence) {
                try {
                    this.contentType("application/x-www-form-urlencoded");
                    this.body(new StringEntity(value.toString()));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else {
                throw new BasicRuntimeException("Invalid name ''{0}'' passed to formData(name,value,skipIfEmpty) for data type ''{1}''", name, RestCall.className(value));
            }
        }
        return this;
    }

    public RestCall formData(String name, Object value) throws RestCallException {
        return this.formData(name, value, false, null, null);
    }

    public RestCall formData(NameValuePairs nameValuePairs) throws RestCallException {
        return this.formData(null, nameValuePairs);
    }

    public RestCall formData(Map<String, Object> params) throws RestCallException {
        return this.formData(null, params);
    }

    public RestCall formDataIfNE(String name, Object value) throws RestCallException {
        return this.formData(name, value, true, null, null);
    }

    public RestCall formDataIfNE(Map<String, Object> params) throws RestCallException {
        return this.formData(null, params, true, null, null);
    }

    public RestCall path(String name, Object value, HttpPartSerializer serializer, HttpPartSchema schema) throws RestCallException {
        boolean isMulti;
        String path = this.uriBuilder.getPath();
        if (serializer == null) {
            serializer = this.client.getPartSerializer();
        }
        if (schema == null) {
            schema = HttpPartSchema.DEFAULT;
        }
        boolean bl = isMulti = StringUtils.isEmpty(name) || "*".equals(name) || value instanceof NameValuePairs;
        if (!isMulti) {
            String var = "{" + name + "}";
            if (path.indexOf(var) == -1 && !name.equals("/*")) {
                throw new RestCallException("Path variable {" + name + "} was not found in path.", new Object[0]);
            }
            try {
                String p = null;
                p = name.equals("/*") ? path.replaceAll("\\/\\*$", serializer.createPartSession(null).serialize(HttpPartType.PATH, schema, value)) : path.replace(var, serializer.createPartSession(null).serialize(HttpPartType.PATH, schema, value));
                this.uriBuilder.setPath(p);
            }
            catch (SchemaValidationException e) {
                throw new RestCallException(e, "Validation error on request path parameter ''{0}''=''{1}''", name, value);
            }
            catch (SerializeException e) {
                throw new RestCallException(e, "Serialization error on request path parameter ''{0}''", name);
            }
        } else if (value instanceof NameValuePairs) {
            for (NameValuePair p : (NameValuePairs)value) {
                String n = p.getName();
                String v = p.getValue();
                HttpPartSchema s = schema.getProperty(n);
                this.path(n, v, serializer, s);
            }
        } else if (value instanceof Map) {
            for (Map.Entry p : ((Map)value).entrySet()) {
                String n = (String)p.getKey();
                Object v = p.getValue();
                HttpPartSchema s = schema.getProperty(n);
                this.path(n, v, serializer, s);
            }
        } else {
            if (this.isBean(value)) {
                return this.path(name, this.toBeanMap(value), serializer, schema);
            }
            if (value != null) {
                throw new RestCallException("Invalid name ''{0}'' passed to path(name,value) for data type ''{1}''", name, RestCall.className(value));
            }
        }
        return this;
    }

    public RestCall path(String name, Object value) throws RestCallException {
        return this.path(name, value, null, null);
    }

    public RestCall userInfo(String userInfo) {
        this.uriBuilder.setUserInfo(userInfo);
        return this;
    }

    public RestCall userInfo(String username, String password) {
        this.uriBuilder.setUserInfo(username, password);
        return this;
    }

    public RestCall requestBodySchema(HttpPartSchema value) {
        this.requestBodySchema = value;
        return this;
    }

    public RestCall responseBodySchema(HttpPartSchema value) {
        this.responseBodySchema = value;
        return this;
    }

    public RestCall body(Object input) throws RestCallException {
        this.input = input;
        this.hasInput = true;
        this.formData = null;
        return this;
    }

    public RestCall serializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public RestCall parser(Parser parser) {
        this.parser = parser;
        return this;
    }

    public RestCall header(String name, Object value, boolean skipIfEmpty, HttpPartSerializer serializer, HttpPartSchema schema) throws RestCallException {
        boolean isMulti;
        if (serializer == null) {
            serializer = this.client.getPartSerializer();
        }
        if (schema == null) {
            schema = HttpPartSchema.DEFAULT;
        }
        boolean bl = isMulti = StringUtils.isEmpty(name) || "*".equals(name) || value instanceof NameValuePairs;
        if (!isMulti) {
            if (this.canAdd(value, schema, skipIfEmpty)) {
                try {
                    this.request.setHeader(name, serializer.createPartSession(null).serialize(HttpPartType.HEADER, schema, value));
                }
                catch (SchemaValidationException e) {
                    throw new RestCallException(e, "Validation error on request header parameter ''{0}''=''{1}''", name, value);
                }
                catch (SerializeException e) {
                    throw new RestCallException(e, "Serialization error on request header parameter ''{0}''", name);
                }
            }
        } else if (value instanceof NameValuePairs) {
            for (NameValuePair p : (NameValuePairs)value) {
                HttpPartSchema s;
                String n = p.getName();
                String v = p.getValue();
                if (!this.canAdd(v, s = schema.getProperty(n), skipIfEmpty)) continue;
                this.header(n, v, skipIfEmpty, serializer, s);
            }
        } else if (value instanceof Map) {
            for (Map.Entry p : ((Map)value).entrySet()) {
                HttpPartSchema s;
                String n = (String)p.getKey();
                Object v = p.getValue();
                if (!this.canAdd(v, s = schema.getProperty(n), skipIfEmpty)) continue;
                this.header(n, v, skipIfEmpty, serializer, s);
            }
        } else {
            if (this.isBean(value)) {
                return this.header(name, this.toBeanMap(value), skipIfEmpty, serializer, schema);
            }
            throw new RestCallException("Invalid name ''{0}'' passed to header(name,value,skipIfEmpty) for data type ''{1}''", name, RestCall.className(value));
        }
        return this;
    }

    public RestCall header(String name, Object value) throws RestCallException {
        return this.header(name, value, false, null, null);
    }

    public RestCall headers(Map<String, Object> values) throws RestCallException {
        return this.header(null, values, false, null, null);
    }

    public RestCall headerIfNE(String name, Object value) throws RestCallException {
        return this.header(name, value, true, null, null);
    }

    public RestCall headersIfNE(Map<String, Object> values) throws RestCallException {
        return this.header(null, values, true, null, null);
    }

    public RestCall accept(Object value) throws RestCallException {
        return this.header("Accept", value);
    }

    public RestCall acceptCharset(Object value) throws RestCallException {
        return this.header("Accept-Charset", value);
    }

    public RestCall acceptEncoding(Object value) throws RestCallException {
        return this.header("Accept-Encoding", value);
    }

    public RestCall acceptLanguage(Object value) throws RestCallException {
        return this.header("Accept-Language", value);
    }

    public RestCall authorization(Object value) throws RestCallException {
        return this.header("Authorization", value);
    }

    public RestCall cacheControl(Object value) throws RestCallException {
        return this.header("Cache-Control", value);
    }

    public RestCall connection(Object value) throws RestCallException {
        return this.header("Connection", value);
    }

    public RestCall contentLength(Object value) throws RestCallException {
        return this.header("Content-Length", value);
    }

    public RestCall contentType(Object value) throws RestCallException {
        return this.header("Content-Type", value);
    }

    public RestCall date(Object value) throws RestCallException {
        return this.header("Date", value);
    }

    public RestCall expect(Object value) throws RestCallException {
        return this.header("Expect", value);
    }

    public RestCall forwarded(Object value) throws RestCallException {
        return this.header("Forwarded", value);
    }

    public RestCall from(Object value) throws RestCallException {
        return this.header("From", value);
    }

    public RestCall host(Object value) throws RestCallException {
        return this.header("Host", value);
    }

    public RestCall ifMatch(Object value) throws RestCallException {
        return this.header("If-Match", value);
    }

    public RestCall ifModifiedSince(Object value) throws RestCallException {
        return this.header("If-Modified-Since", value);
    }

    public RestCall ifNoneMatch(Object value) throws RestCallException {
        return this.header("If-None-Match", value);
    }

    public RestCall ifRange(Object value) throws RestCallException {
        return this.header("If-Range", value);
    }

    public RestCall ifUnmodifiedSince(Object value) throws RestCallException {
        return this.header("If-Unmodified-Since", value);
    }

    public RestCall maxForwards(Object value) throws RestCallException {
        return this.header("Max-Forwards", value);
    }

    public RestCall origin(Object value) throws RestCallException {
        return this.header("Origin", value);
    }

    public RestCall pragma(Object value) throws RestCallException {
        return this.header("Pragma", value);
    }

    public RestCall proxyAuthorization(Object value) throws RestCallException {
        return this.header("Proxy-Authorization", value);
    }

    public RestCall range(Object value) throws RestCallException {
        return this.header("Range", value);
    }

    public RestCall referer(Object value) throws RestCallException {
        return this.header("Referer", value);
    }

    public RestCall te(Object value) throws RestCallException {
        return this.header("TE", value);
    }

    public RestCall userAgent(Object value) throws RestCallException {
        return this.header("User-Agent", value);
    }

    public RestCall upgrade(Object value) throws RestCallException {
        return this.header("Upgrade", value);
    }

    public RestCall via(Object value) throws RestCallException {
        return this.header("Via", value);
    }

    public RestCall warning(Object value) throws RestCallException {
        return this.header("Warning", value);
    }

    public RestCall clientVersion(String version) throws RestCallException {
        return this.header("X-Client-Version", version);
    }

    public RestCall retryable(int retries, long interval, RetryOn retryOn) throws RestCallException {
        HttpEntity e;
        if (this.request instanceof HttpEntityEnclosingRequestBase && this.input != null && this.input instanceof HttpEntity && (e = (HttpEntity)this.input) != null && !e.isRepeatable()) {
            throw new RestCallException("Attempt to make call retryable, but entity is not repeatable.", new Object[0]);
        }
        this.retries = retries;
        this.retryInterval = interval;
        this.retryOn = retryOn == null ? RetryOn.DEFAULT : retryOn;
        return this;
    }

    public RestCall allowRedirectsOnPosts(boolean b) {
        this.allowRedirectsOnPosts = b;
        return this;
    }

    public RestCall redirectMaxAttempts(int maxAttempts) {
        this.redirectOnPostsTries = maxAttempts;
        return this;
    }

    public RestCall interceptor(RestCallInterceptor interceptor) {
        this.interceptors.add(interceptor);
        interceptor.onInit(this);
        return this;
    }

    public RestCall pipeTo(Writer w) {
        return this.pipeTo(w, false);
    }

    public RestCall pipeTo(Writer w, boolean close) {
        return this.pipeTo(null, w, close);
    }

    public RestCall pipeTo(String id, Writer w, boolean close) {
        this.writers.add(id, w, close);
        return this;
    }

    public Writer getWriter(String id) {
        return this.writers.getWriter(id);
    }

    public RestCall byLines() {
        this.byLines = true;
        return this;
    }

    public RestCall pipeTo(OutputStream os) {
        return this.pipeTo(os, false);
    }

    public RestCall pipeTo(OutputStream os, boolean close) {
        return this.pipeTo(null, os, close);
    }

    public RestCall pipeTo(String id, OutputStream os, boolean close) {
        this.outputStreams.add(id, os, close);
        return this;
    }

    public OutputStream getOutputStream(String id) {
        return this.outputStreams.getOutputStream(id);
    }

    public RestCall ignoreErrors() {
        this.ignoreErrors = true;
        return this;
    }

    public RestCall captureResponse() {
        if (this.capturedResponseWriter == null) {
            this.capturedResponseWriter = new StringWriter();
            this.writers.add(this.capturedResponseWriter, false);
        }
        return this;
    }

    public RestCall failurePattern(String errorPattern) {
        this.responsePattern(new ResponsePattern(errorPattern){

            @Override
            public void onMatch(RestCall rc, Matcher m) throws RestCallException {
                throw new RestCallException("Failure pattern detected.", new Object[0]);
            }
        });
        return this;
    }

    public RestCall successPattern(String successPattern) {
        this.responsePattern(new ResponsePattern(successPattern){

            @Override
            public void onNoMatch(RestCall rc) throws RestCallException {
                throw new RestCallException("Success pattern not detected.", new Object[0]);
            }
        });
        return this;
    }

    public RestCall responsePattern(final ResponsePattern responsePattern) {
        this.captureResponse();
        this.interceptor(new RestCallInterceptor(){

            @Override
            public void onClose(RestCall restCall) throws RestCallException {
                responsePattern.match(RestCall.this);
            }
        });
        return this;
    }

    public RestCall setConfig(RequestConfig config) {
        this.request.setConfig(config);
        return this;
    }

    public int run() throws RestCallException {
        this.connect();
        try {
            StatusLine status = this.response.getStatusLine();
            int sc = status.getStatusCode();
            if (sc >= 400 && !this.ignoreErrors) {
                throw new RestCallException(sc, status.getReasonPhrase(), this.request.getMethod(), this.request.getURI(), this.getResponseAsString()).setHttpResponse(this.response);
            }
            if (this.outputStreams.size() > 0 || this.writers.size() > 0) {
                this.getReader();
            }
            int n = sc;
            return n;
        }
        catch (RestCallException e) {
            this.isFailed = true;
            throw e;
        }
        catch (IOException e) {
            this.isFailed = true;
            throw new RestCallException(e).setHttpResponse(this.response);
        }
        finally {
            this.close();
        }
    }

    public Future<Integer> runFuture() throws RestCallException {
        return this.client.getExecutorService(true).submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return RestCall.this.run();
            }
        });
    }

    public RestCall connect() throws RestCallException {
        return this.connect(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RestCall connect(ClassMeta<?> bodyType) throws RestCallException {
        if (this.isConnected) {
            return this;
        }
        this.isConnected = true;
        try {
            HttpEntityEnclosingRequestBase request2 = this.request instanceof HttpEntityEnclosingRequestBase ? (HttpEntityEnclosingRequestBase)this.request : null;
            this.request.setURI(this.uriBuilder.build());
            if (this.hasInput || this.formData != null) {
                if (this.hasInput && this.formData != null) {
                    throw new RestCallException("Both input and form data found on same request.", new Object[0]);
                }
                if (request2 == null) {
                    throw new RestCallException(0, "Method does not support content entity.", this.request.getMethod(), this.request.getURI(), null);
                }
                Object entity = null;
                entity = this.formData != null ? new UrlEncodedFormEntity((List)this.formData) : (this.input instanceof NameValuePairs ? new UrlEncodedFormEntity((List)((NameValuePairs)this.input)) : (this.input instanceof HttpEntity ? (HttpEntity)this.input : (this.input instanceof Reader ? new StringEntity(IOUtils.read((Reader)this.input), this.getRequestContentType(TEXT_PLAIN)) : (this.input instanceof InputStream ? new InputStreamEntity((InputStream)this.input, this.getRequestContentType(ContentType.APPLICATION_OCTET_STREAM)) : (this.serializer != null ? new RestRequestEntity(this.input, this.serializer, this.requestBodySchema) : (this.partSerializer != null ? new StringEntity(this.partSerializer.createPartSession(null).serialize(HttpPartType.BODY, null, this.input), this.getRequestContentType(TEXT_PLAIN)) : new StringEntity(this.getBeanContext().getClassMetaForObject(this.input).toString(this.input), this.getRequestContentType(TEXT_PLAIN))))))));
                if (this.retries > 1 && !entity.isRepeatable()) {
                    throw new RestCallException("Rest call set to retryable, but entity is not repeatable.", new Object[0]);
                }
                request2.setEntity((HttpEntity)entity);
            }
            int sc = 0;
            while (this.retries > 0) {
                Object ex;
                block24: {
                    --this.retries;
                    ex = null;
                    try {
                        this.response = request2 != null ? this.client.execute(request2) : this.client.execute(this.request);
                        sc = this.response == null || this.response.getStatusLine() == null ? -1 : this.response.getStatusLine().getStatusCode();
                    }
                    catch (Exception e) {
                        ex = e;
                        sc = -1;
                        if (this.response == null) break block24;
                        EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
                    }
                }
                if (!this.retryOn.onResponse(this.response)) {
                    this.retries = 0;
                }
                if (this.retries > 0) {
                    for (RestCallInterceptor rci : this.interceptors) {
                        rci.onRetry(this, sc, (HttpRequest)this.request, this.response, (Exception)ex);
                    }
                    this.request.reset();
                    long w = this.retryInterval;
                    RestCall restCall = this;
                    synchronized (restCall) {
                        this.wait(w);
                        continue;
                    }
                }
                if (ex == null) continue;
                throw ex;
            }
            for (RestCallInterceptor rci : this.interceptors) {
                rci.onConnect(this, sc, (HttpRequest)this.request, this.response);
            }
            if (this.response == null) {
                throw new RestCallException("HttpClient returned a null response", new Object[0]);
            }
            StatusLine sl = this.response.getStatusLine();
            String method = this.request.getMethod();
            sc = sl.getStatusCode();
            int[] expected = new int[]{};
            if (bodyType != null && bodyType.hasAnnotation(Response.class)) {
                expected = bodyType.getLastAnnotation(Response.class).code();
            }
            if (sc >= 400 && !this.ignoreErrors && !ArrayUtils.contains(sc, expected)) {
                throw new RestCallException(sc, sl.getReasonPhrase(), method, this.request.getURI(), this.getResponseAsString()).setServerException(this.response.getFirstHeader("Exception-Name"), this.response.getFirstHeader("Exception-Message"), this.response.getFirstHeader("Exception-Trace")).setHttpResponse(this.response);
            }
            if ((sc == 307 || sc == 302) && this.allowRedirectsOnPosts && method.equalsIgnoreCase("POST") && !ArrayUtils.contains(sc, expected)) {
                if (this.redirectOnPostsTries-- < 1) {
                    throw new RestCallException(sc, "Maximum number of redirects occurred.  Location header: " + this.response.getFirstHeader("Location"), method, this.request.getURI(), this.getResponseAsString());
                }
                Header h = this.response.getFirstHeader("Location");
                if (h != null) {
                    this.reset();
                    this.request.setURI(URI.create(h.getValue()));
                    ++this.retries;
                    this.connect();
                }
            }
        }
        catch (RestCallException e) {
            this.isFailed = true;
            this.close();
            throw e;
        }
        catch (Exception e) {
            this.isFailed = true;
            this.close();
            throw new RestCallException(e).setHttpResponse(this.response);
        }
        return this;
    }

    private ContentType getRequestContentType(ContentType def) {
        String s;
        Header h = this.request.getFirstHeader("Content-Type");
        if (h != null && !StringUtils.isEmpty(s = h.getValue())) {
            return ContentType.create((String)s);
        }
        return def;
    }

    private void reset() {
        if (this.response != null) {
            EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
        }
        this.request.reset();
        this.isConnected = false;
        this.isClosed = false;
        this.isFailed = false;
        if (this.capturedResponseWriter != null) {
            this.capturedResponseWriter.getBuffer().setLength(0);
        }
    }

    public Reader getReader() throws IOException {
        String ct;
        InputStream is = this.getInputStream();
        if (is == null) {
            return null;
        }
        String cs = null;
        Header contentType = this.response.getLastHeader("Content-Type");
        String string = ct = contentType == null ? null : contentType.getValue();
        if (ct != null && ct.contains("charset=")) {
            cs = ct.substring(ct.indexOf("charset=") + 8).trim();
        }
        if (cs == null) {
            cs = "UTF-8";
        }
        if (this.writers.size() > 0) {
            try (InputStreamReader isr = new InputStreamReader(is, cs);){
                StringWriter sw = new StringWriter();
                this.writers.add(sw, true);
                IOPipe.create(isr, this.writers).byLines(this.byLines).run();
                StringReader stringReader = new StringReader(sw.toString());
                return stringReader;
            }
        }
        return new InputStreamReader(is, cs);
    }

    public String getCapturedResponse() {
        if (!this.isClosed) {
            throw new IllegalStateException("This method cannot be called until the response has been consumed.");
        }
        if (this.capturedResponse == null && this.capturedResponseWriter != null && this.capturedResponseWriter.getBuffer().length() > 0) {
            this.capturedResponse = this.capturedResponseWriter.toString();
        }
        return this.capturedResponse;
    }

    public int getContentLength() throws IOException {
        this.connect();
        Header h = this.response.getLastHeader("Content-Length");
        if (h == null) {
            return -1;
        }
        long l = Long.parseLong(h.getValue());
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    public InputStream getInputStream() throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("Method cannot be called.  Response has already been consumed.");
        }
        this.connect();
        if (this.response == null) {
            throw new RestCallException("Response was null", new Object[0]);
        }
        if (this.response.getEntity() == null) {
            return null;
        }
        this.softClose();
        EofSensorInputStream is = new EofSensorInputStream(this.response.getEntity().getContent(), new EofSensorWatcher(){

            public boolean eofDetected(InputStream wrapped) throws IOException {
                RestCall.this.forceClose();
                return true;
            }

            public boolean streamClosed(InputStream wrapped) throws IOException {
                RestCall.this.forceClose();
                return true;
            }

            public boolean streamAbort(InputStream wrapped) throws IOException {
                RestCall.this.forceClose();
                return true;
            }
        });
        if (this.outputStreams.size() > 0) {
            ByteArrayInOutStream baios = new ByteArrayInOutStream();
            this.outputStreams.add(baios, true);
            IOPipe.create(is, baios).run();
            is.close();
            return baios.getInputStream();
        }
        return is;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getResponseAsString() throws IOException {
        try (Reader r = this.getReader();){
            String string = IOUtils.read(r).toString();
            return string;
        }
        catch (IOException e) {
            this.isFailed = true;
            this.close();
            throw e;
        }
    }

    public String getResponseHeader(String name) throws IOException {
        try {
            HttpResponse r = this.getResponse();
            Header h = r.getFirstHeader(name);
            return h == null ? null : h.getValue();
        }
        catch (IOException e) {
            this.isFailed = true;
            this.close();
            throw e;
        }
    }

    public <T> T getResponseHeader(HttpPartParser partParser, HttpPartSchema schema, String name, Class<T> c) throws IOException, ParseException {
        return this.getResponseHeader(partParser, schema, name, c, new Type[0]);
    }

    public <T> T getResponseHeader(HttpPartParser partParser, HttpPartSchema schema, String name, Type type, Type ... args) throws IOException, ParseException {
        try {
            HttpResponse r = this.getResponse();
            Header h = r.getFirstHeader(name);
            if (h == null) {
                return null;
            }
            String hs = h.getValue();
            if (partParser == null) {
                partParser = this.client.getPartParser();
            }
            return partParser.createPartSession(null).parse(HttpPartType.HEADER, schema, hs, partParser.getClassMeta(type, args));
        }
        catch (IOException e) {
            this.isFailed = true;
            this.close();
            throw e;
        }
    }

    public int getResponseCode() throws IOException {
        return this.run();
    }

    public Future<String> getResponseAsStringFuture() throws RestCallException {
        return this.client.getExecutorService(true).submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return RestCall.this.getResponseAsString();
            }
        });
    }

    public <T> T getResponse(Class<T> type) throws IOException, ParseException {
        BeanContext bc = this.parser;
        if (bc == null) {
            bc = BeanContext.DEFAULT;
        }
        return this.getResponseInner(bc.getClassMeta(type));
    }

    public <T> Future<T> getResponseFuture(final Class<T> type) throws RestCallException {
        return this.client.getExecutorService(true).submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return RestCall.this.getResponse(type);
            }
        });
    }

    public <T> T getResponse(Type type, Type ... args) throws IOException, ParseException {
        BeanContext bc = this.parser;
        if (bc == null) {
            bc = BeanContext.DEFAULT;
        }
        return this.getResponseInner(bc.getClassMeta(type, args));
    }

    public <T> T getResponseBody(Type type, Type ... args) throws IOException, ParseException {
        BeanContext bc = this.parser;
        if (bc == null) {
            bc = BeanContext.DEFAULT;
        }
        return this.getResponseInner(bc.getClassMeta(type, args));
    }

    public <T> Future<T> getResponseFuture(final Type type, final Type ... args) throws RestCallException {
        return this.client.getExecutorService(true).submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return RestCall.this.getResponse(type, args);
            }
        });
    }

    public PojoRest getResponsePojoRest(Class<?> innerType) throws IOException, ParseException {
        return new PojoRest(this.getResponse(innerType));
    }

    public PojoRest getResponsePojoRest() throws IOException, ParseException {
        return this.getResponsePojoRest(OMap.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> T getResponseInner(ClassMeta<T> type) throws IOException, ParseException {
        try {
            Class<T> ic;
            if (this.response == null) {
                this.connect(type);
            }
            if ((ic = type.getInnerClass()).equals(HttpResponse.class)) {
                this.softClose();
                return (T)this.response;
            }
            if (ic.equals(Reader.class)) {
                return (T)this.getReader();
            }
            if (ic.equals(InputStream.class)) {
                return (T)this.getInputStream();
            }
            this.connect(type);
            Header h = this.response.getFirstHeader("Content-Type");
            int sc = this.response.getStatusLine().getStatusCode();
            String ct = StringUtils.firstNonEmpty(h == null ? null : h.getValue(), "text/plain");
            MediaType mt = MediaType.of(ct);
            if ((this.parser == null || mt.toString().equals("text/plain") && !this.parser.canHandle(ct)) && type.hasStringMutater()) {
                return type.getStringMutater().mutate(this.getResponseAsString());
            }
            if (this.parser != null) {
                ParserSessionArgs pArgs;
                Closeable in = this.parser.isReaderParser() ? this.getReader() : this.getInputStream();
                Throwable throwable = null;
                try {
                    ConstructorInfo c;
                    if (in == null && (sc < 200 || sc == 204 || sc == 304 || sc == 205) && (c = type.getInfo().getPublicConstructor(new Class[0])) != null) {
                        try {
                            Object t = c.invoke(new Object[0]);
                            return t;
                        }
                        catch (ExecutableException e) {
                            throw new ParseException(e);
                        }
                    }
                    pArgs = ParserSessionArgs.create().properties(new OMap().inner(this.getProperties())).locale(this.response.getLocale()).mediaType(mt).schema(this.responseBodySchema);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                T t = this.parser.createSession(pArgs).parse((Object)in, type);
                return t;
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            if (type.hasReaderMutater()) {
                return type.getReaderMutater().mutate(this.getReader());
            }
            if (type.hasInputStreamMutater()) {
                return type.getInputStreamMutater().mutate(this.getInputStream());
            }
            throw new ParseException("Unsupported media-type in request header ''Content-Type'': ''{0}''\n\tSupported media-types: {1}", this.getResponseHeader("Content-Type"), this.parser == null ? null : this.parser.getMediaTypes());
        }
        catch (IOException | ParseException e) {
            this.isFailed = true;
            this.close();
            throw e;
        }
    }

    BeanContext getBeanContext() {
        BeanContext bc = this.parser;
        if (bc == null) {
            bc = BeanContext.DEFAULT;
        }
        return bc;
    }

    public <T> T getResponse(final ResponseBeanMeta rbm) {
        try {
            this.softClose();
            Class<?> c = rbm.getClassMeta().getInnerClass();
            final RestClient rc = this.client;
            final HttpPartParser p = ObjectUtils.firstNonNull(this.partParser, rc.getPartParser());
            return (T)Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    ResponseBeanPropertyMeta pm = rbm.getProperty(method.getName());
                    if (pm != null) {
                        HttpPartParser pp = pm.getParser(p);
                        HttpPartSchema schema = pm.getSchema();
                        String name = pm.getPartName();
                        ClassMeta type = rc.getClassMeta(method.getGenericReturnType(), new Type[0]);
                        HttpPartType pt = pm.getPartType();
                        if (pt == HttpPartType.RESPONSE_BODY) {
                            RestCall.this.responseBodySchema(schema);
                            return RestCall.this.getResponseBody(type, new Type[0]);
                        }
                        if (pt == HttpPartType.RESPONSE_HEADER) {
                            return RestCall.this.getResponseHeader(pp, schema, name, type, new Type[0]);
                        }
                        if (pt == HttpPartType.RESPONSE_STATUS) {
                            return RestCall.this.getResponseCode();
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public HttpUriRequest getRequest() {
        return this.request;
    }

    public HttpResponse getResponse() throws IOException {
        this.connect();
        return this.response;
    }

    public RestCall header(Header header) {
        this.request.setHeader(header);
        return this;
    }

    @Override
    public void close() throws RestCallException {
        if (this.response != null && !this.softClose) {
            EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
        }
        if (!this.softClose) {
            this.isClosed = true;
        }
        if (!this.isFailed) {
            for (RestCallInterceptor r : this.interceptors) {
                r.onClose(this);
            }
        }
    }

    void forceClose() throws RestCallException {
        this.softClose = false;
        this.close();
    }

    public RestCall logTo(Level level, Logger log) {
        this.interceptor(new RestCallLogger(level, log));
        return this;
    }

    public RestCall debug() throws RestCallException {
        this.header("Debug", true);
        return this;
    }

    public RestCall softClose() {
        this.softClose = true;
        return this;
    }

    private boolean canAdd(Object value, HttpPartSchema schema, boolean skipIfEmpty) {
        if (value != null) {
            return !ObjectUtils.isEmpty(value) || !skipIfEmpty;
        }
        if (schema == null) {
            return false;
        }
        if (schema.isRequired()) {
            return true;
        }
        String def = schema.getDefault();
        if (def == null) {
            return false;
        }
        return !StringUtils.isEmpty(def) || !skipIfEmpty;
    }

    private static String className(Object o) {
        return ClassInfo.of(o).getFullName();
    }

    @Override
    public OMap toMap() {
        return super.toMap().a("RestCall", new DefaultFilteringOMap().a("allowRedirectsOnPosts", this.allowRedirectsOnPosts).a("byLines", this.byLines).a("capturedResponse", this.capturedResponse).a("client", this.client).a("hasInput", this.hasInput).a("ignoreErrors", this.ignoreErrors).a("interceptors", this.interceptors).a("isClosed", this.isClosed).a("isConnected", this.isConnected).a("isFailed", this.isFailed).a("parser", this.parser).a("partParser", this.partParser).a("partSerializer", this.partSerializer).a("redirectOnPostsTries", this.redirectOnPostsTries).a("requestBodySchema", this.requestBodySchema).a("response", this.response).a("responseBodySchema", this.responseBodySchema).a("retries", this.retries).a("retryInterval", this.retryInterval).a("retryOn", this.retryOn).a("serializer", this.serializer).a("softClose", this.softClose).a("uriBuilder", this.uriBuilder));
    }
}

