/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jaxrs;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import javax.json.Json;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.johnzon.mapper.internal.Streams;

@Provider
@Produces(value={"application/json", "*/json", "*/*+json", "*/x-json", "*/javascript", "*/x-javascript"})
public class JsrMessageBodyWriter
implements MessageBodyWriter<JsonStructure> {
    private final JsonWriterFactory factory;
    private final boolean close;

    public JsrMessageBodyWriter() {
        this(Json.createWriterFactory(Collections.emptyMap()), false);
    }

    public JsrMessageBodyWriter(JsonWriterFactory factory, boolean closeStreams) {
        this.factory = factory;
        this.close = closeStreams;
    }

    public boolean isWriteable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return JsonStructure.class.isAssignableFrom(aClass);
    }

    public long getSize(JsonStructure jsonStructure, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(JsonStructure jsonStructure, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> stringObjectMultivaluedMap, OutputStream outputStream) throws IOException, WebApplicationException {
        try (JsonWriter writer = null;){
            writer = this.factory.createWriter(this.close ? outputStream : Streams.noClose((OutputStream)outputStream));
            writer.write(jsonStructure);
        }
    }
}

