/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.AuthalicConversion;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.util.Formulas;
import org.apache.sis.util.internal.DoubleDouble;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;

public class LambertAzimuthalEqualArea
extends AuthalicConversion {
    private static final long serialVersionUID = 7419101460426922558L;
    private final double sin\u03b20;
    private final double cos\u03b20;
    private final boolean polar;

    public LambertAzimuthalEqualArea(OperationMethod method, Parameters parameters) {
        this(LambertAzimuthalEqualArea.initializer(method, parameters));
    }

    private static Initializer initializer(OperationMethod method, Parameters parameters) {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> roles = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        roles.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.referencing.operation.provider.LambertAzimuthalEqualArea.LONGITUDE_OF_ORIGIN);
        roles.put(NormalizedProjection.ParameterRole.FALSE_EASTING, org.apache.sis.referencing.operation.provider.LambertAzimuthalEqualArea.FALSE_EASTING);
        roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, org.apache.sis.referencing.operation.provider.LambertAzimuthalEqualArea.FALSE_NORTHING);
        return new Initializer(method, parameters, roles, null);
    }

    private LambertAzimuthalEqualArea(Initializer initializer) {
        super(initializer, null);
        double \u03c60 = Math.toRadians(initializer.getAndStore(org.apache.sis.referencing.operation.provider.LambertAzimuthalEqualArea.LATITUDE_OF_ORIGIN));
        double sin\u03c60 = Math.sin(\u03c60);
        double cos\u03c60 = Math.cos(\u03c60);
        this.polar = Math.abs(sin\u03c60) == 1.0;
        this.sin\u03b20 = this.sin\u03b2(sin\u03c60);
        this.cos\u03b20 = Math.sqrt(1.0 - this.sin\u03b20 * this.sin\u03b20);
        MatrixSIS denormalize = this.getContextualParameters().getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        if (this.polar) {
            DoubleDouble c = initializer.axisLengthRatio();
            denormalize.convertBefore(0, c, null);
            denormalize.convertBefore(1, c, null);
            if (\u03c60 > 0.0) {
                MatrixSIS normalize = this.getContextualParameters().getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
                normalize.convertBefore(1, -1, null);
                denormalize.convertBefore(1, -1, null);
            }
        } else {
            double D = cos\u03c60 / (Math.sqrt(1.0 - this.eccentricitySquared * (sin\u03c60 * sin\u03c60)) * this.cos\u03b20);
            double Rq2 = (1.0 - this.eccentricitySquared) * this.qmPolar / 2.0;
            denormalize.convertBefore(0, D, null);
            denormalize.convertBefore(1, Rq2 / D, null);
        }
    }

    @Override
    final String[] getInternalParameterNames() {
        return new String[]{"\u03b2\u2080"};
    }

    @Override
    final double[] getInternalParameterValues() {
        return new double[]{Math.asin(this.sin\u03b20)};
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        double \u03bb = srcPts[srcOff];
        double \u03c6 = srcPts[srcOff + 1];
        double sin\u03bb = Math.sin(\u03bb);
        double cos\u03bb = Math.cos(\u03bb);
        double sin\u03c6 = Math.sin(\u03c6);
        if (!this.polar) {
            double cos\u03b2;
            double sin\u03b2 = this.sin\u03b2(sin\u03c6);
            double c = this.sin\u03b20 * sin\u03b2 + this.cos\u03b20 * (cos\u03b2 = Math.sqrt(1.0 - sin\u03b2 * sin\u03b2)) * cos\u03bb + 1.0;
            double B = Math.sqrt(2.0 / c);
            if (B == Double.POSITIVE_INFINITY) {
                B = Double.NaN;
            }
            double x = cos\u03b2 * sin\u03bb;
            double y = this.cos\u03b20 * sin\u03b2 - this.sin\u03b20 * cos\u03b2 * cos\u03bb;
            if (dstPts != null) {
                dstPts[dstOff] = B * x;
                dstPts[dstOff + 1] = B * y;
            }
            if (!derivate) {
                return null;
            }
            double dsin\u03b2_d\u03c6 = this.dqm_d\u03c6(sin\u03c6, Math.cos(\u03c6)) / this.qmPolar;
            double dcos\u03b2_d\u03c6 = -dsin\u03b2_d\u03c6 * (sin\u03b2 / cos\u03b2);
            double cos\u03bbdcos\u03b2 = dcos\u03b2_d\u03c6 * cos\u03bb;
            double dy_d\u03bb = this.sin\u03b20 * x;
            double db_d\u03bb = this.cos\u03b20 * x / (2.0 * c);
            double dy_d\u03c6 = this.cos\u03b20 * dsin\u03b2_d\u03c6 - this.sin\u03b20 * cos\u03bbdcos\u03b2;
            double db_d\u03c6 = -(this.sin\u03b20 * dsin\u03b2_d\u03c6 + this.cos\u03b20 * cos\u03bbdcos\u03b2) / (2.0 * c);
            return new Matrix2(B * (cos\u03bb + db_d\u03bb * sin\u03bb) * cos\u03b2, B * (dcos\u03b2_d\u03c6 + db_d\u03c6 * cos\u03b2) * sin\u03bb, B * (dy_d\u03bb + db_d\u03bb * y), B * (dy_d\u03c6 + db_d\u03c6 * y));
        }
        double \u03c1 = Math.sqrt(this.qmPolar + this.qm(sin\u03c6));
        if (sin\u03c6 == 1.0) {
            \u03c1 = Double.NaN;
        }
        double x = \u03c1 * sin\u03bb;
        double y = \u03c1 * cos\u03bb;
        if (dstPts != null) {
            dstPts[dstOff] = x;
            dstPts[dstOff + 1] = y;
        }
        if (!derivate) {
            return null;
        }
        double db_d\u03c6 = this.dqm_d\u03c6(sin\u03c6, Math.cos(\u03c6)) / (2.0 * \u03c1);
        return new Matrix2(y, db_d\u03c6 * sin\u03bb, -x, db_d\u03c6 * cos\u03bb);
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
        double sin\u03b2;
        double x = srcPts[srcOff];
        double y = srcPts[srcOff + 1];
        if (this.polar) {
            sin\u03b2 = (x * x + y * y) / this.qmPolar - 1.0;
        } else {
            double \u03c1 = Formulas.fastHypot(x, y);
            double C2 = 2.0 * Math.asin(\u03c1 / 2.0);
            double cosC = Math.cos(C2);
            double sinC = Math.sin(C2);
            double ysinC = y * sinC;
            sin\u03b2 = cosC * this.sin\u03b20;
            if (cosC != 1.0) {
                sin\u03b2 += ysinC * this.cos\u03b20 / \u03c1;
            }
            y = \u03c1 * cosC * this.cos\u03b20 - ysinC * this.sin\u03b20;
            x *= sinC;
        }
        dstPts[dstOff] = Math.atan2(x, y);
        dstPts[dstOff + 1] = this.isSpherical ? Math.asin(sin\u03b2) : this.\u03c6(sin\u03b2);
    }
}

