/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.lang.arq;

import java.io.StringReader;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.Syntax;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.lang.SPARQLParser;
import org.apache.jena.sparql.lang.arq.javacc.ARQParser;
import org.apache.jena.sparql.lang.arq.javacc.ParseException;
import org.apache.jena.sparql.lang.arq.javacc.TokenMgrError;
import org.apache.jena.sparql.lang.sparql_11.ParserSPARQL11;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.Template;

public class ParserARQ
extends SPARQLParser {
    @Override
    protected Query parse$(Query query2, String queryString) {
        query2.setSyntax(Syntax.syntaxARQ);
        Action action = new Action(){

            @Override
            public void exec(ARQParser parser) throws Exception {
                parser.QueryUnit();
            }
        };
        ParserARQ.perform(query2, queryString, action);
        return query2;
    }

    public static Element parseElement(String string) {
        final Query query2 = new Query();
        Action action = new Action(){

            @Override
            public void exec(ARQParser parser) throws Exception {
                Element el = parser.GroupGraphPattern();
                query2.setQueryPattern(el);
            }
        };
        ParserARQ.perform(query2, string, action);
        return query2.getQueryPattern();
    }

    public static Template parseTemplate(String string) {
        final Query query2 = new Query();
        Action action = new Action(){

            @Override
            public void exec(ARQParser parser) throws Exception {
                Template t = parser.ConstructTemplate();
                query2.setConstructTemplate(t);
            }
        };
        ParserARQ.perform(query2, string, action);
        return query2.getConstructTemplate();
    }

    private static void perform(Query query2, String string, Action action) {
        StringReader in = new StringReader(string);
        ARQParser parser = new ARQParser(in);
        try {
            query2.setStrict(true);
            parser.setQuery(query2);
            action.exec(parser);
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            int col = parser.token.endColumn;
            int line = parser.token.endLine;
            throw new QueryParseException(tErr.getMessage(), line, col);
        }
        catch (QueryException ex) {
            throw ex;
        }
        catch (JenaException ex) {
            throw new QueryException(ex.getMessage(), ex);
        }
        catch (Error err) {
            throw new QueryParseException(err.getMessage(), (Throwable)err, -1, -1);
        }
        catch (Throwable th) {
            Log.warn(ParserSPARQL11.class, "Unexpected throwable: ", th);
            throw new QueryException(th.getMessage(), th);
        }
    }

    private static interface Action {
        public void exec(ARQParser var1) throws Exception;
    }
}

