/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.text;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.function.BiConsumer;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdfpatch.PatchException;
import org.apache.jena.rdfpatch.PatchHeader;
import org.apache.jena.rdfpatch.PatchProcessor;
import org.apache.jena.rdfpatch.RDFChanges;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerText;

public class RDFPatchReaderText
implements PatchProcessor {
    private final Tokenizer tokenizer;
    private static final String bNodeLabelStart = "_:";

    private static void read(Tokenizer tokenizer, RDFChanges changes) {
        while (tokenizer.hasNext()) {
            RDFPatchReaderText.apply1(tokenizer, changes);
        }
    }

    public RDFPatchReaderText(InputStream input) {
        this(input, ErrorHandlerFactory.errorHandlerExceptionOnError());
    }

    public RDFPatchReaderText(InputStream input, ErrorHandler errorHandler) {
        this.tokenizer = TokenizerText.create().source(input).errorHandler(errorHandler).build();
    }

    @Override
    public void apply(RDFChanges processor) {
        RDFPatchReaderText.read(this.tokenizer, processor);
    }

    private static boolean apply1(Tokenizer input, RDFChanges sink) {
        boolean oneTransaction = true;
        long lineNumber = 0L;
        while (input.hasNext()) {
            try {
                ++lineNumber;
                boolean b = RDFPatchReaderText.doOneLine(input, sink);
                if (!oneTransaction || !b) continue;
                return true;
            }
            catch (Exception ex) {
                sink.txnAbort();
                throw ex;
            }
        }
        return false;
    }

    private static boolean doOneLine(Tokenizer tokenizer, RDFChanges sink) {
        String code;
        if (!tokenizer.hasNext()) {
            return false;
        }
        Token tokCode = tokenizer.next();
        if (tokCode.hasType(TokenType.DOT)) {
            throw RDFPatchReaderText.exception(tokCode, "Empty line", new Object[0]);
        }
        if (!tokCode.isWord()) {
            throw RDFPatchReaderText.exception(tokCode, "Expected keyword at start of patch record", new Object[0]);
        }
        switch (code = tokCode.getImage()) {
            case "H": {
                RDFPatchReaderText.readHeaderLine(tokenizer, (f, v) -> sink.header((String)f, (Node)v));
                return false;
            }
            case "A": {
                Node s = RDFPatchReaderText.nextNode(tokenizer);
                Node p = RDFPatchReaderText.nextNode(tokenizer);
                Node o = RDFPatchReaderText.nextNode(tokenizer);
                Node g = RDFPatchReaderText.nextNodeMaybe(tokenizer);
                RDFPatchReaderText.skip(tokenizer, TokenType.DOT);
                sink.add(g, s, p, o);
                return false;
            }
            case "D": {
                Node s = RDFPatchReaderText.nextNode(tokenizer);
                Node p = RDFPatchReaderText.nextNode(tokenizer);
                Node o = RDFPatchReaderText.nextNode(tokenizer);
                Node g = RDFPatchReaderText.nextNodeMaybe(tokenizer);
                RDFPatchReaderText.skip(tokenizer, TokenType.DOT);
                sink.delete(g, s, p, o);
                return false;
            }
            case "PA": {
                String uriStr;
                Token tokPrefix = RDFPatchReaderText.nextToken(tokenizer);
                if (tokPrefix == null) {
                    throw RDFPatchReaderText.exception(tokenizer, "Prefix add tuple too short", new Object[0]);
                }
                String prefix = tokPrefix.asString();
                if (prefix == null) {
                    throw RDFPatchReaderText.exception(tokPrefix, "Prefix is not a string: %s", tokPrefix);
                }
                Token tokURI = RDFPatchReaderText.nextToken(tokenizer);
                if (tokURI.isIRI()) {
                    uriStr = tokURI.getImage();
                } else if (tokURI.isString()) {
                    uriStr = tokURI.asString();
                } else {
                    throw RDFPatchReaderText.exception(tokURI, "Prefix error: URI slot is not a URI nor a string", new Object[0]);
                }
                Node gn = RDFPatchReaderText.nextNodeMaybe(tokenizer);
                RDFPatchReaderText.skip(tokenizer, TokenType.DOT);
                sink.addPrefix(gn, prefix, uriStr);
                return false;
            }
            case "PD": {
                Token tokPrefix = RDFPatchReaderText.nextToken(tokenizer);
                if (tokPrefix == null) {
                    throw RDFPatchReaderText.exception(tokenizer, "Prefix delete tuple too short", new Object[0]);
                }
                String prefix = tokPrefix.asString();
                if (prefix == null) {
                    throw RDFPatchReaderText.exception(tokPrefix, "Prefix is not a string: %s", tokPrefix);
                }
                Node gn = RDFPatchReaderText.nextNodeMaybe(tokenizer);
                RDFPatchReaderText.skip(tokenizer, TokenType.DOT);
                sink.deletePrefix(gn, prefix);
                return false;
            }
            case "TX": 
            case "TB": {
                RDFPatchReaderText.skip(tokenizer, TokenType.DOT);
                sink.txnBegin();
                return false;
            }
            case "TC": {
                RDFPatchReaderText.skip(tokenizer, TokenType.DOT);
                sink.txnCommit();
                return true;
            }
            case "TA": {
                RDFPatchReaderText.skip(tokenizer, TokenType.DOT);
                sink.txnAbort();
                return true;
            }
            case "Z": {
                RDFPatchReaderText.skip(tokenizer, TokenType.DOT);
                sink.segment();
                return false;
            }
        }
        throw RDFPatchReaderText.exception(tokenizer, "Code '%s' not recognized", code);
    }

    private static Node tokenToNode(Token token) {
        if (token.isIRI()) {
            return RiotLib.createIRIorBNode(token.getImage());
        }
        if (token.isBNode()) {
            String label = token.getImage().substring(bNodeLabelStart.length() - 1);
            return NodeFactory.createBlankNode(label);
        }
        Node node = token.asNode();
        if (node == null) {
            throw RDFPatchReaderText.exception(token, "Expect a Node, got %s", token);
        }
        return node;
    }

    public static PatchHeader readerHeader(InputStream input) {
        Tokenizer tokenizer = TokenizerText.create().source(input).build();
        LinkedHashMap<String, Node> header = new LinkedHashMap<String, Node>();
        int lineNumber = 0;
        while (tokenizer.hasNext()) {
            Token tokCode = tokenizer.next();
            if (tokCode.hasType(TokenType.DOT)) {
                throw RDFPatchReaderText.exception(tokCode, "Empty header line", new Object[0]);
            }
            if (!tokCode.isWord()) {
                throw RDFPatchReaderText.exception(tokCode, "Expected keyword at start of patch header", new Object[0]);
            }
            String code = tokCode.getImage();
            ++lineNumber;
            if (!code.equals("H")) break;
            RDFPatchReaderText.readHeaderLine(tokenizer, (f, n) -> header.put((String)f, (Node)n));
        }
        return new PatchHeader(header);
    }

    private static void readHeaderLine(Tokenizer tokenizer, BiConsumer<String, Node> action) {
        Token token2 = RDFPatchReaderText.nextToken(tokenizer);
        if (!token2.isWord() && !token2.isString()) {
            throw RDFPatchReaderText.exception(tokenizer, "Header does not have a key that is a word: " + String.valueOf(token2), new Object[0]);
        }
        String field = token2.getImage();
        Node v = RDFPatchReaderText.nextNode(tokenizer);
        RDFPatchReaderText.skip(tokenizer, TokenType.DOT);
        action.accept(field, v);
    }

    private static void skip(Tokenizer tokenizer, TokenType tokenType) {
        Token tok = tokenizer.next();
        if (!tok.hasType(tokenType)) {
            throw RDFPatchReaderText.exception(tok, "Expected token type: " + String.valueOf((Object)tokenType) + ": got " + String.valueOf(tok), new Object[0]);
        }
    }

    private static Node nextNodeMaybe(Tokenizer tokenizer) {
        Token tok = tokenizer.peek();
        if (tok.hasType(TokenType.DOT)) {
            return null;
        }
        if (tok.isEOF()) {
            throw RDFPatchReaderText.exception(tokenizer, "Input truncated: no DOT seen on last line", new Object[0]);
        }
        return RDFPatchReaderText.tokenToNode(tokenizer.next());
    }

    private static Token nextToken(Tokenizer tokenizer) {
        if (!tokenizer.hasNext()) {
            throw RDFPatchReaderText.exception(tokenizer, "Input truncated", new Object[0]);
        }
        Token tok = tokenizer.next();
        if (tok.hasType(TokenType.DOT)) {
            throw RDFPatchReaderText.exception(tok, "Input truncated by DOT: line too short", new Object[0]);
        }
        if (tok.isEOF()) {
            throw RDFPatchReaderText.exception(tok, "Input truncated: no DOT seen on last line", new Object[0]);
        }
        return tok;
    }

    private static Node nextNode(Tokenizer tokenizer) {
        Token tok = RDFPatchReaderText.nextToken(tokenizer);
        if (tok.hasType(TokenType.L_TRIPLE)) {
            Node s = RDFPatchReaderText.nextNode(tokenizer);
            Node p = RDFPatchReaderText.nextNode(tokenizer);
            Node o = RDFPatchReaderText.nextNode(tokenizer);
            Token tok2 = RDFPatchReaderText.nextToken(tokenizer);
            if (!tok2.hasType(TokenType.R_TRIPLE)) {
                RDFPatchReaderText.exception(tok2, "Expected token type: " + String.valueOf((Object)TokenType.R_TRIPLE) + ": got " + String.valueOf(tok2), new Object[0]);
            }
            return NodeFactory.createTripleTerm(s, p, o);
        }
        return RDFPatchReaderText.tokenToNode(tok);
    }

    private static PatchException exception(Tokenizer tokenizer, String fmt, Object ... args) {
        String msg = String.format(fmt, args);
        if (tokenizer != null) {
            msg = SysRIOT.fmtMessage(msg, tokenizer.getLine(), tokenizer.getColumn());
        }
        return new PatchException(msg);
    }

    private static PatchException exception(Token token, String fmt, Object ... args) {
        String msg = String.format(fmt, args);
        if (token != null) {
            msg = SysRIOT.fmtMessage(msg, token.getLine(), token.getColumn());
        }
        return new PatchException(msg);
    }
}

