/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.Closure;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanPropertyValueChangeClosure
implements Closure {
    private final Log log = LogFactory.getLog(this.getClass());
    private final String propertyName;
    private final Object propertyValue;
    private final boolean ignoreNull;

    public BeanPropertyValueChangeClosure(String propertyName, Object propertyValue) {
        this(propertyName, propertyValue, false);
    }

    public BeanPropertyValueChangeClosure(String propertyName, Object propertyValue, boolean ignoreNull) {
        if (propertyName == null || propertyName.length() <= 0) {
            throw new IllegalArgumentException("propertyName cannot be null or empty");
        }
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
        this.ignoreNull = ignoreNull;
    }

    @Override
    public void execute(Object object) {
        try {
            PropertyUtils.setProperty(object, this.propertyName, this.propertyValue);
        }
        catch (IllegalArgumentException e2) {
            String errorMsg = "Unable to execute Closure. Null value encountered in property path...";
            if (!this.ignoreNull) {
                IllegalArgumentException iae = new IllegalArgumentException("Unable to execute Closure. Null value encountered in property path...", e2);
                throw iae;
            }
            this.log.warn("WARNING: Unable to execute Closure. Null value encountered in property path..." + e2);
        }
        catch (IllegalAccessException e3) {
            String errorMsg = "Unable to access the property provided.";
            throw new IllegalArgumentException("Unable to access the property provided.", e3);
        }
        catch (InvocationTargetException e4) {
            String errorMsg = "Exception occurred in property's getter";
            throw new IllegalArgumentException("Exception occurred in property's getter", e4);
        }
        catch (NoSuchMethodException e5) {
            String errorMsg = "Property not found";
            throw new IllegalArgumentException("Property not found", e5);
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object getPropertyValue() {
        return this.propertyValue;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }
}

