/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.op;

import java.util.Objects;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class OpLabel
extends Op1 {
    private Object object;

    public static Op create(Object label, Op op) {
        return new OpLabel(label, op);
    }

    protected OpLabel(Object thing) {
        this(thing, null);
    }

    protected OpLabel(Object thing, Op op) {
        super(op);
        this.object = thing;
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpLabel)) {
            return false;
        }
        OpLabel opLabel = (OpLabel)other;
        if (!Objects.equals(this.object, opLabel.object)) {
            return false;
        }
        return Objects.equals(this.getSubOp(), opLabel.getSubOp());
    }

    @Override
    public int hashCode() {
        int x = 185;
        x ^= Lib.hashCodeObject((Object)this.object, (int)0);
        return x ^= Lib.hashCodeObject((Object)this.getSubOp(), (int)0);
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    public Object getObject() {
        return this.object;
    }

    public boolean hasSubOp() {
        return this.getSubOp() != null;
    }

    @Override
    public String getName() {
        return "label";
    }

    @Override
    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }

    @Override
    public Op1 copy(Op subOp) {
        return new OpLabel(this.object, subOp);
    }
}

