/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.api;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.api.CopyInBuilder;
import io.r2dbc.postgresql.api.Notification;
import io.r2dbc.postgresql.api.PostgresqlBatch;
import io.r2dbc.postgresql.api.PostgresqlConnectionMetadata;
import io.r2dbc.postgresql.api.PostgresqlStatement;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.TransactionDefinition;
import io.r2dbc.spi.ValidationDepth;
import java.time.Duration;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface PostgresqlConnection
extends Connection {
    public Mono<Void> beginTransaction();

    public Mono<Void> beginTransaction(TransactionDefinition var1);

    public Mono<Void> close();

    public Mono<Void> commitTransaction();

    public CopyInBuilder copyIn(String var1);

    default public Mono<Long> copyIn(String sql, Publisher<ByteBuf> stdin) {
        return this.copyIn(sql).from(stdin).build();
    }

    public PostgresqlBatch createBatch();

    public Mono<Void> createSavepoint(String var1);

    public PostgresqlStatement createStatement(String var1);

    public Flux<Notification> getNotifications();

    public Mono<Void> cancelRequest();

    public PostgresqlConnectionMetadata getMetadata();

    public IsolationLevel getTransactionIsolationLevel();

    public boolean isAutoCommit();

    public Mono<Void> releaseSavepoint(String var1);

    public Mono<Void> rollbackTransaction();

    public Mono<Void> rollbackTransactionToSavepoint(String var1);

    public Mono<Void> setAutoCommit(boolean var1);

    public Mono<Void> setLockWaitTimeout(Duration var1);

    public Mono<Void> setStatementTimeout(Duration var1);

    public Mono<Void> setTransactionIsolationLevel(IsolationLevel var1);

    public String toString();

    public Mono<Boolean> validate(ValidationDepth var1);
}

