/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.commands.optional;

import org.apache.jsieve.Arguments;
import org.apache.jsieve.Block;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.commands.AbstractActionCommand;
import org.apache.jsieve.exception.CommandException;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.mail.optional.ActionVacation;
import org.apache.jsieve.utils.ArgumentParser;

public class Vacation
extends AbstractActionCommand {
    public static final String DAYS = ":days";
    public static final String DAYS_EXCEPTION_MESSAGE = "Expecting a number argument setting the number of days after tag :days";
    public static final String SUBJECT = ":subject";
    public static final String SUBJECT_EXCEPTION_MESSAGE = "Expecting a string argument setting the subject after tag :subject";
    public static final String FROM = ":from";
    public static final String FROM_EXCEPTION_MESSAGE = "Expecting a string argument setting the from field of sent mails after tag :from";
    public static final String ADDRESSES = ":addresses";
    public static final String ADDRESSES_EXCEPTION_MESSAGE = "Expecting a string list argument setting the additional addresses this script is authorized to respond to after tag :addresses";
    public static final String MIME = ":mime";
    public static final String MIME_EXCEPTION_MESSAGE = "Expecting a string argument setting a mime message instead of the reason string after tag :mime";
    public static final String HANDLE = ":handle";
    public static final String HANDLE_EXCEPTION_MESSAGE = "Expecting a string argument setting handle string after tag :handle";

    @Override
    protected Object executeBasic(MailAdapter mail, Arguments arguments, Block block, SieveContext context) throws SieveException {
        mail.addAction(this.retrieveAction(arguments));
        return null;
    }

    @Override
    protected void validateState(SieveContext context) throws CommandException {
        super.validateState(context);
        if (context.getCommandStateManager().getVacationProcessed()) {
            throw context.getCoordinate().commandException("The \"vacation\" command is not allowed to be executed after other vacation commands");
        }
    }

    @Override
    protected void updateState(SieveContext context) {
        context.getCommandStateManager().setHasActions(true);
        context.getCommandStateManager().setInProlog(false);
        context.getCommandStateManager().setVacationProcessed(true);
        context.getCommandStateManager().setImplicitKeep(context.getCommandStateManager().isImplicitKeep());
    }

    @Override
    protected void validateArguments(Arguments arguments, SieveContext context) throws SieveException {
        this.retrieveAction(arguments);
    }

    private ActionVacation retrieveAction(Arguments arguments) throws SieveException {
        ArgumentParser argumentParser = new ArgumentParser(arguments.getArgumentList());
        argumentParser.throwOnUnvalidSeenSingleTag(new String[0]);
        argumentParser.throwOnUnvalidSeenTagWithValue(FROM, SUBJECT, HANDLE, MIME, DAYS, ADDRESSES);
        return ActionVacation.builder().addresses(argumentParser.getStringListForTag(ADDRESSES, ADDRESSES_EXCEPTION_MESSAGE)).duration(argumentParser.getNumericValueForTag(DAYS, DAYS_EXCEPTION_MESSAGE)).handle(argumentParser.getStringValueForTag(HANDLE, HANDLE_EXCEPTION_MESSAGE)).mime(argumentParser.getStringValueForTag(MIME, MIME_EXCEPTION_MESSAGE)).subject(argumentParser.getStringValueForTag(SUBJECT, SUBJECT_EXCEPTION_MESSAGE)).from(argumentParser.getStringValueForTag(FROM, FROM_EXCEPTION_MESSAGE)).reason(argumentParser.getRemainingStringValue("Expecting a single String value as a reason")).build();
    }
}

