/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenizerBase;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinitionVariant;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SimplePatternSplitTokenizer
extends TokenizerBase
implements TokenizerDefinitionVariant,
ToCopyableBuilder<Builder, SimplePatternSplitTokenizer> {
    @Nullable
    private final String pattern;
    public static final JsonpDeserializer<SimplePatternSplitTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SimplePatternSplitTokenizer::setupSimplePatternSplitTokenizerDeserializer);

    private SimplePatternSplitTokenizer(Builder builder) {
        super(builder);
        this.pattern = builder.pattern;
    }

    public static SimplePatternSplitTokenizer of(Function<Builder, ObjectBuilder<SimplePatternSplitTokenizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenizerDefinition.Kind _tokenizerDefinitionKind() {
        return TokenizerDefinition.Kind.SimplePatternSplit;
    }

    @Nullable
    public final String pattern() {
        return this.pattern;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "simple_pattern_split");
        super.serializeInternal(generator, mapper);
        if (this.pattern != null) {
            generator.writeKey("pattern");
            generator.write(this.pattern);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSimplePatternSplitTokenizerDeserializer(ObjectDeserializer<Builder> op) {
        SimplePatternSplitTokenizer.setupTokenizerBaseDeserializer(op);
        op.add(Builder::pattern, JsonpDeserializer.stringDeserializer(), "pattern");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.pattern);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimplePatternSplitTokenizer other = (SimplePatternSplitTokenizer)o;
        return Objects.equals(this.pattern, other.pattern);
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, SimplePatternSplitTokenizer> {
        @Nullable
        private String pattern;

        public Builder() {
        }

        private Builder(SimplePatternSplitTokenizer o) {
            super(o);
            this.pattern = o.pattern;
        }

        private Builder(Builder o) {
            super(o);
            this.pattern = o.pattern;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder pattern(@Nullable String value) {
            this.pattern = value;
            return this;
        }

        @Override
        @Nonnull
        public SimplePatternSplitTokenizer build() {
            this._checkSingleUse();
            return new SimplePatternSplitTokenizer(this);
        }
    }
}

