/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.datastax.oss.driver.api.core.CqlSession;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import jakarta.inject.Singleton;
import java.io.FileNotFoundException;
import java.lang.annotation.Annotation;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.adapter.mailbox.ACLUsernameChangeTaskStep;
import org.apache.james.adapter.mailbox.MailboxUserDeletionTaskStep;
import org.apache.james.adapter.mailbox.MailboxUsernameChangeTaskStep;
import org.apache.james.adapter.mailbox.QuotaUsernameChangeTaskStep;
import org.apache.james.adapter.mailbox.UserRepositoryAuthenticator;
import org.apache.james.backends.cassandra.components.CassandraDataDefinition;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.blob.api.BlobReferenceSource;
import org.apache.james.events.EventListener;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.eventstore.JsonEventSerializer;
import org.apache.james.eventsourcing.eventstore.cassandra.CassandraEventStore;
import org.apache.james.eventsourcing.eventstore.cassandra.EventStoreDao;
import org.apache.james.eventsourcing.eventstore.dto.EventDTO;
import org.apache.james.eventsourcing.eventstore.dto.EventDTOModule;
import org.apache.james.jmap.api.change.EmailChangeRepository;
import org.apache.james.jmap.api.change.Limit;
import org.apache.james.jmap.api.change.MailboxChangeRepository;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.cassandra.change.CassandraChangesConfiguration;
import org.apache.james.jmap.cassandra.change.CassandraEmailChangeRepository;
import org.apache.james.jmap.cassandra.change.CassandraMailboxChangeRepository;
import org.apache.james.jmap.cassandra.change.CassandraStateFactory;
import org.apache.james.jmap.cassandra.change.EmailChangeRepositoryDAO;
import org.apache.james.jmap.cassandra.change.MailboxChangeRepositoryDAO;
import org.apache.james.mailbox.AttachmentContentLoader;
import org.apache.james.mailbox.AttachmentIdFactory;
import org.apache.james.mailbox.AttachmentManager;
import org.apache.james.mailbox.Authenticator;
import org.apache.james.mailbox.MailboxCounterCorrector;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.RightManager;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.StringBackedAttachmentIdFactory;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.cassandra.CassandraMailboxManager;
import org.apache.james.mailbox.cassandra.CassandraMailboxSessionMapperFactory;
import org.apache.james.mailbox.cassandra.CassandraThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.cassandra.DeleteMessageListener;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.mail.ACLMapper;
import org.apache.james.mailbox.cassandra.mail.AttachmentBlobReferenceSource;
import org.apache.james.mailbox.cassandra.mail.CassandraACLDAOV2;
import org.apache.james.mailbox.cassandra.mail.CassandraACLMapper;
import org.apache.james.mailbox.cassandra.mail.CassandraApplicableFlagDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraAttachmentDAOV2;
import org.apache.james.mailbox.cassandra.mail.CassandraDeletedMessageDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraFirstUnseenDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxCounterDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxMapper;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxPathV3DAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxRecentsDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageDAOV3;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdToImapUidDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraModSeqProvider;
import org.apache.james.mailbox.cassandra.mail.CassandraUidProvider;
import org.apache.james.mailbox.cassandra.mail.CassandraUserMailboxRightsDAO;
import org.apache.james.mailbox.cassandra.mail.MessageBlobReferenceSource;
import org.apache.james.mailbox.cassandra.mail.eventsourcing.acl.ACLModule;
import org.apache.james.mailbox.cassandra.mail.task.CassandraMailboxCounterCorrector;
import org.apache.james.mailbox.cassandra.modules.CassandraAclDataDefinition;
import org.apache.james.mailbox.cassandra.modules.CassandraAnnotationDataDefinition;
import org.apache.james.mailbox.cassandra.modules.CassandraApplicableFlagsDataDefinition;
import org.apache.james.mailbox.cassandra.modules.CassandraAttachmentDataDefinition;
import org.apache.james.mailbox.cassandra.modules.CassandraDeletedMessageDataDefinition;
import org.apache.james.mailbox.cassandra.modules.CassandraFirstUnseenDataDefinition;
import org.apache.james.mailbox.cassandra.modules.CassandraMailboxCounterDataDefinition;
import org.apache.james.mailbox.cassandra.modules.CassandraMailboxDataDefinition;
import org.apache.james.mailbox.cassandra.modules.CassandraMailboxRecentsDataDefinition;
import org.apache.james.mailbox.cassandra.modules.CassandraMessageDataDefinition;
import org.apache.james.mailbox.cassandra.modules.CassandraModSeqDataDefinition;
import org.apache.james.mailbox.cassandra.modules.CassandraSubscriptionDataDefinition;
import org.apache.james.mailbox.cassandra.modules.CassandraUidDataDefinition;
import org.apache.james.mailbox.indexer.MessageIdReIndexer;
import org.apache.james.mailbox.indexer.ReIndexer;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.NoMailboxPathLocker;
import org.apache.james.mailbox.store.SessionProviderImpl;
import org.apache.james.mailbox.store.StoreAttachmentManager;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.StoreMessageIdManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.StoreSubscriptionManager;
import org.apache.james.mailbox.store.event.MailboxAnnotationListener;
import org.apache.james.mailbox.store.event.MailboxSubscriptionListener;
import org.apache.james.mailbox.store.mail.AttachmentIdAssignationStrategy;
import org.apache.james.mailbox.store.mail.AttachmentMapperFactory;
import org.apache.james.mailbox.store.mail.MailboxMapperFactory;
import org.apache.james.mailbox.store.mail.MessageMapperFactory;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.ThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.mail.model.impl.MessageParserImpl;
import org.apache.james.mailbox.store.user.SubscriptionMapperFactory;
import org.apache.james.modules.mailbox.CassandraDeadLetterModule;
import org.apache.james.modules.mailbox.CassandraQuotaModule;
import org.apache.james.modules.mailbox.CassandraThreadIdGuessingModule;
import org.apache.james.modules.mailbox.DefaultEventModule;
import org.apache.james.user.api.DeleteUserDataTaskStep;
import org.apache.james.user.api.UsernameChangeTaskStep;
import org.apache.james.utils.MailboxManagerDefinition;
import org.apache.james.utils.PropertiesProvider;
import org.apache.mailbox.tools.indexer.MessageIdReIndexerImpl;
import org.apache.mailbox.tools.indexer.ReIndexerImpl;

public class CassandraMailboxModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new DefaultEventModule());
        this.install((Module)new CassandraQuotaModule());
        this.install((Module)new CassandraDeadLetterModule());
        this.install((Module)new CassandraThreadIdGuessingModule());
        this.bind(CassandraApplicableFlagDAO.class).in(Scopes.SINGLETON);
        this.bind(CassandraAttachmentDAOV2.class).in(Scopes.SINGLETON);
        this.bind(CassandraDeletedMessageDAO.class).in(Scopes.SINGLETON);
        this.bind(CassandraFirstUnseenDAO.class).in(Scopes.SINGLETON);
        this.bind(CassandraMailboxCounterDAO.class).in(Scopes.SINGLETON);
        this.bind(CassandraMailboxDAO.class).in(Scopes.SINGLETON);
        this.bind(CassandraACLDAOV2.class).in(Scopes.SINGLETON);
        this.bind(CassandraMailboxPathV3DAO.class).in(Scopes.SINGLETON);
        this.bind(CassandraMailboxRecentsDAO.class).in(Scopes.SINGLETON);
        this.bind(CassandraMessageDAOV3.class).in(Scopes.SINGLETON);
        this.bind(CassandraMessageIdDAO.class).in(Scopes.SINGLETON);
        this.bind(CassandraMessageIdToImapUidDAO.class).in(Scopes.SINGLETON);
        this.bind(CassandraUserMailboxRightsDAO.class).in(Scopes.SINGLETON);
        this.bind(CassandraMailboxManager.class).in(Scopes.SINGLETON);
        this.bind(StoreSubscriptionManager.class).in(Scopes.SINGLETON);
        this.bind(StoreAttachmentManager.class).in(Scopes.SINGLETON);
        this.bind(StoreMessageIdManager.class).in(Scopes.SINGLETON);
        this.bind(StoreRightManager.class).in(Scopes.SINGLETON);
        this.bind(SessionProviderImpl.class).in(Scopes.SINGLETON);
        this.bind(CassandraMailboxMapper.class).in(Scopes.SINGLETON);
        this.bind(CassandraId.Factory.class).in(Scopes.SINGLETON);
        this.bind(CassandraMailboxSessionMapperFactory.class).in(Scopes.SINGLETON);
        this.bind(CassandraMessageId.Factory.class).in(Scopes.SINGLETON);
        this.bind(CassandraThreadIdGuessingAlgorithm.class).in(Scopes.SINGLETON);
        this.bind(CassandraModSeqProvider.class).in(Scopes.SINGLETON);
        this.bind(CassandraUidProvider.class).in(Scopes.SINGLETON);
        this.bind(NoMailboxPathLocker.class).in(Scopes.SINGLETON);
        this.bind(UserRepositoryAuthenticator.class).in(Scopes.SINGLETON);
        this.bind(EmailChangeRepositoryDAO.class).in(Scopes.SINGLETON);
        this.bind(MailboxChangeRepositoryDAO.class).in(Scopes.SINGLETON);
        this.bind(CassandraMailboxCounterCorrector.class).in(Scopes.SINGLETON);
        this.bind(ReIndexerImpl.class).in(Scopes.SINGLETON);
        this.bind(MessageIdReIndexerImpl.class).in(Scopes.SINGLETON);
        this.bind(MessageMapperFactory.class).to(CassandraMailboxSessionMapperFactory.class);
        this.bind(MailboxMapperFactory.class).to(CassandraMailboxSessionMapperFactory.class);
        this.bind(AttachmentIdFactory.class).to(StringBackedAttachmentIdFactory.class);
        this.bind(AttachmentMapperFactory.class).to(CassandraMailboxSessionMapperFactory.class);
        this.bind(MailboxSessionMapperFactory.class).to(CassandraMailboxSessionMapperFactory.class);
        this.bind(SubscriptionMapperFactory.class).to(CassandraMailboxSessionMapperFactory.class);
        this.bind(ACLMapper.class).to(CassandraACLMapper.class);
        this.bind(ModSeqProvider.class).to(CassandraModSeqProvider.class);
        this.bind(UidProvider.class).to(CassandraUidProvider.class);
        this.bind(SubscriptionManager.class).to(StoreSubscriptionManager.class);
        this.bind(MailboxPathLocker.class).to(NoMailboxPathLocker.class);
        this.bind(Authenticator.class).to(UserRepositoryAuthenticator.class);
        this.bind(MailboxManager.class).to(CassandraMailboxManager.class);
        this.bind(StoreMailboxManager.class).to(CassandraMailboxManager.class);
        this.bind(MailboxChangeRepository.class).to(CassandraMailboxChangeRepository.class);
        this.bind(EmailChangeRepository.class).to(CassandraEmailChangeRepository.class);
        this.bind(State.Factory.class).to(CassandraStateFactory.class);
        this.bind(MailboxId.Factory.class).to(CassandraId.Factory.class);
        this.bind(State.Factory.class).to(CassandraStateFactory.class);
        this.bind(MessageId.Factory.class).to(CassandraMessageId.Factory.class);
        this.bind(ThreadIdGuessingAlgorithm.class).to(CassandraThreadIdGuessingAlgorithm.class);
        this.bind(MessageIdManager.class).to(StoreMessageIdManager.class);
        this.bind(AttachmentManager.class).to(StoreAttachmentManager.class);
        this.bind(RightManager.class).to(StoreRightManager.class);
        this.bind(SessionProvider.class).to(SessionProviderImpl.class);
        this.bind(AttachmentContentLoader.class).to(AttachmentManager.class);
        this.bind(MailboxCounterCorrector.class).to(CassandraMailboxCounterCorrector.class);
        this.bind(MessageParser.class).toInstance((Object)new MessageParserImpl());
        this.bind(AttachmentIdAssignationStrategy.class).to(AttachmentIdAssignationStrategy.Default.class);
        this.bind(Limit.class).annotatedWith((Annotation)Names.named((String)"emailChangeDefaultLimit")).toInstance((Object)Limit.of((int)256));
        this.bind(Limit.class).annotatedWith((Annotation)Names.named((String)"mailboxChangeDefaultLimit")).toInstance((Object)Limit.of((int)256));
        this.bind(ReIndexer.class).to(ReIndexerImpl.class);
        this.bind(MessageIdReIndexer.class).to(MessageIdReIndexerImpl.class);
        Multibinder cassandraDataDefinitions = Multibinder.newSetBinder((Binder)this.binder(), CassandraDataDefinition.class);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraAclDataDefinition.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraAttachmentDataDefinition.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraMailboxDataDefinition.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraMessageDataDefinition.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraMailboxCounterDataDefinition.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraAnnotationDataDefinition.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraApplicableFlagsDataDefinition.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraDeletedMessageDataDefinition.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraFirstUnseenDataDefinition.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraMailboxRecentsDataDefinition.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraModSeqDataDefinition.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraSubscriptionDataDefinition.MODULE);
        cassandraDataDefinitions.addBinding().toInstance((Object)CassandraUidDataDefinition.MODULE);
        Multibinder.newSetBinder((Binder)this.binder(), MailboxManagerDefinition.class).addBinding().to(CassandraMailboxManagerDefinition.class);
        Multibinder.newSetBinder((Binder)this.binder(), EventListener.GroupEventListener.class).addBinding().to(MailboxAnnotationListener.class);
        Multibinder.newSetBinder((Binder)this.binder(), EventListener.GroupEventListener.class).addBinding().to(MailboxSubscriptionListener.class);
        Multibinder.newSetBinder((Binder)this.binder(), EventListener.ReactiveGroupEventListener.class).addBinding().to(DeleteMessageListener.class);
        Multibinder.newSetBinder((Binder)this.binder(), DeleteMessageListener.DeletionCallback.class);
        this.bind(MailboxManager.class).annotatedWith((Annotation)Names.named((String)"mailboxmanager")).to(MailboxManager.class);
        Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<EventDTOModule<? extends Event, ? extends EventDTO>>(this){}).addBinding().toInstance((Object)ACLModule.ACL_UPDATE);
        Multibinder.newSetBinder((Binder)this.binder(), BlobReferenceSource.class).addBinding().to(AttachmentBlobReferenceSource.class);
        Multibinder.newSetBinder((Binder)this.binder(), BlobReferenceSource.class).addBinding().to(MessageBlobReferenceSource.class);
        Multibinder usernameChangeTaskStepMultibinder = Multibinder.newSetBinder((Binder)this.binder(), UsernameChangeTaskStep.class);
        usernameChangeTaskStepMultibinder.addBinding().to(MailboxUsernameChangeTaskStep.class);
        usernameChangeTaskStepMultibinder.addBinding().to(ACLUsernameChangeTaskStep.class);
        usernameChangeTaskStepMultibinder.addBinding().to(QuotaUsernameChangeTaskStep.class);
        Multibinder deleteUserDataTaskStepMultibinder = Multibinder.newSetBinder((Binder)this.binder(), DeleteUserDataTaskStep.class);
        deleteUserDataTaskStepMultibinder.addBinding().to(MailboxUserDeletionTaskStep.class);
    }

    @Provides
    @Singleton
    CassandraACLMapper aclMapper(CassandraUserMailboxRightsDAO userMailboxRightsDAO, CassandraACLDAOV2 cassandraACLDAOV2, CqlSession session, CassandraConfiguration cassandraConfiguration) {
        return new CassandraACLMapper(new CassandraACLMapper.StoreV2(userMailboxRightsDAO, cassandraACLDAOV2, (EventStore)new CassandraEventStore(new EventStoreDao(session, JsonEventSerializer.forModules((EventDTOModule[])new EventDTOModule[]{ACLModule.ACL_UPDATE}).withoutNestedType()))), cassandraConfiguration);
    }

    @Provides
    @Singleton
    CassandraChangesConfiguration providesCassandraChangesConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            Configuration configuration = propertiesProvider.getConfiguration("cassandra");
            return CassandraChangesConfiguration.from((Configuration)configuration);
        }
        catch (FileNotFoundException e) {
            return CassandraChangesConfiguration.DEFAULT;
        }
    }

    @Singleton
    private static class CassandraMailboxManagerDefinition
    extends MailboxManagerDefinition {
        @Inject
        private CassandraMailboxManagerDefinition(CassandraMailboxManager manager) {
            super("cassandra-mailboxmanager", (MailboxManager)manager);
        }
    }
}

