/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.security.DefaultKeyResult;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.DecryptionKeyRequest;
import io.jsonwebtoken.security.KeyAlgorithm;
import io.jsonwebtoken.security.KeyRequest;
import io.jsonwebtoken.security.KeyResult;
import io.jsonwebtoken.security.SecurityException;
import javax.crypto.SecretKey;

public class DirectKeyAlgorithm
implements KeyAlgorithm<SecretKey, SecretKey> {
    static final String ID = "dir";

    public String getId() {
        return ID;
    }

    public KeyResult getEncryptionKey(KeyRequest<SecretKey> request) throws SecurityException {
        Assert.notNull(request, (String)"request cannot be null.");
        SecretKey key = (SecretKey)Assert.notNull((Object)request.getPayload(), (String)"Encryption key cannot be null.");
        return new DefaultKeyResult(key);
    }

    public SecretKey getDecryptionKey(DecryptionKeyRequest<SecretKey> request) throws SecurityException {
        Assert.notNull(request, (String)"request cannot be null.");
        return (SecretKey)Assert.notNull((Object)request.getKey(), (String)"Decryption key cannot be null.");
    }
}

