/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.transaction;

import com.github.fge.lambdas.Throwing;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.store.transaction.Mapper;
import reactor.core.publisher.Mono;

public abstract class TransactionalMapper
implements Mapper {
    @Override
    public final <T> T execute(Mapper.Transaction<T> transaction) throws MailboxException {
        this.begin();
        try {
            T value = transaction.run();
            this.commit();
            return value;
        }
        catch (MailboxException e) {
            this.rollback();
            throw e;
        }
    }

    @Override
    public final <T> Mono<T> executeReactive(Mono<T> transaction) {
        return Mono.fromRunnable((Runnable)Throwing.runnable(this::begin).sneakyThrow()).then(transaction).doOnSuccess(Throwing.consumer(ignored -> this.commit()).sneakyThrow()).doOnError(MailboxException.class, Throwing.consumer(e -> this.rollback()).sneakyThrow());
    }

    protected abstract void begin() throws MailboxException;

    protected abstract void commit() throws MailboxException;

    protected abstract void rollback() throws MailboxException;
}

