/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres;

import jakarta.mail.Flags;
import java.time.Clock;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.apache.james.events.EventBus;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.mailbox.postgres.PostgresMailboxSessionMapperFactory;
import org.apache.james.mailbox.postgres.mail.PostgresMailbox;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.BatchSizes;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.MessageFactory;
import org.apache.james.mailbox.store.MessageStorer;
import org.apache.james.mailbox.store.PreDeletionHooks;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.StoreMessageManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.mail.AttachmentMapperFactory;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import reactor.core.publisher.Mono;

public class PostgresMessageManager
extends StoreMessageManager {
    private final MailboxSessionMapperFactory mapperFactory;
    private final StoreRightManager storeRightManager;
    private final Mailbox mailbox;

    public PostgresMessageManager(PostgresMailboxSessionMapperFactory mapperFactory, MessageSearchIndex index, EventBus eventBus, MailboxPathLocker locker, Mailbox mailbox, QuotaManager quotaManager, QuotaRootResolver quotaRootResolver, MessageParser messageParser, MessageId.Factory messageIdFactory, BatchSizes batchSizes, StoreRightManager storeRightManager, ThreadIdGuessingAlgorithm threadIdGuessingAlgorithm, Clock clock, PreDeletionHooks preDeletionHooks) {
        super(StoreMailboxManager.DEFAULT_NO_MESSAGE_CAPABILITIES, (MailboxSessionMapperFactory)mapperFactory, index, eventBus, locker, mailbox, quotaManager, quotaRootResolver, batchSizes, storeRightManager, preDeletionHooks, (MessageStorer)new MessageStorer.WithAttachment((MailboxSessionMapperFactory)mapperFactory, messageIdFactory, (MessageFactory)new MessageFactory.StoreMessageFactory(), (AttachmentMapperFactory)mapperFactory, messageParser, threadIdGuessingAlgorithm, clock));
        this.storeRightManager = storeRightManager;
        this.mapperFactory = mapperFactory;
        this.mailbox = mailbox;
    }

    public Flags getPermanentFlags(MailboxSession session) {
        Flags flags = super.getPermanentFlags(session);
        flags.add(Flags.Flag.USER);
        return flags;
    }

    public Mono<MessageManager.MailboxMetaData> getMetaDataReactive(MessageManager.MailboxMetaData.RecentMode recentMode, MailboxSession mailboxSession, EnumSet<MessageManager.MailboxMetaData.Item> items) throws MailboxException {
        if (!this.storeRightManager.hasRight(this.mailbox, MailboxACL.Right.Read, mailboxSession)) {
            return Mono.just((Object)MessageManager.MailboxMetaData.sensibleInformationFree((MailboxACL)this.getResolvedAcl(mailboxSession), (UidValidity)this.getMailboxEntity().getUidValidity(), (boolean)this.isWriteable(mailboxSession)));
        }
        Flags permanentFlags = this.getPermanentFlags(mailboxSession);
        MessageMapper messageMapper = this.mapperFactory.getMessageMapper(mailboxSession);
        Mono postgresMailboxMetaDataPublisher = Mono.just((Object)this.mapperFactory.getMailboxMapper(mailboxSession)).flatMap(postgresMailboxMapper -> postgresMailboxMapper.findMailboxById(this.getMailboxEntity().getMailboxId()).map(mailbox -> (PostgresMailbox)((Object)((Object)mailbox))));
        Mono firstUnseenAndRecentPublisher = Mono.zip((Mono)this.firstUnseen(messageMapper, items), (Mono)this.recent(recentMode, mailboxSession));
        return messageMapper.executeReactive(Mono.zip((Mono)postgresMailboxMetaDataPublisher, (Mono)this.mailboxCounters(messageMapper, items)).flatMap(metadataAndCounter -> {
            PostgresMailbox metadata = (PostgresMailbox)((Object)((Object)metadataAndCounter.getT1()));
            MailboxCounters counters = (MailboxCounters)metadataAndCounter.getT2();
            return firstUnseenAndRecentPublisher.map(firstUnseenAndRecent -> new MessageManager.MailboxMetaData((List)firstUnseenAndRecent.getT2(), permanentFlags, metadata.getUidValidity(), this.nextUid(metadata), metadata.getHighestModSeq(), counters.getCount(), counters.getUnseen(), (MessageUid)((Optional)firstUnseenAndRecent.getT1()).orElse(null), this.isWriteable(mailboxSession), metadata.getACL()));
        }));
    }

    private MessageUid nextUid(PostgresMailbox mailboxMetaData) {
        return Optional.ofNullable(mailboxMetaData.getLastUid()).map(MessageUid::next).orElse(MessageUid.MIN_VALUE);
    }
}

