/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.EndPoint;
import com.datastax.driver.core.exceptions.CoordinatorException;
import com.datastax.driver.core.exceptions.QueryExecutionException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public abstract class QueryConsistencyException
extends QueryExecutionException
implements CoordinatorException {
    private final EndPoint endPoint;
    private final ConsistencyLevel consistency;
    private final int received;
    private final int required;

    protected QueryConsistencyException(EndPoint endPoint, String msg, ConsistencyLevel consistency, int received, int required) {
        super(msg);
        this.endPoint = endPoint;
        this.consistency = consistency;
        this.received = received;
        this.required = required;
    }

    protected QueryConsistencyException(EndPoint endPoint, String msg, Throwable cause, ConsistencyLevel consistency, int received, int required) {
        super(msg, cause);
        this.endPoint = endPoint;
        this.consistency = consistency;
        this.received = received;
        this.required = required;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistency;
    }

    public int getReceivedAcknowledgements() {
        return this.received;
    }

    public int getRequiredAcknowledgements() {
        return this.required;
    }

    @Override
    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    @Override
    @Deprecated
    public InetSocketAddress getAddress() {
        return this.endPoint == null ? null : this.endPoint.resolve();
    }

    @Override
    @Deprecated
    public InetAddress getHost() {
        return this.endPoint == null ? null : this.endPoint.resolve().getAddress();
    }
}

