/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.core;

import org.apache.james.jspf.core.exceptions.NoneException;
import org.xbill.DNS.Name;
import org.xbill.DNS.TextParseException;

public final class DNSRequest {
    public static final int A = 1;
    public static final int AAAA = 2;
    public static final int MX = 3;
    public static final int PTR = 4;
    public static final int TXT = 5;
    public static final int SPF = 6;
    private final String hostname;
    private final int recordType;

    public DNSRequest(String hostname, int recordType) throws NoneException {
        if (recordType == 3 || recordType == 1 || recordType == 2) {
            try {
                Name.fromString((String)hostname);
            }
            catch (TextParseException e) {
                throw new NoneException(e.getMessage());
            }
        }
        this.hostname = hostname;
        this.recordType = recordType;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final int getRecordType() {
        return this.recordType;
    }

    public String toString() {
        return this.getHostname() + "#" + this.getRecordType();
    }
}

