/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.block.function;

import java.util.Collection;
import java.util.Map;
import org.eclipse.collections.api.block.function.Function2;

public final class MaxSizeFunction {
    public static final Function2<Integer, String, Integer> STRING = new MaxSizeStringFunction();
    public static final Function2<Integer, Collection<?>, Integer> COLLECTION = new MaxSizeCollectionFunction();
    public static final Function2<Integer, Map<?, ?>, Integer> MAP = new MaxSizeMapFunction();

    private MaxSizeFunction() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    private static class MaxSizeMapFunction
    implements Function2<Integer, Map<?, ?>, Integer> {
        private static final long serialVersionUID = 1L;

        private MaxSizeMapFunction() {
        }

        @Override
        public Integer value(Integer previousMax, Map<?, ?> map) {
            return Math.max(previousMax, map.size());
        }
    }

    private static class MaxSizeCollectionFunction
    implements Function2<Integer, Collection<?>, Integer> {
        private static final long serialVersionUID = 1L;

        private MaxSizeCollectionFunction() {
        }

        @Override
        public Integer value(Integer previousMax, Collection<?> collection) {
            return Math.max(previousMax, collection.size());
        }
    }

    private static class MaxSizeStringFunction
    implements Function2<Integer, String, Integer> {
        private static final long serialVersionUID = 1L;

        private MaxSizeStringFunction() {
        }

        @Override
        public Integer value(Integer previousMax, String s2) {
            return Math.max(previousMax, s2.length());
        }
    }
}

