/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.unary;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExpressionVisitor;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class LikeExpression
extends UnaryExpression {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(LikeExpression.class);
    private final String pattern;
    private final Optional<Character> escape;
    private final boolean isNot;

    public LikeExpression(Expression expression, String pattern, Optional<Character> escape, boolean isNot) {
        super(expression);
        this.pattern = pattern;
        this.escape = escape;
        this.isNot = isNot;
    }

    public LikeExpression(Expression expression, String pattern, boolean isNot) {
        super(expression);
        this.pattern = pattern;
        this.escape = Optional.empty();
        this.isNot = isNot;
    }

    public LikeExpression(ByteBuffer byteBuffer) {
        super(Expression.deserialize(byteBuffer));
        this.pattern = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.escape = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer) ? Optional.of(Character.valueOf(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer).charAt(0))) : Optional.empty();
        this.isNot = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
    }

    public String getPattern() {
        return this.pattern;
    }

    public Optional<Character> getEscape() {
        return this.escape;
    }

    public boolean isNot() {
        return this.isNot;
    }

    @Override
    protected String getExpressionStringInternal() {
        String res = this.expression.getExpressionString() + (this.isNot ? " NOT" : "") + " LIKE pattern = '" + this.pattern + "'";
        if (this.escape.isPresent()) {
            res = res + " escape = '" + this.escape.get() + "'";
        }
        return res;
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.LIKE;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        super.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.pattern, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.escape.isPresent(), (ByteBuffer)byteBuffer);
        if (this.escape.isPresent()) {
            ReadWriteIOUtils.write((String)this.escape.get().toString(), (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((Boolean)this.isNot, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.pattern, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.escape.isPresent(), (OutputStream)stream);
        if (this.escape.isPresent()) {
            ReadWriteIOUtils.write((String)this.escape.get().toString(), (OutputStream)stream);
        }
        ReadWriteIOUtils.write((Boolean)this.isNot, (OutputStream)stream);
    }

    @Override
    public String getOutputSymbolInternal() {
        String res = this.expression.getOutputSymbol() + (this.isNot ? " NOT" : "") + " LIKE pattern = '" + this.pattern + "'";
        if (this.escape.isPresent()) {
            res = res + " escape = '" + this.escape.get() + "'";
        }
        return res;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitLikeExpression(this, context);
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.expression) + RamUsageEstimator.sizeOf((String)this.pattern);
    }

    public static Optional<Character> getEscapeCharacter(String escape) {
        if (escape.length() == 1) {
            return Optional.of(Character.valueOf(escape.charAt(0)));
        }
        throw new SemanticException("Escape string must be a single character");
    }
}

