/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.delegates;

import org.eclipse.milo.opcua.sdk.core.nodes.Node;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaDataTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaReferenceTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaViewNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetBase;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetDataTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetObjectNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetReferenceTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetVariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetVariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetViewNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;

public interface AttributeDelegate
extends GetSetBase,
GetSetDataTypeNode,
GetSetMethodNode,
GetSetObjectNode,
GetSetObjectTypeNode,
GetSetReferenceTypeNode,
GetSetVariableNode,
GetSetVariableTypeNode,
GetSetViewNode {
    public static final AttributeDelegate DEFAULT = new AttributeDelegate(){};

    default public DataValue getAttribute(AttributeContext context, UaNode node, AttributeId attributeId) {
        try {
            switch (node.getNodeClass()) {
                case DataType: {
                    return this.getDataTypeAttribute(context, (UaDataTypeNode)node, attributeId);
                }
                case Method: {
                    return this.getMethodAttribute(context, (UaMethodNode)node, attributeId);
                }
                case Object: {
                    return this.getObjectAttribute(context, (UaObjectNode)node, attributeId);
                }
                case ObjectType: {
                    return this.getObjectTypeAttribute(context, (UaObjectTypeNode)node, attributeId);
                }
                case ReferenceType: {
                    return this.getReferenceTypeAttribute(context, (UaReferenceTypeNode)node, attributeId);
                }
                case Variable: {
                    return this.getVariableAttribute(context, (UaVariableNode)node, attributeId);
                }
                case VariableType: {
                    return this.getVariableTypeAttribute(context, (UaVariableTypeNode)node, attributeId);
                }
                case View: {
                    return this.getViewAttribute(context, (UaViewNode)node, attributeId);
                }
            }
            throw new UaException(2153709568L);
        }
        catch (UaException e) {
            return new DataValue(e.getStatusCode());
        }
    }

    default public void setAttribute(AttributeContext context, Node node, AttributeId attributeId, DataValue value) throws UaException {
        switch (node.getNodeClass()) {
            case DataType: {
                this.setDataTypeAttribute(context, (UaDataTypeNode)node, attributeId, value);
                break;
            }
            case Method: {
                this.setMethodAttribute(context, (UaMethodNode)node, attributeId, value);
                break;
            }
            case Object: {
                this.setObjectAttribute(context, (UaObjectNode)node, attributeId, value);
                break;
            }
            case ObjectType: {
                this.setObjectTypeAttribute(context, (UaObjectTypeNode)node, attributeId, value);
                break;
            }
            case ReferenceType: {
                this.setReferenceTypeAttribute(context, (UaReferenceTypeNode)node, attributeId, value);
                break;
            }
            case Variable: {
                this.setVariableAttribute(context, (UaVariableNode)node, attributeId, value);
                break;
            }
            case VariableType: {
                this.setVariableTypeAttribute(context, (UaVariableTypeNode)node, attributeId, value);
                break;
            }
            case View: {
                this.setViewAttribute(context, (UaViewNode)node, attributeId, value);
                break;
            }
            default: {
                throw new UaException(2153709568L);
            }
        }
    }
}

