/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.apache.iotdb.consensus.exception.ConsensusException;

@ThreadSafe
public interface IConsensus {
    public void start() throws IOException;

    public void stop() throws IOException;

    public TSStatus write(ConsensusGroupId var1, IConsensusRequest var2) throws ConsensusException;

    public DataSet read(ConsensusGroupId var1, IConsensusRequest var2) throws ConsensusException;

    public void createLocalPeer(ConsensusGroupId var1, List<Peer> var2) throws ConsensusException;

    public void deleteLocalPeer(ConsensusGroupId var1) throws ConsensusException;

    public void addRemotePeer(ConsensusGroupId var1, Peer var2) throws ConsensusException;

    public void removeRemotePeer(ConsensusGroupId var1, Peer var2) throws ConsensusException;

    public void recordCorrectPeerListBeforeStarting(Map<ConsensusGroupId, List<Peer>> var1);

    public void resetPeerList(ConsensusGroupId var1, List<Peer> var2) throws ConsensusException;

    public void transferLeader(ConsensusGroupId var1, Peer var2) throws ConsensusException;

    public void triggerSnapshot(ConsensusGroupId var1, boolean var2) throws ConsensusException;

    public boolean isLeader(ConsensusGroupId var1);

    public long getLogicalClock(ConsensusGroupId var1);

    public boolean isLeaderReady(ConsensusGroupId var1);

    public Peer getLeader(ConsensusGroupId var1);

    public int getReplicationNum(ConsensusGroupId var1);

    public List<ConsensusGroupId> getAllConsensusGroupIds();

    public String getRegionDirFromConsensusGroupId(ConsensusGroupId var1);

    public void reloadConsensusConfig(ConsensusConfig var1);
}

