/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.rescon;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.schemaengine.rescon.CachedSchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.rescon.ISchemaEngineStatistics;
import org.apache.iotdb.db.schemaengine.rescon.ISchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.rescon.MemSchemaEngineStatistics;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.iotdb.db.schemaengine.template.Template;

public class MemSchemaRegionStatistics
implements ISchemaRegionStatistics {
    protected MemSchemaEngineStatistics schemaEngineStatistics;
    private final int schemaRegionId;
    private final AtomicLong memoryUsage = new AtomicLong(0L);
    private final AtomicLong measurementNumber = new AtomicLong(0L);
    private final AtomicLong devicesNumber = new AtomicLong(0L);
    private final AtomicLong viewNumber = new AtomicLong(0L);
    private final Map<Integer, Integer> templateUsage = new ConcurrentHashMap<Integer, Integer>();
    private long mlogLength = 0L;

    public MemSchemaRegionStatistics(int schemaRegionId, ISchemaEngineStatistics engineStatistics) {
        this.schemaEngineStatistics = engineStatistics.getAsMemSchemaEngineStatistics();
        this.schemaRegionId = schemaRegionId;
    }

    @Override
    public boolean isAllowToCreateNewSeries() {
        return this.schemaEngineStatistics.isAllowToCreateNewSeries();
    }

    public void requestMemory(long size) {
        this.memoryUsage.addAndGet(size);
        this.schemaEngineStatistics.requestMemory(size);
    }

    public void releaseMemory(long size) {
        this.memoryUsage.addAndGet(-size);
        this.schemaEngineStatistics.releaseMemory(size);
    }

    @Override
    public long getSeriesNumber(boolean includeView) {
        if (includeView) {
            return this.viewNumber.get() + this.measurementNumber.get() + this.getTemplateSeriesNumber();
        }
        return this.measurementNumber.get() + this.getTemplateSeriesNumber();
    }

    public void addMeasurement(long addedNum) {
        this.measurementNumber.addAndGet(addedNum);
        this.schemaEngineStatistics.addMeasurement(addedNum);
    }

    public void deleteMeasurement(long deletedNum) {
        this.measurementNumber.addAndGet(-deletedNum);
        this.schemaEngineStatistics.deleteMeasurement(deletedNum);
    }

    public void addView(long addedNum) {
        this.viewNumber.addAndGet(addedNum);
        this.schemaEngineStatistics.addView(addedNum);
    }

    public void deleteView(long deletedNum) {
        this.viewNumber.addAndGet(-deletedNum);
        this.schemaEngineStatistics.deleteView(deletedNum);
    }

    @Override
    public long getDevicesNumber() {
        return this.devicesNumber.get();
    }

    public void addDevice() {
        this.devicesNumber.incrementAndGet();
        this.schemaEngineStatistics.addDevice();
    }

    public void deleteDevice() {
        this.devicesNumber.decrementAndGet();
        this.schemaEngineStatistics.deleteDevice(1L);
    }

    @Override
    public int getTemplateActivatedNumber() {
        return this.templateUsage.size();
    }

    @Override
    public long getTemplateSeriesNumber() {
        ClusterTemplateManager clusterTemplateManager = ClusterTemplateManager.getInstance();
        return this.templateUsage.entrySet().stream().mapToLong(i -> {
            Template t = clusterTemplateManager.getTemplate((Integer)i.getKey());
            return t == null ? 0L : (long)t.getMeasurementNumber() * (long)((Integer)i.getValue()).intValue();
        }).sum();
    }

    public void activateTemplate(int templateId) {
        this.templateUsage.compute(templateId, (k, v) -> v == null ? 1 : v + 1);
        this.schemaEngineStatistics.activateTemplate(templateId);
    }

    public void deactivateTemplate(int templateId) {
        this.templateUsage.compute(templateId, (k, v) -> v == null || v == 1 ? null : Integer.valueOf(v - 1));
        this.schemaEngineStatistics.deactivateTemplate(templateId, 1);
    }

    @Override
    public long getRegionMemoryUsage() {
        return this.memoryUsage.get();
    }

    @Override
    public int getSchemaRegionId() {
        return this.schemaRegionId;
    }

    public void setMlogLength(long mlogLength) {
        this.mlogLength = mlogLength;
    }

    public long getMlogLength() {
        return this.mlogLength;
    }

    @Override
    public MemSchemaRegionStatistics getAsMemSchemaRegionStatistics() {
        return this;
    }

    @Override
    public CachedSchemaRegionStatistics getAsCachedSchemaRegionStatistics() {
        throw new UnsupportedOperationException("Wrong SchemaRegionStatistics Type");
    }

    @Override
    public void clear() {
        this.schemaEngineStatistics.releaseMemory(this.memoryUsage.get());
        this.schemaEngineStatistics.deleteMeasurement(this.measurementNumber.get());
        this.schemaEngineStatistics.deleteView(this.viewNumber.get());
        this.schemaEngineStatistics.deleteDevice(this.devicesNumber.get());
        this.memoryUsage.getAndSet(0L);
        this.measurementNumber.getAndSet(0L);
        this.devicesNumber.getAndSet(0L);
        this.viewNumber.getAndAdd(0L);
        this.templateUsage.forEach((templateId, cnt) -> this.schemaEngineStatistics.deactivateTemplate((int)templateId, (int)cnt));
        this.templateUsage.clear();
    }

    @Override
    public long getGlobalMemoryUsage() {
        return this.schemaEngineStatistics.getMemoryUsage();
    }

    @Override
    public long getGlobalSeriesNumber() {
        return this.schemaEngineStatistics.getTotalSeriesNumber();
    }
}

