/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.multi.builtin.helper;

import java.util.Map;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.multi.builtin.BuiltInScalarFunctionHelper;
import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar.ReplaceFunctionColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.Transformer;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary.scalar.ReplaceFunctionTransformer;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.type.TypeFactory;

public class ReplaceFunctionHelper
implements BuiltInScalarFunctionHelper {
    @Override
    public void checkBuiltInScalarFunctionInputDataType(TSDataType tsDataType) throws SemanticException {
        if (TSDataType.TEXT.equals((Object)tsDataType) || TSDataType.STRING.equals((Object)tsDataType)) {
            return;
        }
        throw new SemanticException(String.format("Unsupported data type %s for function REPLACE.", tsDataType));
    }

    @Override
    public TSDataType getBuiltInScalarFunctionReturnType(FunctionExpression functionExpression) {
        return TSDataType.TEXT;
    }

    @Override
    public ColumnTransformer getBuiltInScalarFunctionColumnTransformer(FunctionExpression expression, ColumnTransformer columnTransformer) {
        this.checkFromAndToAttributes(expression);
        return new ReplaceFunctionColumnTransformer(TypeFactory.getType((TSDataType)TSDataType.TEXT), columnTransformer, expression.getFunctionAttributes().get("FROM"), expression.getFunctionAttributes().get("TO"));
    }

    @Override
    public Transformer getBuiltInScalarFunctionTransformer(FunctionExpression expression, LayerReader layerReader) {
        this.checkFromAndToAttributes(expression);
        return new ReplaceFunctionTransformer(layerReader, expression.getFunctionAttributes().get("FROM"), expression.getFunctionAttributes().get("TO"));
    }

    @Override
    public void appendFunctionAttributes(boolean hasExpression, StringBuilder builder, Map<String, String> functionAttributes) {
        builder.append(", '");
        builder.append(functionAttributes.get("FROM"));
        builder.append("', '");
        builder.append(functionAttributes.get("TO"));
        builder.append("'");
    }

    private void checkFromAndToAttributes(FunctionExpression expression) {
        if (!expression.getFunctionAttributes().containsKey("FROM") || !expression.getFunctionAttributes().containsKey("TO")) {
            throw new SemanticException("Function REPLACE must specify from and to component.");
        }
    }
}

