/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client.property;

import java.util.concurrent.TimeUnit;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class ThriftClientProperty {
    private final TProtocolFactory protocolFactory;
    private final int connectionTimeoutMs;
    private final int selectorNumOfAsyncClientPool;
    private final boolean printLogWhenEncounterException;

    private ThriftClientProperty(TProtocolFactory protocolFactory, int connectionTimeoutMs, int selectorNumOfAsyncClientPool, boolean printLogWhenEncounterException) {
        this.protocolFactory = protocolFactory;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.selectorNumOfAsyncClientPool = selectorNumOfAsyncClientPool;
        this.printLogWhenEncounterException = printLogWhenEncounterException;
    }

    public TProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public int getSelectorNumOfAsyncClientPool() {
        return this.selectorNumOfAsyncClientPool;
    }

    public boolean isPrintLogWhenEncounterException() {
        return this.printLogWhenEncounterException;
    }

    public static class DefaultProperty {
        public static final boolean RPC_THRIFT_COMPRESSED_ENABLED = false;
        public static final int CONNECTION_TIMEOUT_MS = (int)TimeUnit.SECONDS.toMillis(20L);
        public static final int CONNECTION_NEVER_TIMEOUT_MS = 0;
        public static final int SELECTOR_NUM_OF_ASYNC_CLIENT_MANAGER = 1;
        public static final boolean PRINT_LOG_WHEN_ENCOUNTER_EXCEPTION = true;

        private DefaultProperty() {
        }
    }

    public static class Builder {
        private boolean rpcThriftCompressionEnabled = false;
        private int connectionTimeoutMs = DefaultProperty.CONNECTION_TIMEOUT_MS;
        private int selectorNumOfAsyncClientManager = 1;
        private boolean printLogWhenEncounterException = true;

        public Builder setRpcThriftCompressionEnabled(boolean rpcThriftCompressionEnabled) {
            this.rpcThriftCompressionEnabled = rpcThriftCompressionEnabled;
            return this;
        }

        public Builder setConnectionTimeoutMs(int connectionTimeoutMs) {
            this.connectionTimeoutMs = connectionTimeoutMs;
            return this;
        }

        public Builder setSelectorNumOfAsyncClientManager(int selectorNumOfAsyncClientManager) {
            this.selectorNumOfAsyncClientManager = selectorNumOfAsyncClientManager;
            return this;
        }

        public Builder setPrintLogWhenEncounterException(boolean printLogWhenEncounterException) {
            this.printLogWhenEncounterException = printLogWhenEncounterException;
            return this;
        }

        public ThriftClientProperty build() {
            return new ThriftClientProperty((TProtocolFactory)(this.rpcThriftCompressionEnabled ? new TCompactProtocol.Factory() : new TBinaryProtocol.Factory()), this.connectionTimeoutMs, this.selectorNumOfAsyncClientManager, this.printLogWhenEncounterException);
        }
    }
}

