/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.rsc.driver;

import java.util.List;
import org.apache.livy.Job;
import org.apache.livy.JobHandle;
import org.apache.livy.rsc.BypassJobStatus;
import org.apache.livy.rsc.Utils;
import org.apache.livy.rsc.driver.JobWrapper;
import org.apache.livy.rsc.driver.RSCDriver;

public class BypassJobWrapper
extends JobWrapper<byte[]> {
    private volatile byte[] result;
    private volatile Throwable error;
    private volatile JobHandle.State state = JobHandle.State.QUEUED;
    private volatile List<Integer> newSparkJobs;

    public BypassJobWrapper(RSCDriver driver, String jobId, Job<byte[]> serializedJob) {
        super(driver, jobId, serializedJob);
    }

    @Override
    public Void call() throws Exception {
        this.tryTransitionToState(JobHandle.State.STARTED);
        return super.call();
    }

    @Override
    protected synchronized void finished(byte[] result, Throwable error) {
        if (error == null && this.tryTransitionToState(JobHandle.State.SUCCEEDED)) {
            this.result = result;
        } else if (error != null && this.tryTransitionToState(JobHandle.State.FAILED)) {
            this.error = error;
        }
    }

    @Override
    synchronized boolean cancel() {
        return this.tryTransitionToState(JobHandle.State.CANCELLED) && super.cancel();
    }

    private synchronized boolean tryTransitionToState(JobHandle.State newState) {
        boolean success = false;
        switch (this.state) {
            case QUEUED: {
                if (newState != JobHandle.State.STARTED && newState != JobHandle.State.CANCELLED) break;
                this.state = newState;
                success = true;
                break;
            }
            case STARTED: {
                if (newState != JobHandle.State.CANCELLED && newState != JobHandle.State.SUCCEEDED && newState != JobHandle.State.FAILED) break;
                this.state = newState;
                success = true;
                break;
            }
        }
        return success;
    }

    @Override
    protected void jobStarted() {
    }

    synchronized BypassJobStatus getStatus() {
        String stackTrace = this.error != null ? Utils.stackTraceAsString(this.error) : null;
        return new BypassJobStatus(this.state, this.result, stackTrace);
    }
}

