/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.client.common;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.livy.annotations.Private;

@Private
public class TestUtils {
    public static String getJacocoArgs() {
        File newFile;
        String jacocoArgs = System.getProperty("jacoco.args");
        if (jacocoArgs == null) {
            return null;
        }
        Pattern p = Pattern.compile("(.+?destfile=)(.+?)(,.+)?");
        Matcher m = p.matcher(jacocoArgs);
        if (!m.matches()) {
            return null;
        }
        String fileName = new File(m.group(2)).getName();
        File outputDir = new File(m.group(2)).getParentFile();
        while (true) {
            int newId = outputDir.list().length;
            newFile = new File(outputDir, "jacoco-" + newId + ".exec");
            try {
                Files.newOutputStream(newFile.toPath(), StandardOpenOption.CREATE_NEW).close();
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
        StringBuilder newArgs = new StringBuilder();
        newArgs.append(m.group(1));
        newArgs.append(newFile.getAbsolutePath());
        if (m.group(3) != null) {
            newArgs.append(m.group(3));
        }
        return newArgs.toString();
    }
}

