/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.server.interactive;

import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.livy.ExecuteRequest;
import org.apache.livy.Job;
import org.apache.livy.JobHandle;
import org.apache.livy.LivyConf;
import org.apache.livy.client.common.HttpMessages;
import org.apache.livy.rsc.BypassJobStatus;
import org.apache.livy.rsc.PingJob;
import org.apache.livy.rsc.RSCClient;
import org.apache.livy.rsc.ReplJobResults;
import org.apache.livy.rsc.driver.Statement;
import org.apache.livy.server.interactive.CreateInteractiveRequest;
import org.apache.livy.server.interactive.InteractiveRecoveryMetadata;
import org.apache.livy.server.interactive.InteractiveRecoveryMetadata$;
import org.apache.livy.server.interactive.InteractiveSession$;
import org.apache.livy.server.interactive.InteractiveSession$$anon$1$;
import org.apache.livy.server.interactive.SessionHeartbeat;
import org.apache.livy.server.interactive.SessionHeartbeat$class;
import org.apache.livy.server.recovery.SessionStore;
import org.apache.livy.sessions.Kind;
import org.apache.livy.sessions.Session;
import org.apache.livy.sessions.Session$;
import org.apache.livy.sessions.SessionState;
import org.apache.livy.sessions.SessionState$;
import org.apache.livy.utils.AppInfo;
import org.apache.livy.utils.SparkApp;
import org.apache.livy.utils.SparkApp$State$;
import org.apache.livy.utils.SparkAppListener;
import org.apache.livy.utils.SparkAppListener$class;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\rx!B\u0001\u0003\u0011\u0003i\u0011AE%oi\u0016\u0014\u0018m\u0019;jm\u0016\u001cVm]:j_:T!a\u0001\u0003\u0002\u0017%tG/\u001a:bGRLg/\u001a\u0006\u0003\u000b\u0019\taa]3sm\u0016\u0014(BA\u0004\t\u0003\u0011a\u0017N^=\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001!\tqq\"D\u0001\u0003\r\u0015\u0001\"\u0001#\u0001\u0012\u0005IIe\u000e^3sC\u000e$\u0018N^3TKN\u001c\u0018n\u001c8\u0014\u0007=\u0011\u0002\u0004\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\t\u00033ii\u0011AB\u0005\u00037\u0019\u0011q\u0001T8hO&tw\rC\u0003\u001e\u001f\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002\u001b!A\u0001e\u0004b\u0001\n\u0003\u0011\u0011%\u0001\u000bT!\u0006\u00136jX-B%:{\u0016jU0Q3RCuJT\u000b\u0002EA\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0005Y\u0006twMC\u0001(\u0003\u0011Q\u0017M^1\n\u0005%\"#AB*ue&tw\r\u0003\u0004,\u001f\u0001\u0006IAI\u0001\u0016'B\u000b%kS0Z\u0003Jsu,S*`!f#\u0006j\u0014(!\u0011\u001disB1A\u0005\u0002\u0005\nQCU#D\u001fZ+%+W0T\u000bN\u001b\u0016j\u0014(`)f\u0003V\t\u0003\u00040\u001f\u0001\u0006IAI\u0001\u0017%\u0016\u001buJV#S3~\u001bViU*J\u001f:{F+\u0017)FA!)\u0011g\u0004C\u0001e\u000511M]3bi\u0016$\u0012cMB-\u00077\u001aifa\u0018\u0004b\r-4QNB8!\tqAG\u0002\u0003\u0011\u0005\u0001)4\u0003\u0002\u001b7y}\u0002\"a\u000e\u001e\u000e\u0003aR!!\u000f\u0004\u0002\u0011M,7o]5p]NL!a\u000f\u001d\u0003\u000fM+7o]5p]B\u0011a\"P\u0005\u0003}\t\u0011\u0001cU3tg&|g\u000eS3beR\u0014W-\u0019;\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t3\u0011!B;uS2\u001c\u0018B\u0001#B\u0005A\u0019\u0006/\u0019:l\u0003B\u0004H*[:uK:,'\u000fC\u0005Gi\t\u0005\t\u0015!\u0003H\u0015\u0006\u0011\u0011\u000e\u001a\t\u0003'!K!!\u0013\u000b\u0003\u0007%sG/\u0003\u0002Gu!AA\n\u000eB\u0001B\u0003%Q*A\u0005baBLE\rS5oiB\u00191C\u0014)\n\u0005=#\"AB(qi&|g\u000e\u0005\u0002R):\u00111CU\u0005\u0003'R\ta\u0001\u0015:fI\u00164\u0017BA\u0015V\u0015\t\u0019F\u0003\u0003\u0005Xi\t\u0005\t\u0015!\u0003Q\u0003\u0019\t\u0007\u000f\u001d+bO\"A\u0011\f\u000eB\u0001B\u0003%!,\u0001\u0004dY&,g\u000e\u001e\t\u0004'9[\u0006C\u0001/`\u001b\u0005i&B\u00010\u0007\u0003\r\u00118oY\u0005\u0003Av\u0013\u0011BU*D\u00072LWM\u001c;\t\u0011\t$$\u0011!Q\u0001\n\r\fA\"\u001b8ji&\fGn\u0015;bi\u0016\u0004\"a\u000e3\n\u0005\u0015D$\u0001D*fgNLwN\\*uCR,\u0007\u0002C45\u0005\u000b\u0007I\u0011\u00015\u0002\t-Lg\u000eZ\u000b\u0002SB\u0011qG[\u0005\u0003Wb\u0012AaS5oI\"AQ\u000e\u000eB\u0001B\u0003%\u0011.A\u0003lS:$\u0007\u0005\u0003\u0005pi\t\u0005\t\u0015!\u0003H\u0003EAW-\u0019:uE\u0016\fG\u000fV5nK>,Ho\u0015\u0005\ncR\u0012\t\u0011)A\u0005eV\f\u0001\u0002\\5ws\u000e{gN\u001a\t\u00033ML!\u0001\u001e\u0004\u0003\u00111Kg/_\"p]\u001aL!!\u001d\u001e\t\u0013]$$\u0011!Q\u0001\nAC\u0018!B8x]\u0016\u0014\u0018BA<;\u0011!QHG!b\u0001\n\u0003Z\u0018!\u00039s_bLXk]3s+\u0005i\u0005\u0002C?5\u0005\u0003\u0005\u000b\u0011B'\u0002\u0015A\u0014x\u000e_=Vg\u0016\u0014\b\u0005C\u0005\u0000i\t\u0005\t\u0015!\u0003\u0002\u0002\u0005a1/Z:tS>t7\u000b^8sKB!\u00111AA\u0005\u001b\t\t)AC\u0002\u0002\b\u0011\t\u0001B]3d_Z,'/_\u0005\u0005\u0003\u0017\t)A\u0001\u0007TKN\u001c\u0018n\u001c8Ti>\u0014X\r\u0003\u0006\u0002\u0010Q\u0012\t\u0011)A\u0005\u0003#\tq!\\8dW\u0006\u0003\b\u000f\u0005\u0003\u0014\u001d\u0006M\u0001c\u0001!\u0002\u0016%\u0019\u0011qC!\u0003\u0011M\u0003\u0018M]6BaBDa!\b\u001b\u0005\u0002\u0005mA#G\u001a\u0002\u001e\u0005}\u0011\u0011EA\u0012\u0003K\t9#!\u000b\u0002,\u00055\u0012qFA\u0019\u0003gAaARA\r\u0001\u00049\u0005B\u0002'\u0002\u001a\u0001\u0007Q\n\u0003\u0004X\u00033\u0001\r\u0001\u0015\u0005\u00073\u0006e\u0001\u0019\u0001.\t\r\t\fI\u00021\u0001d\u0011\u00199\u0017\u0011\u0004a\u0001S\"1q.!\u0007A\u0002\u001dCa!]A\r\u0001\u0004\u0011\bBB<\u0002\u001a\u0001\u0007\u0001\u000b\u0003\u0004{\u00033\u0001\r!\u0014\u0005\b\u007f\u0006e\u0001\u0019AA\u0001\u0011!\ty!!\u0007A\u0002\u0005E\u0001\"CA\u001ci\u0001\u0007I\u0011BA\u001d\u0003=\u0019XM\u001d<feNKG-Z*uCR,W#A2\t\u0013\u0005uB\u00071A\u0005\n\u0005}\u0012aE:feZ,'oU5eKN#\u0018\r^3`I\u0015\fH\u0003BA!\u0003\u000f\u00022aEA\"\u0013\r\t)\u0005\u0006\u0002\u0005+:LG\u000fC\u0005\u0002J\u0005m\u0012\u0011!a\u0001G\u0006\u0019\u0001\u0010J\u0019\t\u000f\u00055C\u0007)Q\u0005G\u0006\u00012/\u001a:wKJ\u001c\u0016\u000eZ3Ti\u0006$X\r\t\u0005\n\u0003#\"$\u0019!C)\u0003'\n\u0001\u0003[3beR\u0014W-\u0019;US6,w.\u001e;\u0016\u0005\u0005U\u0003\u0003BA,\u0003Cj!!!\u0017\u000b\t\u0005m\u0013QL\u0001\tIV\u0014\u0018\r^5p]*\u0019\u0011q\f\u000b\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002d\u0005e#A\u0004$j]&$X\rR;sCRLwN\u001c\u0005\t\u0003O\"\u0004\u0015!\u0003\u0002V\u0005\t\u0002.Z1si\n,\u0017\r\u001e+j[\u0016|W\u000f\u001e\u0011\t\u0013\u0005-DG1A\u0005\n\u00055\u0014AC8qKJ\fG/[8ogV\u0011\u0011q\u000e\t\b\u0003c\nY(a Q\u001b\t\t\u0019H\u0003\u0003\u0002v\u0005]\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003s\"\u0012AC2pY2,7\r^5p]&!\u0011QPA:\u0005\ri\u0015\r\u001d\t\u0004'\u0005\u0005\u0015bAAB)\t!Aj\u001c8h\u0011!\t9\t\u000eQ\u0001\n\u0005=\u0014aC8qKJ\fG/[8og\u0002B\u0011\"a#5\u0005\u0004%I!!$\u0002!=\u0004XM]1uS>t7i\\;oi\u0016\u0014XCAAH!\u0011\t\t*!(\u000e\u0005\u0005M%\u0002BAK\u0003/\u000ba!\u0019;p[&\u001c'\u0002BA0\u00033S1!a''\u0003\u0011)H/\u001b7\n\t\u0005}\u00151\u0013\u0002\u000b\u0003R|W.[2M_:<\u0007\u0002CARi\u0001\u0006I!a$\u0002#=\u0004XM]1uS>t7i\\;oi\u0016\u0014\b\u0005C\u0005\u0002(R\u0002\r\u0011\"\u0003\u0002*\u0006a!o]2Ee&4XM]+sSV\u0011\u00111\u0016\t\u0005'9\u000bi\u000b\u0005\u0003\u00020\u0006UVBAAY\u0015\r\t\u0019LJ\u0001\u0004]\u0016$\u0018\u0002BA\\\u0003c\u00131!\u0016*J\u0011%\tY\f\u000ea\u0001\n\u0013\ti,\u0001\tsg\u000e$%/\u001b<feV\u0013\u0018n\u0018\u0013fcR!\u0011\u0011IA`\u0011)\tI%!/\u0002\u0002\u0003\u0007\u00111\u0016\u0005\t\u0003\u0007$\u0004\u0015)\u0003\u0002,\u0006i!o]2Ee&4XM]+sS\u0002B\u0011\"a25\u0001\u0004%I!!3\u0002\u0015M,7o]5p]2{w-\u0006\u0002\u0002LB)\u0011QZAo!:!\u0011qZAm\u001d\u0011\t\t.a6\u000e\u0005\u0005M'bAAk\u0019\u00051AH]8pizJ\u0011!F\u0005\u0004\u00037$\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003?\f\tO\u0001\u0006J]\u0012,\u00070\u001a3TKFT1!a7\u0015\u0011%\t)\u000f\u000ea\u0001\n\u0013\t9/\u0001\btKN\u001c\u0018n\u001c8M_\u001e|F%Z9\u0015\t\u0005\u0005\u0013\u0011\u001e\u0005\u000b\u0003\u0013\n\u0019/!AA\u0002\u0005-\u0007\u0002CAwi\u0001\u0006K!a3\u0002\u0017M,7o]5p]2{w\r\t\u0005\n\u0003c$$\u0019!C\u0005\u0003g\fqb]3tg&|gnU1wK2{7m[\u000b\u0003\u0003k\u00042aIA|\u0013\r\tI\u0010\n\u0002\u0007\u001f\nTWm\u0019;\t\u0011\u0005uH\u0007)A\u0005\u0003k\f\u0001c]3tg&|gnU1wK2{7m\u001b\u0011\t\u0013\t\u0005AG1A\u0005\n\t\r\u0011aA1qaV\u0011\u0011\u0011\u0003\u0005\t\u0005\u000f!\u0004\u0015!\u0003\u0002\u0012\u0005!\u0011\r\u001d9!\u0011\u001d\u0011Y\u0001\u000eC!\u0005\u001b\t\u0001\u0002\\8h\u0019&tWm\u001d\u000b\u0003\u0003\u0017DqA!\u00055\t\u0003\u0012\u0019\"\u0001\tsK\u000e|g/\u001a:z\u001b\u0016$\u0018\rZ1uCV\u0011!Q\u0003\t\u0005\u0005/\u0011iC\u0004\u0003\u0003\u001a\t%b\u0002\u0002B\u000e\u0005OqAA!\b\u0003&9!!q\u0004B\u0012\u001d\u0011\t\tN!\t\n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u001d\u0007\u0013\r\u0011Y\u0003O\u0001\b'\u0016\u001c8/[8o\u0013\u0011\u0011yC!\r\u0003!I+7m\u001c<feflU\r^1eCR\f'b\u0001B\u0016q!9!Q\u0007\u001b\u0005B\u0005e\u0012!B:uCR,\u0007b\u0002B\u001di\u0011\u0005#1H\u0001\fgR|\u0007oU3tg&|g\u000e\u0006\u0002\u0002B!9!q\b\u001b\u0005\u0002\t\u0005\u0013AC:uCR,W.\u001a8ugV\u0011!1\t\t\u0007\u0003\u001b\fiN!\u0012\u0011\t\t\u001d#QJ\u0007\u0003\u0005\u0013R1Aa\u0013^\u0003\u0019!'/\u001b<fe&!!q\nB%\u0005%\u0019F/\u0019;f[\u0016tG\u000fC\u0004\u0003TQ\"\tA!\u0016\u0002\u0019\u001d,Go\u0015;bi\u0016lWM\u001c;\u0015\t\t]#\u0011\f\t\u0005'9\u0013)\u0005C\u0004\u0003\\\tE\u0003\u0019A$\u0002\rM$X\u000e^%e\u0011\u001d\u0011y\u0006\u000eC\u0001\u0005C\n\u0011\"\u001b8uKJ\u0014X\u000f\u001d;\u0015\u0005\t\r\u0004C\u0002B3\u0005O\n\t%\u0004\u0002\u0002^%!!\u0011NA/\u0005\u00191U\u000f^;sK\"9!Q\u000e\u001b\u0005\u0002\t=\u0014\u0001E3yK\u000e,H/Z*uCR,W.\u001a8u)\u0011\u0011)E!\u001d\t\u0011\tM$1\u000ea\u0001\u0005k\nqaY8oi\u0016tG\u000fE\u0002\u001a\u0005oJ1A!\u001f\u0007\u00059)\u00050Z2vi\u0016\u0014V-];fgRDqA! 5\t\u0003\u0011y(A\bdC:\u001cW\r\\*uCR,W.\u001a8u)\u0011\t\tE!!\t\u000f\t\r%1\u0010a\u0001\u000f\u0006Y1\u000f^1uK6,g\u000e^%e\u0011\u001d\u00119\t\u000eC\u0001\u0005\u0013\u000baA];o\u0015>\u0014G\u0003BA@\u0005\u0017C\u0001B!$\u0003\u0006\u0002\u0007!qR\u0001\u0004U>\u0014\u0007#B\n\u0003\u0012\nU\u0015b\u0001BJ)\t)\u0011I\u001d:bsB\u00191Ca&\n\u0007\teEC\u0001\u0003CsR,\u0007b\u0002BOi\u0011\u0005!qT\u0001\ngV\u0014W.\u001b;K_\n$B!a \u0003\"\"A!Q\u0012BN\u0001\u0004\u0011y\tC\u0004\u0003&R\"\tAa*\u0002\u000f\u0005$GMR5mKR1\u0011\u0011\tBU\u0005sC\u0001Ba+\u0003$\u0002\u0007!QV\u0001\u000bM&dWm\u0015;sK\u0006l\u0007\u0003\u0002BX\u0005kk!A!-\u000b\u0007\tMf%\u0001\u0002j_&!!q\u0017BY\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000f\tm&1\u0015a\u0001!\u0006Aa-\u001b7f\u001d\u0006lW\rC\u0004\u0003@R\"\tA!1\u0002\r\u0005$GMS1s)\u0019\t\tEa1\u0003H\"A!Q\u0019B_\u0001\u0004\u0011i+A\u0005kCJ\u001cFO]3b[\"9!\u0011\u001aB_\u0001\u0004\u0001\u0016a\u00026be:\u000bW.\u001a\u0005\b\u0005K#D\u0011\u0001Bg)\u0011\t\tEa4\t\u0011\tE'1\u001aa\u0001\u0003[\u000b1!\u001e:j\u0011\u001d\u0011y\f\u000eC\u0001\u0005+$B!!\u0011\u0003X\"A!\u0011\u001bBj\u0001\u0004\ti\u000bC\u0004\u0003\\R\"\tA!8\u0002\u0013)|'m\u0015;biV\u001cH\u0003\u0002Bp\u0005K\u00042a\u0005Bq\u0013\r\u0011\u0019\u000f\u0006\u0002\u0004\u0003:L\bb\u0002$\u0003Z\u0002\u0007\u0011q\u0010\u0005\b\u0005S$D\u0011\u0001Bv\u0003%\u0019\u0017M\\2fY*{'\r\u0006\u0003\u0002B\t5\bb\u0002$\u0003h\u0002\u0007\u0011q\u0010\u0005\b\u0005c$D\u0011\u0002Bz\u0003)!(/\u00198tSRLwN\u001c\u000b\u0005\u0003\u0003\u0012)\u0010C\u0004\u0003x\n=\b\u0019A2\u0002\u00119,wo\u0015;bi\u0016DqAa?5\t\u0013\u0011Y$\u0001\u0007f]N,(/Z!di&4X\rC\u0004\u0003\u0000R\"IAa\u000f\u0002\u001b\u0015t7/\u001e:f%Vtg.\u001b8h\u0011\u001d\u0019\u0019\u0001\u000eC\u0005\u0007\u000b\t\u0001\u0003]3sM>\u0014Xn\u00149fe\u0006$\u0018n\u001c8\u0015\r\u0005}4qAB\u0005\u0011!\u0011ii!\u0001A\u0002\t=\u0005\u0002CB\u0006\u0007\u0003\u0001\ra!\u0004\u0002\tMLhn\u0019\t\u0004'\r=\u0011bAB\t)\t9!i\\8mK\u0006t\u0007bBB\u000bi\u0011\u00053qC\u0001\u000bCB\u0004\u0018\nZ&o_^tG\u0003BA!\u00073Aqaa\u0007\u0004\u0014\u0001\u0007\u0001+A\u0003baBLE\rC\u0004\u0004 Q\"\te!\t\u0002\u0019M$\u0018\r^3DQ\u0006tw-\u001a3\u0015\r\u0005\u000531EB\u001b\u0011!\u0019)c!\bA\u0002\r\u001d\u0012\u0001C8mIN#\u0018\r^3\u0011\t\r%2q\u0006\b\u0004\u0001\u000e-\u0012bAB\u0017\u0003\u0006A1\u000b]1sW\u0006\u0003\b/\u0003\u0003\u00042\rM\"!B*uCR,'bAB\u0017\u0003\"A!q_B\u000f\u0001\u0004\u00199\u0003C\u0004\u0004:Q\"\tea\u000f\u0002\u0017%tgm\\\"iC:<W\r\u001a\u000b\u0005\u0003\u0003\u001ai\u0004\u0003\u0005\u0004@\r]\u0002\u0019AB!\u0003\u001d\t\u0007\u000f]%oM>\u00042\u0001QB\"\u0013\r\u0019)%\u0011\u0002\b\u0003B\u0004\u0018J\u001c4p\u0011-\u0019I\u0005NA\u0001\u0002\u0013%11J;\u0002\u001dM,\b/\u001a:%Y&4\u0018pQ8oMV\t!\u000fC\u0006\u0004PQ\n\t\u0011!C\u0005\u0007#R\u0015\u0001C:va\u0016\u0014H%\u001b3\u0016\u0003\u001dC1b!\u00165\u0003\u0003\u0005I\u0011BB,q\u0006Y1/\u001e9fe\u0012zwO\\3s+\u0005\u0001\u0006\"\u0002$1\u0001\u00049\u0005\"B<1\u0001\u0004\u0001\u0006\"\u0002>1\u0001\u0004i\u0005\"B91\u0001\u0004\u0011\bbBB2a\u0001\u00071QM\u0001\be\u0016\fX/Z:u!\rq1qM\u0005\u0004\u0007S\u0012!\u0001G\"sK\u0006$X-\u00138uKJ\f7\r^5wKJ+\u0017/^3ti\"1q\u0010\ra\u0001\u0003\u0003A\u0011\"a\u00041!\u0003\u0005\r!!\u0005\t\u0011\rE\u0004\u0007%AA\u0002i\u000b!\"\\8dW\u000ec\u0017.\u001a8u\u0011\u001d\u0019)h\u0004C\u0001\u0007o\nqA]3d_Z,'\u000fF\u00064\u0007s\u001a\u0019i!\"\u0004\b\u000e%\u0005\u0002CB>\u0007g\u0002\ra! \u0002\u00115,G/\u00193bi\u0006\u00042ADB@\u0013\r\u0019\tI\u0001\u0002\u001c\u0013:$XM]1di&4XMU3d_Z,'/_'fi\u0006$\u0017\r^1\t\rE\u001c\u0019\b1\u0001s\u0011\u001dy81\u000fa\u0001\u0003\u0003A!\"a\u0004\u0004tA\u0005\t\u0019AA\t\u0011%\u0019\tha\u001d\u0011\u0002\u0003\u0007!\f\u0003\u0005\u0004\u000e>!\tAABH\u0003I\u0001(/\u001a9be\u0016\u0014U/\u001b7eKJ\u0004&o\u001c9\u0015\u0011\rE51SBN\u0007;\u0003b!!\u001d\u0002|A\u0003\u0006\u0002CBK\u0007\u0017\u0003\raa&\u0002\t\r|gN\u001a\t\u0006#\u000ee\u0005\u000bU\u0005\u0004\u0003{*\u0006BB4\u0004\f\u0002\u0007\u0011\u000e\u0003\u0004r\u0007\u0017\u0003\rA\u001d\u0015\u0005\u0007\u0017\u001b\t\u000b\u0005\u0003\u0004$\u000eUVBABS\u0015\u0011\u00199k!+\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0005\u0007W\u001bi+\u0001\u0004d_6lwN\u001c\u0006\u0005\u0007_\u001b\t,\u0001\u0004h_><G.\u001a\u0006\u0003\u0007g\u000b1aY8n\u0013\u0011\u00199l!*\u0003#YK7/\u001b2mK\u001a{'\u000fV3ti&tw\rC\u0005\u0004<>\t\n\u0011\"\u0001\u0004>\u0006\u00012M]3bi\u0016$C-\u001a4bk2$HeN\u000b\u0003\u0007\u007fSC!!\u0005\u0004B.\u001211\u0019\t\u0005\u0007\u000b\u001cy-\u0004\u0002\u0004H*!1\u0011ZBf\u0003%)hn\u00195fG.,GMC\u0002\u0004NR\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0019\tna2\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0004V>\t\n\u0011\"\u0001\u0004X\u0006\u00012M]3bi\u0016$C-\u001a4bk2$H\u0005O\u000b\u0003\u00073T3AWBa\u0011%\u0019inDI\u0001\n\u0003\u0019i,A\tsK\u000e|g/\u001a:%I\u00164\u0017-\u001e7uIQB\u0011b!9\u0010#\u0003%\taa6\u0002#I,7m\u001c<fe\u0012\"WMZ1vYR$S\u0007")
public class InteractiveSession
extends Session
implements SessionHeartbeat,
SparkAppListener {
    public final String org$apache$livy$server$interactive$InteractiveSession$$appTag;
    public final Option<RSCClient> org$apache$livy$server$interactive$InteractiveSession$$client;
    private final Kind kind;
    private final Option<String> proxyUser;
    public final SessionStore org$apache$livy$server$interactive$InteractiveSession$$sessionStore;
    private SessionState org$apache$livy$server$interactive$InteractiveSession$$serverSideState;
    private final FiniteDuration heartbeatTimeout;
    private final Map<Object, String> operations;
    private final AtomicLong operationCounter;
    private Option<URI> org$apache$livy$server$interactive$InteractiveSession$$rscDriverUri;
    private IndexedSeq<String> org$apache$livy$server$interactive$InteractiveSession$$sessionLog;
    private final Object org$apache$livy$server$interactive$InteractiveSession$$sessionSaveLock;
    private final Option<SparkApp> org$apache$livy$server$interactive$InteractiveSession$$app;
    private Date org$apache$livy$server$interactive$SessionHeartbeat$$_lastHeartbeat;
    private Option<Deadline> org$apache$livy$server$interactive$SessionHeartbeat$$heartbeatDeadline;

    public static Option<RSCClient> recover$default$5() {
        return InteractiveSession$.MODULE$.recover$default$5();
    }

    public static Option<SparkApp> recover$default$4() {
        return InteractiveSession$.MODULE$.recover$default$4();
    }

    public static Option<RSCClient> create$default$8() {
        return InteractiveSession$.MODULE$.create$default$8();
    }

    public static Option<SparkApp> create$default$7() {
        return InteractiveSession$.MODULE$.create$default$7();
    }

    public static InteractiveSession recover(InteractiveRecoveryMetadata interactiveRecoveryMetadata, LivyConf livyConf, SessionStore sessionStore, Option<SparkApp> option, Option<RSCClient> option2) {
        return InteractiveSession$.MODULE$.recover(interactiveRecoveryMetadata, livyConf, sessionStore, option, option2);
    }

    public static InteractiveSession create(int n, String string, Option<String> option, LivyConf livyConf, CreateInteractiveRequest createInteractiveRequest, SessionStore sessionStore, Option<SparkApp> option2, Option<RSCClient> option3) {
        return InteractiveSession$.MODULE$.create(n, string, option, livyConf, createInteractiveRequest, sessionStore, option2, option3);
    }

    public static String RECOVERY_SESSION_TYPE() {
        return InteractiveSession$.MODULE$.RECOVERY_SESSION_TYPE();
    }

    @Override
    public Date org$apache$livy$server$interactive$SessionHeartbeat$$_lastHeartbeat() {
        return this.org$apache$livy$server$interactive$SessionHeartbeat$$_lastHeartbeat;
    }

    @Override
    public void org$apache$livy$server$interactive$SessionHeartbeat$$_lastHeartbeat_$eq(Date x$1) {
        this.org$apache$livy$server$interactive$SessionHeartbeat$$_lastHeartbeat = x$1;
    }

    @Override
    public Option<Deadline> org$apache$livy$server$interactive$SessionHeartbeat$$heartbeatDeadline() {
        return this.org$apache$livy$server$interactive$SessionHeartbeat$$heartbeatDeadline;
    }

    @Override
    public void org$apache$livy$server$interactive$SessionHeartbeat$$heartbeatDeadline_$eq(Option<Deadline> x$1) {
        this.org$apache$livy$server$interactive$SessionHeartbeat$$heartbeatDeadline = x$1;
    }

    @Override
    public void heartbeat() {
        SessionHeartbeat$class.heartbeat(this);
    }

    @Override
    public Date lastHeartbeat() {
        return SessionHeartbeat$class.lastHeartbeat(this);
    }

    @Override
    public boolean heartbeatExpired() {
        return SessionHeartbeat$class.heartbeatExpired(this);
    }

    public LivyConf org$apache$livy$server$interactive$InteractiveSession$$super$livyConf() {
        return super.livyConf();
    }

    public int org$apache$livy$server$interactive$InteractiveSession$$super$id() {
        return super.id();
    }

    public String org$apache$livy$server$interactive$InteractiveSession$$super$owner() {
        return super.owner();
    }

    public Kind kind() {
        return this.kind;
    }

    @Override
    public Option<String> proxyUser() {
        return this.proxyUser;
    }

    public SessionState org$apache$livy$server$interactive$InteractiveSession$$serverSideState() {
        return this.org$apache$livy$server$interactive$InteractiveSession$$serverSideState;
    }

    private void org$apache$livy$server$interactive$InteractiveSession$$serverSideState_$eq(SessionState x$1) {
        this.org$apache$livy$server$interactive$InteractiveSession$$serverSideState = x$1;
    }

    @Override
    public FiniteDuration heartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    private Map<Object, String> operations() {
        return this.operations;
    }

    private AtomicLong operationCounter() {
        return this.operationCounter;
    }

    private Option<URI> org$apache$livy$server$interactive$InteractiveSession$$rscDriverUri() {
        return this.org$apache$livy$server$interactive$InteractiveSession$$rscDriverUri;
    }

    public void org$apache$livy$server$interactive$InteractiveSession$$rscDriverUri_$eq(Option<URI> x$1) {
        this.org$apache$livy$server$interactive$InteractiveSession$$rscDriverUri = x$1;
    }

    public IndexedSeq<String> org$apache$livy$server$interactive$InteractiveSession$$sessionLog() {
        return this.org$apache$livy$server$interactive$InteractiveSession$$sessionLog;
    }

    private void org$apache$livy$server$interactive$InteractiveSession$$sessionLog_$eq(IndexedSeq<String> x$1) {
        this.org$apache$livy$server$interactive$InteractiveSession$$sessionLog = x$1;
    }

    public Object org$apache$livy$server$interactive$InteractiveSession$$sessionSaveLock() {
        return this.org$apache$livy$server$interactive$InteractiveSession$$sessionSaveLock;
    }

    public Option<SparkApp> org$apache$livy$server$interactive$InteractiveSession$$app() {
        return this.org$apache$livy$server$interactive$InteractiveSession$$app;
    }

    @Override
    public IndexedSeq<String> logLines() {
        return (IndexedSeq)this.org$apache$livy$server$interactive$InteractiveSession$$app().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final IndexedSeq<String> apply(SparkApp x$18) {
                return x$18.log();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InteractiveSession $outer;

            public final IndexedSeq<String> apply() {
                return this.$outer.org$apache$livy$server$interactive$InteractiveSession$$sessionLog();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public Session.RecoveryMetadata recoveryMetadata() {
        return new InteractiveRecoveryMetadata(super.id(), this.appId(), this.org$apache$livy$server$interactive$InteractiveSession$$appTag, this.kind(), (int)this.heartbeatTimeout().toSeconds(), super.owner(), this.proxyUser(), this.org$apache$livy$server$interactive$InteractiveSession$$rscDriverUri(), InteractiveRecoveryMetadata$.MODULE$.apply$default$9());
    }

    @Override
    public SessionState state() {
        return this.org$apache$livy$server$interactive$InteractiveSession$$serverSideState() instanceof SessionState.Running ? (SessionState)this.org$apache$livy$server$interactive$InteractiveSession$$client.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(RSCClient s) {
                return Option$.MODULE$.apply((Object)s.getReplState());
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SessionState apply(String x$19) {
                return SessionState$.MODULE$.apply(x$19);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SessionState.Busy apply() {
                return new SessionState.Busy();
            }
        }) : this.org$apache$livy$server$interactive$InteractiveSession$$serverSideState();
    }

    @Override
    public void stopSession() {
        try {
            this.org$apache$livy$server$interactive$InteractiveSession$$transition((SessionState)new SessionState.ShuttingDown());
            this.org$apache$livy$server$interactive$InteractiveSession$$sessionStore.remove(InteractiveSession$.MODULE$.RECOVERY_SESSION_TYPE(), super.id());
            this.org$apache$livy$server$interactive$InteractiveSession$$client.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(RSCClient x$20) {
                    x$20.stop(true);
                }
            });
        }
        catch (Exception exception) {
            Option<SparkApp> option = this.org$apache$livy$server$interactive$InteractiveSession$$app();
            this.warn((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to stop RSCDriver. Killing it..."})).s((Seq)Nil$.MODULE$);
                }
            });
            option.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(SparkApp x$21) {
                    x$21.kill();
                }
            });
        }
        finally {
            this.org$apache$livy$server$interactive$InteractiveSession$$transition((SessionState)new SessionState.Dead(SessionState.Dead$.MODULE$.apply$default$1()));
        }
    }

    public IndexedSeq<Statement> statements() {
        this.ensureActive();
        ReplJobResults r = (ReplJobResults)((RSCClient)this.org$apache$livy$server$interactive$InteractiveSession$$client.get()).getReplJobResults().get();
        return Predef$.MODULE$.refArrayOps((Object[])r.statements).toIndexedSeq();
    }

    public Option<Statement> getStatement(int stmtId) {
        this.ensureActive();
        ReplJobResults r = (ReplJobResults)((RSCClient)this.org$apache$livy$server$interactive$InteractiveSession$$client.get()).getReplJobResults(Predef$.MODULE$.int2Integer(stmtId), Predef$.MODULE$.int2Integer(1)).get();
        return r.statements.length < 1 ? None$.MODULE$ : Option$.MODULE$.apply((Object)r.statements[0]);
    }

    public Future<BoxedUnit> interrupt() {
        return this.stop();
    }

    public Statement executeStatement(ExecuteRequest content) {
        this.ensureRunning();
        this.recordActivity();
        Integer id = (Integer)((RSCClient)this.org$apache$livy$server$interactive$InteractiveSession$$client.get()).submitReplCode(content.code()).get();
        return ((ReplJobResults)((RSCClient)this.org$apache$livy$server$interactive$InteractiveSession$$client.get()).getReplJobResults((Integer)id, (Integer)Predef$.MODULE$.int2Integer((int)1)).get()).statements[0];
    }

    public void cancelStatement(int statementId) {
        this.ensureRunning();
        this.recordActivity();
        ((RSCClient)this.org$apache$livy$server$interactive$InteractiveSession$$client.get()).cancelReplCode(statementId);
    }

    public long runJob(byte[] job) {
        return this.performOperation(job, true);
    }

    public long submitJob(byte[] job) {
        return this.performOperation(job, false);
    }

    public void addFile(InputStream fileStream, String fileName) {
        this.addFile(this.copyResourceToHDFS(fileStream, fileName));
    }

    public void addJar(InputStream jarStream, String jarName) {
        this.addJar(this.copyResourceToHDFS(jarStream, jarName));
    }

    public void addFile(URI uri) {
        this.ensureActive();
        this.recordActivity();
        ((RSCClient)this.org$apache$livy$server$interactive$InteractiveSession$$client.get()).addFile(Session$.MODULE$.resolveURI(uri, super.livyConf())).get();
    }

    public void addJar(URI uri) {
        this.ensureActive();
        this.recordActivity();
        ((RSCClient)this.org$apache$livy$server$interactive$InteractiveSession$$client.get()).addJar(Session$.MODULE$.resolveURI(uri, super.livyConf())).get();
    }

    public Object jobStatus(long id) {
        this.ensureActive();
        String clientJobId = (String)this.operations().apply((Object)BoxesRunTime.boxToLong((long)id));
        this.recordActivity();
        BypassJobStatus status = (BypassJobStatus)((RSCClient)this.org$apache$livy$server$interactive$InteractiveSession$$client.get()).getBypassJobStatus(clientJobId).get();
        return new HttpMessages.JobStatus(id, status.state, status.result, status.error);
    }

    public void cancelJob(long id) {
        this.ensureActive();
        this.recordActivity();
        RSCClient rSCClient = (RSCClient)this.org$apache$livy$server$interactive$InteractiveSession$$client.get();
        this.operations().remove((Object)BoxesRunTime.boxToLong((long)id)).foreach((Function1)new Serializable(this, rSCClient){
            public static final long serialVersionUID = 0L;
            private final RSCClient eta$0$1$1;

            public final void apply(String x$1) {
                this.eta$0$1$1.cancel(x$1);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
    }

    public synchronized void org$apache$livy$server$interactive$InteractiveSession$$transition(SessionState newState) {
        boolean transitFromInactiveToActive;
        Class<?> clazz = this.org$apache$livy$server$interactive$InteractiveSession$$serverSideState().getClass();
        Class<?> clazz2 = newState.getClass();
        boolean areSameStates = !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
        boolean bl = transitFromInactiveToActive = !this.org$apache$livy$server$interactive$InteractiveSession$$serverSideState().isActive() && newState.isActive();
        if (!areSameStates && !transitFromInactiveToActive) {
            this.debug((Function0<Object>)new Serializable(this, newState){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ InteractiveSession $outer;
                private final SessionState newState$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " session state change from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer, this.$outer.org$apache$livy$server$interactive$InteractiveSession$$serverSideState(), this.newState$1}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.newState$1 = newState$1;
                }
            });
            this.org$apache$livy$server$interactive$InteractiveSession$$serverSideState_$eq(newState);
        }
    }

    private synchronized void ensureActive() {
        Predef$.MODULE$.require(this.org$apache$livy$server$interactive$InteractiveSession$$serverSideState().isActive(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Session isn't active.";
            }
        });
        Predef$.MODULE$.require(this.org$apache$livy$server$interactive$InteractiveSession$$client.isDefined(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Session is active but client hasn't been created.";
            }
        });
    }

    private synchronized void ensureRunning() {
        SessionState sessionState = this.org$apache$livy$server$interactive$InteractiveSession$$serverSideState();
        if (sessionState instanceof SessionState.Running) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Session is in state %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$livy$server$interactive$InteractiveSession$$serverSideState()})));
    }

    private long performOperation(byte[] job, boolean sync) {
        this.ensureActive();
        this.recordActivity();
        String future = ((RSCClient)this.org$apache$livy$server$interactive$InteractiveSession$$client.get()).bypass(ByteBuffer.wrap(job), sync);
        long opId = this.operationCounter().incrementAndGet();
        this.operations().update((Object)BoxesRunTime.boxToLong((long)opId), (Object)future);
        return opId;
    }

    @Override
    public void appIdKnown(String appId) {
        this._appId_$eq((Option<String>)Option$.MODULE$.apply((Object)appId));
        Object object = this.org$apache$livy$server$interactive$InteractiveSession$$sessionSaveLock();
        synchronized (object) {
            this.org$apache$livy$server$interactive$InteractiveSession$$sessionStore.save(InteractiveSession$.MODULE$.RECOVERY_SESSION_TYPE(), this.recoveryMetadata());
            return;
        }
    }

    @Override
    public synchronized void stateChanged(Enumeration.Value oldState, Enumeration.Value newState) {
        boolean bl;
        this.debug((Function0<Object>)new Serializable(this, oldState, newState){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InteractiveSession $outer;
            private final Enumeration.Value oldState$1;
            private final Enumeration.Value newState$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " app state changed from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer, this.oldState$1, this.newState$2}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.oldState$1 = oldState$1;
                this.newState$2 = newState$2;
            }
        });
        Enumeration.Value value = newState;
        Enumeration.Value value2 = SparkApp$State$.MODULE$.FINISHED();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = true;
        } else {
            Enumeration.Value value4 = SparkApp$State$.MODULE$.KILLED();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                bl = true;
            } else {
                Enumeration.Value value6 = SparkApp$State$.MODULE$.FAILED();
                Enumeration.Value value7 = value;
                bl = !(value6 != null ? !value6.equals(value7) : value7 != null);
            }
        }
        if (bl) {
            this.org$apache$livy$server$interactive$InteractiveSession$$transition((SessionState)new SessionState.Dead(SessionState.Dead$.MODULE$.apply$default$1()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void infoChanged(AppInfo appInfo) {
        this.appInfo_$eq(appInfo);
    }

    public InteractiveSession(int id, Option<String> appIdHint, String appTag, Option<RSCClient> client, SessionState initialState, Kind kind, int heartbeatTimeoutS, LivyConf livyConf, String owner, Option<String> proxyUser, SessionStore sessionStore, Option<SparkApp> mockApp) {
        this.org$apache$livy$server$interactive$InteractiveSession$$appTag = appTag;
        this.org$apache$livy$server$interactive$InteractiveSession$$client = client;
        this.kind = kind;
        this.proxyUser = proxyUser;
        this.org$apache$livy$server$interactive$InteractiveSession$$sessionStore = sessionStore;
        super(id, owner, livyConf);
        SessionHeartbeat$class.$init$(this);
        SparkAppListener$class.$init$(this);
        this.org$apache$livy$server$interactive$InteractiveSession$$serverSideState = initialState;
        int heartbeatTimeoutInSecond = heartbeatTimeoutS;
        this.heartbeatTimeout = Duration$.MODULE$.apply((long)heartbeatTimeoutInSecond, TimeUnit.SECONDS);
        this.operations = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.operationCounter = new AtomicLong(0L);
        this.org$apache$livy$server$interactive$InteractiveSession$$rscDriverUri = None$.MODULE$;
        this.org$apache$livy$server$interactive$InteractiveSession$$sessionLog = (IndexedSeq)package$.MODULE$.IndexedSeq().empty();
        this.org$apache$livy$server$interactive$InteractiveSession$$sessionSaveLock = new Object();
        this._appId_$eq(appIdHint);
        sessionStore.save(InteractiveSession$.MODULE$.RECOVERY_SESSION_TYPE(), this.recoveryMetadata());
        this.heartbeat();
        this.org$apache$livy$server$interactive$InteractiveSession$$app = mockApp.orElse((Function0)new $anonfun$17(this));
        if (client.isEmpty()) {
            this.org$apache$livy$server$interactive$InteractiveSession$$transition((SessionState)new SessionState.Dead(SessionState.Dead$.MODULE$.apply$default$1()));
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot recover interactive session ", " because its RSCDriver URI is unknown."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)super.id())}));
            this.info((Function0<Object>)new Serializable(this, msg){
                public static final long serialVersionUID = 0L;
                private final String msg$1;

                public final String apply() {
                    return this.msg$1;
                }
                {
                    this.msg$1 = msg$1;
                }
            });
            this.org$apache$livy$server$interactive$InteractiveSession$$sessionLog_$eq((IndexedSeq<String>)((IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{msg}))));
        } else {
            Future uriFuture = Future$.MODULE$.apply((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ InteractiveSession $outer;

                public final URI apply() {
                    return (URI)((RSCClient)this.$outer.org$apache$livy$server$interactive$InteractiveSession$$client.get()).getServerUri().get();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, (ExecutionContext)this.executionContext());
            uriFuture.onSuccess((PartialFunction)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ InteractiveSession $outer;

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final <A1 extends URI, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    this.$outer.org$apache$livy$server$interactive$InteractiveSession$$rscDriverUri_$eq((Option<URI>)Option$.MODULE$.apply(A1));
                    Object object = this.$outer.org$apache$livy$server$interactive$InteractiveSession$$sessionSaveLock();
                    synchronized (object) {
                        this.$outer.org$apache$livy$server$interactive$InteractiveSession$$sessionStore.save(InteractiveSession$.MODULE$.RECOVERY_SESSION_TYPE(), this.$outer.recoveryMetadata());
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : object
                        BoxedUnit boxedUnit = boxedUnit2;
                        return (B1)boxedUnit;
                    }
                }

                public final boolean isDefinedAt(URI x1) {
                    URI uRI = x1;
                    boolean bl = true;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, (ExecutionContext)this.executionContext());
            uriFuture.onFailure((PartialFunction)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ InteractiveSession $outer;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    this.$outer.warn((Function0<Object>)new Serializable(this, A1){
                        public static final long serialVersionUID = 0L;
                        private final Throwable x1$1;

                        public final Tuple2<String, Throwable> apply() {
                            return new Tuple2((Object)"Fail to get rsc uri", (Object)this.x1$1);
                        }
                        {
                            this.x1$1 = x1$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return (B1)boxedUnit;
                }

                public final boolean isDefinedAt(Throwable x2) {
                    Throwable throwable = x2;
                    boolean bl = true;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, (ExecutionContext)this.executionContext());
            ((RSCClient)client.get()).submit((Job)new PingJob()).addListener((JobHandle.Listener)new JobHandle.Listener<Void>(this){
                private final /* synthetic */ InteractiveSession $outer;

                public void onJobQueued(JobHandle<Void> job) {
                }

                public void onJobStarted(JobHandle<Void> job) {
                }

                public void onJobCancelled(JobHandle<Void> job) {
                    this.errorOut();
                }

                public void onJobFailed(JobHandle<Void> job, Throwable cause) {
                    this.errorOut();
                }

                public void onJobSucceeded(JobHandle<Void> job, Void result) {
                    this.$outer.org$apache$livy$server$interactive$InteractiveSession$$transition((SessionState)new SessionState.Running());
                    this.$outer.info((Function0<Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anon$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Interactive session ", " created [appid: ", ", owner: ", ", proxyUser:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$livy$server$interactive$InteractiveSession$$anon$$$outer().org$apache$livy$server$interactive$InteractiveSession$$super$id()), this.$outer.org$apache$livy$server$interactive$InteractiveSession$$anon$$$outer().appId().orNull(Predef$.MODULE$.conforms()), this.$outer.org$apache$livy$server$interactive$InteractiveSession$$anon$$$outer().org$apache$livy$server$interactive$InteractiveSession$$super$owner()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ", state: ", ", kind: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$livy$server$interactive$InteractiveSession$$anon$$$outer().proxyUser(), this.$outer.org$apache$livy$server$interactive$InteractiveSession$$anon$$$outer().state().toString(), this.$outer.org$apache$livy$server$interactive$InteractiveSession$$anon$$$outer().kind().toString()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"info: ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$livy$server$interactive$InteractiveSession$$anon$$$outer().appInfo().asJavaMap()}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                private void errorOut() {
                    SessionState sessionState = this.$outer.org$apache$livy$server$interactive$InteractiveSession$$serverSideState();
                    SessionState.ShuttingDown shuttingDown = new SessionState.ShuttingDown();
                    if (sessionState == null ? shuttingDown != null : !sessionState.equals(shuttingDown)) {
                        this.$outer.org$apache$livy$server$interactive$InteractiveSession$$transition((SessionState)new SessionState.Error(SessionState.Error$.MODULE$.apply$default$1()));
                        this.$outer.stop();
                        this.$outer.org$apache$livy$server$interactive$InteractiveSession$$app().foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1 $outer;

                            public final void apply(SparkApp a) {
                                this.$outer.org$apache$livy$server$interactive$InteractiveSession$$anon$$$outer().info((Function0<Object>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anon$1$$anonfun$errorOut$1 $outer;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to ping RSC driver for session ", ". Killing application."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$livy$server$interactive$InteractiveSession$$anon$$anonfun$$$outer().org$apache$livy$server$interactive$InteractiveSession$$anon$$$outer().org$apache$livy$server$interactive$InteractiveSession$$super$id())}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                                a.kill();
                            }

                            public /* synthetic */ $anon$1 org$apache$livy$server$interactive$InteractiveSession$$anon$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                }

                public /* synthetic */ InteractiveSession org$apache$livy$server$interactive$InteractiveSession$$anon$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
    }
}

