/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.repl.completer;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.cli.core.repl.completer.DynamicCompleter;
import org.apache.ignite3.internal.cli.util.ArrayUtils;

public class StringDynamicCompleter
implements DynamicCompleter {
    private final Set<String> values;

    public StringDynamicCompleter(Set<String> values) {
        this.values = values;
    }

    @Override
    public List<String> complete(String[] words) {
        if (words[words.length - 1].isBlank()) {
            return new ArrayList<String>(this.values);
        }
        String lastWord = ArrayUtils.findLastNotEmptyWord(words);
        return this.values.stream().filter(it -> it.startsWith(lastWord)).collect(Collectors.toList());
    }
}

