/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.rel.metadata.NullSentinel;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ImmutableNullableSet<E>
extends AbstractSet<E> {
    private static final Set SINGLETON_NULL = new ImmutableNullableSet((ImmutableSet<Object>)ImmutableSet.of((Object)((Object)NullSentinel.INSTANCE)));
    private static final Set<Integer> SINGLETON = Collections.singleton(0);
    private final ImmutableSet<Object> elements;

    private ImmutableNullableSet(ImmutableSet<Object> elements) {
        this.elements = Objects.requireNonNull(elements, "elements");
    }

    @Override
    public Iterator<E> iterator() {
        return Util.transform(this.elements.iterator(), e -> e == NullSentinel.INSTANCE ? Nullness.castNonNull(null) : e);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.elements.contains(o == null ? NullSentinel.INSTANCE : o);
    }

    @Override
    public boolean remove(@Nullable Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public static <E> Set<E> copyOf(Iterable<? extends E> elements) {
        ImmutableSet set;
        if (elements instanceof ImmutableNullableSet || elements instanceof ImmutableSet || elements == Collections.emptySet() || elements == Collections.emptySortedSet() || elements == SINGLETON_NULL || elements.getClass() == SINGLETON.getClass()) {
            return (Set)elements;
        }
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            switch (collection.size()) {
                case 0: {
                    return ImmutableSet.of();
                }
                case 1: {
                    Object element = Iterables.getOnlyElement((Iterable)collection);
                    return element == null ? SINGLETON_NULL : ImmutableSet.of((Object)element);
                }
            }
            set = ImmutableSet.copyOf((Collection)Collections2.transform((Collection)collection, e -> e == null ? NullSentinel.INSTANCE : e));
        } else {
            set = ImmutableSet.copyOf(Util.transform(elements, e -> e == null ? NullSentinel.INSTANCE : e));
        }
        if (set.contains((Object)NullSentinel.INSTANCE)) {
            return new ImmutableNullableSet<E>((ImmutableSet<Object>)set);
        }
        return set;
    }

    public static <E> Set<E> copyOf(E[] elements) {
        return ImmutableNullableSet.copyOf(elements, true);
    }

    private static <E> Set<E> copyOf(E[] elements, boolean needCopy) {
        if (!ImmutableNullableSet.containsNull(elements)) {
            return ImmutableSet.copyOf((Object[])elements);
        }
        @Nullable Object[] objects = needCopy ? Arrays.copyOf(elements, elements.length, Object[].class) : elements;
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] != null) continue;
            objects[i] = NullSentinel.INSTANCE;
        }
        @NonNull Object[] nonNullObjects = objects;
        return new ImmutableNullableSet<E>((ImmutableSet<Object>)ImmutableSet.copyOf((Object[])nonNullObjects));
    }

    private static <E> boolean containsNull(E[] elements) {
        for (E element : elements) {
            if (element != null) continue;
            return true;
        }
        return false;
    }

    public static <E> Set<E> of(E e1) {
        return e1 == null ? SINGLETON_NULL : ImmutableSet.of(e1);
    }

    public static <E> Set<E> of(E e1, E e2) {
        return ImmutableNullableSet.copyOf(new Object[]{e1, e2}, false);
    }

    public static <E> Set<E> of(E e1, E e2, E e3) {
        return ImmutableNullableSet.copyOf(new Object[]{e1, e2, e3}, false);
    }

    public static <E> Set<E> of(E e1, E e2, E e3, E e4) {
        return ImmutableNullableSet.copyOf(new Object[]{e1, e2, e3, e4}, false);
    }

    public static <E> Set<E> of(E e1, E e2, E e3, E e4, E e5, E ... others) {
        Object[] elements = new Object[5 + others.length];
        elements[0] = e1;
        elements[1] = e2;
        elements[2] = e3;
        elements[3] = e4;
        elements[4] = e5;
        System.arraycopy(others, 0, elements, 5, others.length);
        return ImmutableNullableSet.copyOf(elements, false);
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public static final class Builder<E> {
        private final List<E> contents = new ArrayList();

        public Builder<E> add(E element) {
            this.contents.add(element);
            return this;
        }

        public Builder<E> addAll(Iterable<? extends E> elements) {
            Iterables.addAll(this.contents, elements);
            return this;
        }

        public Builder<E> add(E ... elements) {
            for (E element : elements) {
                this.add(element);
            }
            return this;
        }

        public Builder<E> addAll(Iterator<? extends E> elements) {
            Iterators.addAll(this.contents, elements);
            return this;
        }

        public Set<E> build() {
            return ImmutableNullableSet.copyOf(this.contents);
        }
    }
}

