/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.util;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.helix.AccessOption;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.PropertyPathBuilder;
import org.apache.helix.constants.InstanceConstants;
import org.apache.helix.model.ClusterTopologyConfig;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.builder.HelixConfigScopeBuilder;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.zkclient.DataUpdater;

public class InstanceUtil {
    private static final Function<List<InstanceConfig>, Boolean> ALWAYS_ALLOWED = matchingInstances -> true;
    private static final Function<List<InstanceConfig>, Boolean> ALL_MATCHES_ARE_UNKNOWN = matchingInstances -> matchingInstances.isEmpty() || matchingInstances.stream().allMatch(instance -> instance.getInstanceOperation().getOperation().equals((Object)InstanceConstants.InstanceOperation.UNKNOWN));
    private static final Function<List<InstanceConfig>, Boolean> ALL_MATCHES_ARE_UNKNOWN_OR_EVACUATE = matchingInstances -> matchingInstances.isEmpty() || matchingInstances.stream().allMatch(instance -> instance.getInstanceOperation().getOperation().equals((Object)InstanceConstants.InstanceOperation.UNKNOWN) || instance.getInstanceOperation().getOperation().equals((Object)InstanceConstants.InstanceOperation.EVACUATE));
    private static final Function<List<InstanceConfig>, Boolean> ANY_MATCH_ENABLE_OR_DISABLE = matchingInstances -> !matchingInstances.isEmpty() && matchingInstances.stream().anyMatch(instance -> instance.getInstanceOperation().getOperation().equals((Object)InstanceConstants.InstanceOperation.ENABLE) || instance.getInstanceOperation().getOperation().equals((Object)InstanceConstants.InstanceOperation.DISABLE));
    private static final ImmutableMap<InstanceConstants.InstanceOperation, ImmutableMap<InstanceConstants.InstanceOperation, Function<List<InstanceConfig>, Boolean>>> validInstanceOperationTransitions = ImmutableMap.of((Object)((Object)InstanceConstants.InstanceOperation.ENABLE), (Object)ImmutableMap.of((Object)((Object)InstanceConstants.InstanceOperation.ENABLE), ALWAYS_ALLOWED, (Object)((Object)InstanceConstants.InstanceOperation.DISABLE), ALWAYS_ALLOWED, (Object)((Object)InstanceConstants.InstanceOperation.EVACUATE), ALWAYS_ALLOWED, (Object)((Object)InstanceConstants.InstanceOperation.UNKNOWN), ALWAYS_ALLOWED), (Object)((Object)InstanceConstants.InstanceOperation.DISABLE), (Object)ImmutableMap.of((Object)((Object)InstanceConstants.InstanceOperation.DISABLE), ALWAYS_ALLOWED, (Object)((Object)InstanceConstants.InstanceOperation.ENABLE), ALWAYS_ALLOWED, (Object)((Object)InstanceConstants.InstanceOperation.EVACUATE), ALWAYS_ALLOWED, (Object)((Object)InstanceConstants.InstanceOperation.UNKNOWN), ALWAYS_ALLOWED), (Object)((Object)InstanceConstants.InstanceOperation.SWAP_IN), (Object)ImmutableMap.of((Object)((Object)InstanceConstants.InstanceOperation.SWAP_IN), ALWAYS_ALLOWED, (Object)((Object)InstanceConstants.InstanceOperation.UNKNOWN), ALWAYS_ALLOWED), (Object)((Object)InstanceConstants.InstanceOperation.EVACUATE), (Object)ImmutableMap.of((Object)((Object)InstanceConstants.InstanceOperation.EVACUATE), ALWAYS_ALLOWED, (Object)((Object)InstanceConstants.InstanceOperation.ENABLE), ALL_MATCHES_ARE_UNKNOWN, (Object)((Object)InstanceConstants.InstanceOperation.DISABLE), ALL_MATCHES_ARE_UNKNOWN, (Object)((Object)InstanceConstants.InstanceOperation.UNKNOWN), ALWAYS_ALLOWED), (Object)((Object)InstanceConstants.InstanceOperation.UNKNOWN), (Object)ImmutableMap.of((Object)((Object)InstanceConstants.InstanceOperation.UNKNOWN), ALWAYS_ALLOWED, (Object)((Object)InstanceConstants.InstanceOperation.ENABLE), ALL_MATCHES_ARE_UNKNOWN_OR_EVACUATE, (Object)((Object)InstanceConstants.InstanceOperation.DISABLE), ALL_MATCHES_ARE_UNKNOWN_OR_EVACUATE, (Object)((Object)InstanceConstants.InstanceOperation.SWAP_IN), ANY_MATCH_ENABLE_OR_DISABLE));

    private InstanceUtil() {
    }

    public static void validateInstanceOperationTransition(ConfigAccessor configAccessor, String clusterName, InstanceConfig instanceConfig, InstanceConstants.InstanceOperation currentOperation, InstanceConstants.InstanceOperation targetOperation) {
        if (!validInstanceOperationTransitions.containsKey((Object)currentOperation) || !((ImmutableMap)validInstanceOperationTransitions.get((Object)currentOperation)).containsKey((Object)targetOperation)) {
            throw new HelixException("Invalid instance operation transition from " + currentOperation + " to " + targetOperation);
        }
        if (!((Boolean)((Function)((ImmutableMap)validInstanceOperationTransitions.get((Object)currentOperation)).get((Object)targetOperation)).apply(InstanceUtil.findInstancesWithMatchingLogicalId(configAccessor, clusterName, instanceConfig))).booleanValue()) {
            throw new HelixException("Failed validation for instance operation transition from " + currentOperation + " to " + targetOperation);
        }
    }

    public static List<InstanceConfig> findInstancesWithMatchingLogicalId(ConfigAccessor configAccessor, String clusterName, InstanceConfig instanceConfig) {
        String logicalIdKey = ClusterTopologyConfig.createFromClusterConfig(configAccessor.getClusterConfig(clusterName)).getEndNodeType();
        return configAccessor.getKeys(new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.PARTICIPANT, clusterName).build()).stream().map(instanceName -> configAccessor.getInstanceConfig(clusterName, (String)instanceName)).filter(potentialInstanceConfig -> !potentialInstanceConfig.getInstanceName().equals(instanceConfig.getInstanceName()) && potentialInstanceConfig.getLogicalId(logicalIdKey).equals(instanceConfig.getLogicalId(logicalIdKey))).collect(Collectors.toList());
    }

    public static void setInstanceOperation(ConfigAccessor configAccessor, BaseDataAccessor<ZNRecord> baseAccessor, final String clusterName, final String instanceName, final InstanceConfig.InstanceOperation instanceOperation) {
        String path = PropertyPathBuilder.instanceConfig(clusterName, instanceName);
        InstanceConfig instanceConfig = configAccessor.getInstanceConfig(clusterName, instanceName);
        if (instanceConfig == null) {
            throw new HelixException("Cluster " + clusterName + ", instance: " + instanceName + ", instance config does not exist");
        }
        InstanceUtil.validateInstanceOperationTransition(configAccessor, clusterName, instanceConfig, instanceConfig.getInstanceOperation().getOperation(), instanceOperation == null ? InstanceConstants.InstanceOperation.ENABLE : instanceOperation.getOperation());
        boolean succeeded = baseAccessor.update(path, new DataUpdater<ZNRecord>(){

            @Override
            public ZNRecord update(ZNRecord currentData) {
                if (currentData == null) {
                    throw new HelixException("Cluster: " + clusterName + ", instance: " + instanceName + ", participant config is null");
                }
                InstanceConfig config = new InstanceConfig(currentData);
                config.setInstanceOperation(instanceOperation);
                return config.getRecord();
            }
        }, AccessOption.PERSISTENT);
        if (!succeeded) {
            throw new HelixException("Failed to update instance operation. Please check if instance is disabled.");
        }
    }
}

