/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.resources.helix;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.constants.InstanceConstants;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.Error;
import org.apache.helix.model.HealthStat;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.ParticipantHistory;
import org.apache.helix.model.builder.HelixConfigScopeBuilder;
import org.apache.helix.rest.clusterMaintenanceService.HealthCheck;
import org.apache.helix.rest.clusterMaintenanceService.MaintenanceManagementService;
import org.apache.helix.rest.server.filters.ClusterAuth;
import org.apache.helix.rest.server.json.instance.InstanceInfo;
import org.apache.helix.rest.server.json.instance.StoppableCheck;
import org.apache.helix.rest.server.resources.AbstractResource;
import org.apache.helix.rest.server.resources.helix.AbstractHelixResource;
import org.apache.helix.rest.server.resources.helix.InstancesAccessor;
import org.apache.helix.util.InstanceUtil;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClusterAuth
@Path(value="/clusters/{clusterId}/instances/{instanceName}")
public class PerInstanceAccessor
extends AbstractHelixResource {
    private static final Logger LOG = LoggerFactory.getLogger(PerInstanceAccessor.class);

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    public Response getInstanceById(@PathParam(value="clusterId") String clusterId, @PathParam(value="instanceName") String instanceName, @QueryParam(value="skipZKRead") String skipZKRead, @DefaultValue(value="getInstance") @QueryParam(value="command") String command) {
        AbstractResource.Command cmd;
        try {
            cmd = AbstractResource.Command.valueOf(command);
        }
        catch (Exception e) {
            return this.badRequest("Invalid command : " + command);
        }
        switch (cmd) {
            case getInstance: {
                String instanceInfoString;
                HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
                MaintenanceManagementService service = new MaintenanceManagementService((ZKHelixDataAccessor)dataAccessor, this.getConfigAccessor(), Boolean.parseBoolean(skipZKRead), this.getNamespace());
                InstanceInfo instanceInfo = service.getInstanceHealthInfo(clusterId, instanceName, HealthCheck.STARTED_AND_HEALTH_CHECK_LIST);
                try {
                    instanceInfoString = OBJECT_MAPPER.writeValueAsString((Object)instanceInfo);
                }
                catch (JsonProcessingException e) {
                    return this.serverError((Exception)((Object)e));
                }
                return this.OK(instanceInfoString);
            }
            case validateWeight: {
                Map validationResultMap;
                HelixAdmin admin = this.getHelixAdmin();
                try {
                    validationResultMap = admin.validateInstancesForWagedRebalance(clusterId, Collections.singletonList(instanceName));
                }
                catch (HelixException e) {
                    return this.badRequest(e.getMessage());
                }
                return this.JSONRepresentation(validationResultMap);
            }
        }
        LOG.error("Unsupported command :" + command);
        return this.badRequest("Unsupported command :" + command);
    }

    @ResponseMetered(name="write")
    @Timed(name="write")
    @POST
    @Path(value="stoppable")
    @Consumes(value={"application/json"})
    public Response isInstanceStoppable(String jsonContent, @PathParam(value="clusterId") String clusterId, @PathParam(value="instanceName") String instanceName, @QueryParam(value="skipZKRead") boolean skipZKRead, @QueryParam(value="continueOnFailures") boolean continueOnFailures, @QueryParam(value="skipHealthCheckCategories") String skipHealthCheckCategories) throws IOException {
        StoppableCheck stoppableCheck;
        Set<StoppableCheck.Category> skipHealthCheckCategorySet;
        try {
            Set<StoppableCheck.Category> set = skipHealthCheckCategorySet = skipHealthCheckCategories != null ? StoppableCheck.Category.categorySetFromCommaSeperatedString(skipHealthCheckCategories) : Collections.emptySet();
            if (!MaintenanceManagementService.SKIPPABLE_HEALTH_CHECK_CATEGORIES.containsAll(skipHealthCheckCategorySet)) {
                throw new IllegalArgumentException("Some of the provided skipHealthCheckCategories are not skippable. The supported skippable categories are: " + MaintenanceManagementService.SKIPPABLE_HEALTH_CHECK_CATEGORIES);
            }
        }
        catch (Exception e) {
            return this.badRequest("Invalid skipHealthCheckCategories: " + skipHealthCheckCategories + "\n" + e.getMessage());
        }
        HelixDataAccessor dataAccessor = this.getDataAccssor(clusterId);
        MaintenanceManagementService maintenanceService = new MaintenanceManagementService((ZKHelixDataAccessor)dataAccessor, this.getConfigAccessor(), skipZKRead, continueOnFailures, skipHealthCheckCategorySet, this.getNamespace());
        try {
            JsonNode node = null;
            if (jsonContent.length() != 0) {
                node = OBJECT_MAPPER.readTree(jsonContent);
            }
            if (node == null) {
                return this.badRequest("Invalid input for content : " + jsonContent);
            }
            String customizedInput = null;
            if (node.get(InstancesAccessor.InstancesProperties.customized_values.name()) != null) {
                customizedInput = node.get(InstancesAccessor.InstancesProperties.customized_values.name()).toString();
            }
            stoppableCheck = maintenanceService.getInstanceStoppableCheck(clusterId, instanceName, customizedInput);
        }
        catch (HelixException e) {
            LOG.error("Current cluster: {}, instance: {} has issue with health checks!", new Object[]{clusterId, instanceName, e});
            return this.serverError((Exception)((Object)e));
        }
        return this.OK(OBJECT_MAPPER.writeValueAsString((Object)stoppableCheck));
    }

    @ResponseMetered(name="write")
    @Timed(name="write")
    @POST
    @Path(value="takeInstance")
    @Consumes(value={"application/json"})
    public Response takeSingleInstance(String jsonContent, @PathParam(value="clusterId") String clusterId, @PathParam(value="instanceName") String instanceName) {
        try {
            MaintenanceOpInputFields inputFields = this.readMaintenanceInputFromJson(jsonContent);
            if (inputFields == null) {
                return this.badRequest("Invalid input for content : " + jsonContent);
            }
            MaintenanceManagementService maintenanceManagementService = new MaintenanceManagementService((ZKHelixDataAccessor)this.getDataAccssor(clusterId), this.getConfigAccessor(), inputFields.skipZKRead, inputFields.nonBlockingHelixCheck, this.getNamespace());
            return this.JSONRepresentation(maintenanceManagementService.takeInstance(clusterId, instanceName, inputFields.healthChecks, inputFields.healthCheckConfig, inputFields.operations, inputFields.operationConfig, inputFields.performOperation));
        }
        catch (Exception e) {
            LOG.error("Failed to takeInstances:", (Throwable)e);
            return this.badRequest("Failed to takeInstances: " + e.getMessage());
        }
    }

    @ResponseMetered(name="write")
    @Timed(name="write")
    @POST
    @Path(value="freeInstance")
    @Consumes(value={"application/json"})
    public Response freeSingleInstance(String jsonContent, @PathParam(value="clusterId") String clusterId, @PathParam(value="instanceName") String instanceName) {
        try {
            MaintenanceOpInputFields inputFields = this.readMaintenanceInputFromJson(jsonContent);
            if (inputFields == null) {
                return this.badRequest("Invalid input for content : " + jsonContent);
            }
            if (inputFields.healthChecks.size() != 0) {
                LOG.warn("freeSingleInstance won't perform user passed health check.");
            }
            MaintenanceManagementService maintenanceManagementService = new MaintenanceManagementService((ZKHelixDataAccessor)this.getDataAccssor(clusterId), this.getConfigAccessor(), inputFields.skipZKRead, inputFields.nonBlockingHelixCheck, this.getNamespace());
            return this.JSONRepresentation(maintenanceManagementService.freeInstance(clusterId, instanceName, inputFields.healthChecks, inputFields.healthCheckConfig, inputFields.operations, inputFields.operationConfig, inputFields.performOperation));
        }
        catch (Exception e) {
            LOG.error("Failed to takeInstances:", (Throwable)e);
            return this.badRequest("Failed to takeInstances: " + e.getMessage());
        }
    }

    private MaintenanceOpInputFields readMaintenanceInputFromJson(String jsonContent) throws IOException {
        JsonNode node = null;
        if (jsonContent.length() != 0) {
            node = OBJECT_MAPPER.readTree(jsonContent);
        }
        if (node == null) {
            return null;
        }
        MaintenanceOpInputFields inputFields = new MaintenanceOpInputFields();
        String continueOnFailuresName = PerInstanceProperties.continueOnFailures.name();
        String skipZKReadName = PerInstanceProperties.skipZKRead.name();
        String performOperation = PerInstanceProperties.performOperation.name();
        inputFields.healthChecks = MaintenanceManagementService.getListFromJsonPayload(node.get(PerInstanceProperties.health_check_list.name()));
        inputFields.healthCheckConfig = MaintenanceManagementService.getMapFromJsonPayload(node.get(PerInstanceProperties.health_check_config.name()));
        if (inputFields.healthCheckConfig != null) {
            if (inputFields.healthCheckConfig.containsKey(continueOnFailuresName)) {
                inputFields.nonBlockingHelixCheck = new HashSet<String>(MaintenanceManagementService.getListFromJsonPayload(inputFields.healthCheckConfig.get(continueOnFailuresName)));
                inputFields.healthCheckConfig.remove(continueOnFailuresName);
            }
            if (inputFields.healthCheckConfig.containsKey(skipZKReadName)) {
                inputFields.skipZKRead = Boolean.parseBoolean(inputFields.healthCheckConfig.get(skipZKReadName));
                inputFields.healthCheckConfig.remove(skipZKReadName);
            }
        }
        inputFields.operations = MaintenanceManagementService.getListFromJsonPayload(node.get(PerInstanceProperties.operation_list.name()));
        inputFields.operationConfig = MaintenanceManagementService.getMapFromJsonPayload(node.get(PerInstanceProperties.operation_config.name()));
        if (inputFields.operationConfig != null && inputFields.operationConfig.containsKey(performOperation)) {
            inputFields.performOperation = Boolean.parseBoolean(inputFields.operationConfig.get(performOperation));
        }
        LOG.debug("Input fields for take/free Instance" + inputFields.toString());
        return inputFields;
    }

    @ResponseMetered(name="write")
    @Timed(name="write")
    @PUT
    public Response addInstance(@PathParam(value="clusterId") String clusterId, @PathParam(value="instanceName") String instanceName, String content) {
        ZNRecord record;
        HelixAdmin admin = this.getHelixAdmin();
        try {
            record = PerInstanceAccessor.toZNRecord(content);
        }
        catch (IOException e) {
            LOG.error("Failed to deserialize user's input " + content + ", Exception: " + e);
            return this.badRequest("Input is not a vaild ZNRecord!");
        }
        try {
            admin.addInstance(clusterId, new InstanceConfig(record));
        }
        catch (Exception ex) {
            LOG.error("Error in adding an instance: " + instanceName, (Throwable)ex);
            return this.serverError(ex);
        }
        return this.OK();
    }

    @ResponseMetered(name="write")
    @Timed(name="write")
    @POST
    public Response updateInstance(@PathParam(value="clusterId") String clusterId, @PathParam(value="instanceName") String instanceName, @QueryParam(value="command") String command, @QueryParam(value="instanceOperation") InstanceConstants.InstanceOperation instanceOperation, @QueryParam(value="instanceOperationSource") InstanceConstants.InstanceOperationSource instanceOperationSource, @QueryParam(value="reason") String reason, @Deprecated @QueryParam(value="instanceDisabledType") String disabledType, @Deprecated @QueryParam(value="instanceDisabledReason") String disabledReason, @QueryParam(value="force") boolean force, String content) {
        AbstractResource.Command cmd;
        try {
            cmd = AbstractResource.Command.valueOf(command);
        }
        catch (Exception e) {
            return this.badRequest("Invalid command : " + command);
        }
        HelixAdmin admin = this.getHelixAdmin();
        try {
            JsonNode node = null;
            if (content.length() != 0) {
                node = OBJECT_MAPPER.readTree(content);
            }
            switch (cmd) {
                case enable: {
                    admin.enableInstance(clusterId, instanceName, true);
                    break;
                }
                case disable: {
                    InstanceConstants.InstanceDisabledType disabledTypeEnum = null;
                    if (disabledType != null) {
                        try {
                            disabledTypeEnum = InstanceConstants.InstanceDisabledType.valueOf((String)disabledType);
                        }
                        catch (IllegalArgumentException ex) {
                            return this.badRequest("Invalid instanceDisabledType!");
                        }
                    }
                    admin.enableInstance(clusterId, instanceName, false, disabledTypeEnum, disabledReason);
                    break;
                }
                case reset: 
                case resetPartitions: {
                    if (!this.validInstance(node, instanceName)) {
                        return this.badRequest("Instance names are not match!");
                    }
                    admin.resetPartition(clusterId, instanceName, node.get(PerInstanceProperties.resource.name()).textValue(), (List)OBJECT_MAPPER.readValue(node.get(PerInstanceProperties.partitions.name()).toString(), (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, String.class)));
                    break;
                }
                case setPartitionsToError: {
                    if (!this.validInstance(node, instanceName)) {
                        return this.badRequest("Instance names are not a match!");
                    }
                    admin.setPartitionsToError(clusterId, instanceName, node.get(PerInstanceProperties.resource.name()).textValue(), (List)OBJECT_MAPPER.readValue(node.get(PerInstanceProperties.partitions.name()).toString(), (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, String.class)));
                    break;
                }
                case setInstanceOperation: {
                    InstanceUtil.setInstanceOperation((ConfigAccessor)new ConfigAccessor(this.getRealmAwareZkClient()), (BaseDataAccessor)new ZkBaseDataAccessor(this.getRealmAwareZkClient()), (String)clusterId, (String)instanceName, (InstanceConfig.InstanceOperation)new InstanceConfig.InstanceOperation.Builder().setOperation(instanceOperation).setReason(reason).setSource(force ? InstanceConstants.InstanceOperationSource.ADMIN : instanceOperationSource).build());
                    break;
                }
                case canCompleteSwap: {
                    return this.OK(OBJECT_MAPPER.writeValueAsString((Object)ImmutableMap.of((Object)"successful", (Object)admin.canCompleteSwap(clusterId, instanceName))));
                }
                case completeSwapIfPossible: {
                    return this.OK(OBJECT_MAPPER.writeValueAsString((Object)ImmutableMap.of((Object)"successful", (Object)admin.completeSwapIfPossible(clusterId, instanceName, force))));
                }
                case addInstanceTag: {
                    if (!this.validInstance(node, instanceName)) {
                        return this.badRequest("Instance names are not match!");
                    }
                    for (String tag : (List)OBJECT_MAPPER.readValue(node.get(PerInstanceProperties.instanceTags.name()).toString(), (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, String.class))) {
                        admin.addInstanceTag(clusterId, instanceName, tag);
                    }
                    break;
                }
                case removeInstanceTag: {
                    if (!this.validInstance(node, instanceName)) {
                        return this.badRequest("Instance names are not match!");
                    }
                    for (String tag : (List)OBJECT_MAPPER.readValue(node.get(PerInstanceProperties.instanceTags.name()).toString(), (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, String.class))) {
                        admin.removeInstanceTag(clusterId, instanceName, tag);
                    }
                    break;
                }
                case enablePartitions: {
                    admin.enablePartition(true, clusterId, instanceName, node.get(PerInstanceProperties.resource.name()).textValue(), (List)OBJECT_MAPPER.readValue(node.get(PerInstanceProperties.partitions.name()).toString(), (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, String.class)));
                    break;
                }
                case disablePartitions: {
                    admin.enablePartition(false, clusterId, instanceName, node.get(PerInstanceProperties.resource.name()).textValue(), (List)OBJECT_MAPPER.readValue(node.get(PerInstanceProperties.partitions.name()).toString(), (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, String.class)));
                    break;
                }
                case isEvacuateFinished: {
                    boolean evacuateFinished;
                    try {
                        evacuateFinished = admin.isEvacuateFinished(clusterId, instanceName);
                    }
                    catch (HelixException e) {
                        LOG.error(String.format("Encountered error when checking if evacuation finished for cluster: {}, instance: {}", clusterId, instanceName), (Throwable)e);
                        return this.serverError((Exception)((Object)e));
                    }
                    return this.OK(OBJECT_MAPPER.writeValueAsString((Object)ImmutableMap.of((Object)"successful", (Object)evacuateFinished)));
                }
                case forceKillInstance: {
                    boolean instanceForceKilled = admin.forceKillInstance(clusterId, instanceName, reason, instanceOperationSource);
                    if (!instanceForceKilled) {
                        return this.serverError("Failed to forcefully kill instance: " + instanceName + ". Possible that instance was already stopped.");
                    }
                    return this.OK(OBJECT_MAPPER.writeValueAsString((Object)ImmutableMap.of((Object)"successful", (Object)instanceForceKilled)));
                }
                default: {
                    LOG.error("Unsupported command :" + command);
                    return this.badRequest("Unsupported command :" + command);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed in updating instance : " + instanceName, (Throwable)e);
            return this.badRequest(e.getMessage());
        }
        return this.OK();
    }

    @ResponseMetered(name="write")
    @Timed(name="write")
    @DELETE
    public Response deleteInstance(@PathParam(value="clusterId") String clusterId, @PathParam(value="instanceName") String instanceName) {
        HelixAdmin admin = this.getHelixAdmin();
        try {
            InstanceConfig instanceConfig = admin.getInstanceConfig(clusterId, instanceName);
            admin.dropInstance(clusterId, instanceConfig);
        }
        catch (HelixException e) {
            return this.badRequest(e.getMessage());
        }
        return this.OK();
    }

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="configs")
    public Response getInstanceConfig(@PathParam(value="clusterId") String clusterId, @PathParam(value="instanceName") String instanceName) throws IOException {
        HelixDataAccessor accessor = this.getDataAccssor(clusterId);
        InstanceConfig instanceConfig = (InstanceConfig)accessor.getProperty(accessor.keyBuilder().instanceConfig(instanceName));
        if (instanceConfig != null) {
            return this.JSONRepresentation(instanceConfig.getRecord());
        }
        return this.notFound();
    }

    @ResponseMetered(name="write")
    @Timed(name="write")
    @POST
    @Path(value="configs")
    public Response updateInstanceConfig(@PathParam(value="clusterId") String clusterId, @PathParam(value="instanceName") String instanceName, @QueryParam(value="command") String commandStr, String content) {
        ZNRecord record;
        AbstractResource.Command command;
        if (commandStr == null || commandStr.isEmpty()) {
            command = AbstractResource.Command.update;
        } else {
            try {
                command = this.getCommand(commandStr);
            }
            catch (HelixException ex) {
                return this.badRequest(ex.getMessage());
            }
        }
        try {
            record = PerInstanceAccessor.toZNRecord(content);
        }
        catch (IOException e) {
            LOG.error("Failed to deserialize user's input " + content + ", Exception: " + e);
            return this.badRequest("Input is not a vaild ZNRecord!");
        }
        InstanceConfig instanceConfig = new InstanceConfig(record);
        ConfigAccessor configAccessor = this.getConfigAccessor();
        try {
            switch (command) {
                case update: {
                    this.validateDeltaTopologySettingInInstanceConfig(clusterId, instanceName, configAccessor, instanceConfig, command);
                    configAccessor.updateInstanceConfig(clusterId, instanceName, instanceConfig);
                    break;
                }
                case delete: {
                    this.validateDeltaTopologySettingInInstanceConfig(clusterId, instanceName, configAccessor, instanceConfig, command);
                    HelixConfigScope instanceScope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.PARTICIPANT).forCluster(clusterId).forParticipant(instanceName).build();
                    configAccessor.remove(instanceScope, record);
                    break;
                }
                default: {
                    return this.badRequest(String.format("Unsupported command: %s", new Object[]{command}));
                }
            }
        }
        catch (IllegalArgumentException ex) {
            LOG.error(String.format("Invalid topology setting for Instance : {}. Fail the config update", instanceName), (Throwable)ex);
            return this.serverError(ex);
        }
        catch (HelixException ex) {
            return this.notFound(ex.getMessage());
        }
        catch (Exception ex) {
            LOG.error(String.format("Error in update instance config for instance: %s", instanceName), (Throwable)ex);
            return this.serverError(ex);
        }
        return this.OK();
    }

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="resources")
    public Response getResourcesOnInstance(@PathParam(value="clusterId") String clusterId, @PathParam(value="instanceName") String instanceName) throws IOException {
        HelixDataAccessor accessor = this.getDataAccssor(clusterId);
        ObjectNode root = JsonNodeFactory.instance.objectNode();
        root.put(AbstractResource.Properties.id.name(), instanceName);
        ArrayNode resourcesNode = root.putArray(PerInstanceProperties.resources.name());
        List liveInstances = accessor.getChildNames(accessor.keyBuilder().liveInstances());
        if (!liveInstances.contains(instanceName)) {
            return null;
        }
        LiveInstance liveInstance = (LiveInstance)accessor.getProperty(accessor.keyBuilder().liveInstance(instanceName));
        String currentSessionId = liveInstance.getEphemeralOwner();
        List resources = accessor.getChildNames(accessor.keyBuilder().currentStates(instanceName, currentSessionId));
        resources.addAll(accessor.getChildNames(accessor.keyBuilder().taskCurrentStates(instanceName, currentSessionId)));
        if (resources.size() > 0) {
            resourcesNode.addAll((ArrayNode)OBJECT_MAPPER.valueToTree((Object)resources));
        }
        return this.JSONRepresentation(root);
    }

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="resources/{resourceName}")
    public Response getResourceOnInstance(@PathParam(value="clusterId") String clusterId, @PathParam(value="instanceName") String instanceName, @PathParam(value="resourceName") String resourceName) throws IOException {
        HelixDataAccessor accessor = this.getDataAccssor(clusterId);
        List liveInstances = accessor.getChildNames(accessor.keyBuilder().liveInstances());
        if (!liveInstances.contains(instanceName)) {
            return this.notFound();
        }
        LiveInstance liveInstance = (LiveInstance)accessor.getProperty(accessor.keyBuilder().liveInstance(instanceName));
        String currentSessionId = liveInstance.getEphemeralOwner();
        CurrentState resourceCurrentState = (CurrentState)accessor.getProperty(accessor.keyBuilder().currentState(instanceName, currentSessionId, resourceName));
        if (resourceCurrentState == null) {
            resourceCurrentState = (CurrentState)accessor.getProperty(accessor.keyBuilder().taskCurrentState(instanceName, currentSessionId, resourceName));
        }
        if (resourceCurrentState != null) {
            return this.JSONRepresentation(resourceCurrentState.getRecord());
        }
        return this.notFound();
    }

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="errors")
    public Response getErrorsOnInstance(@PathParam(value="clusterId") String clusterId, @PathParam(value="instanceName") String instanceName) throws IOException {
        HelixDataAccessor accessor = this.getDataAccssor(clusterId);
        ObjectNode root = JsonNodeFactory.instance.objectNode();
        root.put(AbstractResource.Properties.id.name(), instanceName);
        ObjectNode errorsNode = JsonNodeFactory.instance.objectNode();
        List sessionIds = accessor.getChildNames(accessor.keyBuilder().errors(instanceName));
        if (sessionIds == null || sessionIds.size() == 0) {
            return this.notFound();
        }
        for (String sessionId : sessionIds) {
            List resources = accessor.getChildNames(accessor.keyBuilder().errors(instanceName, sessionId));
            if (resources == null) continue;
            ObjectNode resourcesNode = JsonNodeFactory.instance.objectNode();
            for (String resourceName : resources) {
                List partitions = accessor.getChildNames(accessor.keyBuilder().errors(instanceName, sessionId, resourceName));
                if (partitions == null) continue;
                ArrayNode partitionsNode = resourcesNode.putArray(resourceName);
                partitionsNode.addAll((ArrayNode)OBJECT_MAPPER.valueToTree((Object)partitions));
            }
            errorsNode.put(sessionId, (JsonNode)resourcesNode);
        }
        root.put(PerInstanceProperties.errors.name(), (JsonNode)errorsNode);
        return this.JSONRepresentation(root);
    }

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="errors/{sessionId}/{resourceName}/{partitionName}")
    public Response getErrorsOnInstance(@PathParam(value="clusterId") String clusterId, @PathParam(value="instanceName") String instanceName, @PathParam(value="sessionId") String sessionId, @PathParam(value="resourceName") String resourceName, @PathParam(value="partitionName") String partitionName) throws IOException {
        HelixDataAccessor accessor = this.getDataAccssor(clusterId);
        Error error = (Error)accessor.getProperty(accessor.keyBuilder().stateTransitionError(instanceName, sessionId, resourceName, partitionName));
        if (error != null) {
            return this.JSONRepresentation(error.getRecord());
        }
        return this.notFound();
    }

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="history")
    public Response getHistoryOnInstance(@PathParam(value="clusterId") String clusterId, @PathParam(value="instanceName") String instanceName) throws IOException {
        HelixDataAccessor accessor = this.getDataAccssor(clusterId);
        ParticipantHistory history = (ParticipantHistory)accessor.getProperty(accessor.keyBuilder().participantHistory(instanceName));
        if (history != null) {
            return this.JSONRepresentation(history.getRecord());
        }
        return this.notFound();
    }

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="messages")
    public Response getMessagesOnInstance(@PathParam(value="clusterId") String clusterId, @PathParam(value="instanceName") String instanceName, @QueryParam(value="stateModelDef") String stateModelDef) {
        HelixDataAccessor accessor = this.getDataAccssor(clusterId);
        ObjectNode root = JsonNodeFactory.instance.objectNode();
        root.put(AbstractResource.Properties.id.name(), instanceName);
        ArrayNode newMessages = root.putArray(PerInstanceProperties.new_messages.name());
        ArrayNode readMessages = root.putArray(PerInstanceProperties.read_messages.name());
        List messageNames = accessor.getChildNames(accessor.keyBuilder().messages(instanceName));
        if (messageNames == null || messageNames.size() == 0) {
            LOG.warn("Unable to get any messages on instance: " + instanceName);
            return this.notFound();
        }
        for (String messageName : messageNames) {
            Message message = (Message)accessor.getProperty(accessor.keyBuilder().message(instanceName, messageName));
            if (message == null) {
                LOG.warn("Message is deleted given message name: ", (Object)messageName);
                continue;
            }
            if (StringUtil.isNotBlank((String)stateModelDef) && !stateModelDef.equals(message.getStateModelDef())) continue;
            if (Message.MessageState.NEW.equals((Object)message.getMsgState())) {
                newMessages.add(messageName);
                continue;
            }
            if (!Message.MessageState.READ.equals((Object)message.getMsgState())) continue;
            readMessages.add(messageName);
        }
        root.put(PerInstanceProperties.total_message_count.name(), newMessages.size() + readMessages.size());
        root.put(PerInstanceProperties.read_message_count.name(), readMessages.size());
        return this.JSONRepresentation(root);
    }

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="messages/{messageId}")
    public Response getMessageOnInstance(@PathParam(value="clusterId") String clusterId, @PathParam(value="instanceName") String instanceName, @PathParam(value="messageId") String messageId) throws IOException {
        HelixDataAccessor accessor = this.getDataAccssor(clusterId);
        Message message = (Message)accessor.getProperty(accessor.keyBuilder().message(instanceName, messageId));
        if (message != null) {
            return this.JSONRepresentation(message.getRecord());
        }
        return this.notFound();
    }

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="healthreports")
    public Response getHealthReportsOnInstance(@PathParam(value="clusterId") String clusterId, @PathParam(value="instanceName") String instanceName) throws IOException {
        HelixDataAccessor accessor = this.getDataAccssor(clusterId);
        ObjectNode root = JsonNodeFactory.instance.objectNode();
        root.put(AbstractResource.Properties.id.name(), instanceName);
        ArrayNode healthReportsNode = root.putArray(PerInstanceProperties.healthreports.name());
        List healthReports = accessor.getChildNames(accessor.keyBuilder().healthReports(instanceName));
        if (healthReports != null && healthReports.size() > 0) {
            healthReportsNode.addAll((ArrayNode)OBJECT_MAPPER.valueToTree((Object)healthReports));
        }
        return this.JSONRepresentation(root);
    }

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="healthreports/{reportName}")
    public Response getHealthReportsOnInstance(@PathParam(value="clusterId") String clusterId, @PathParam(value="instanceName") String instanceName, @PathParam(value="reportName") String reportName) throws IOException {
        HelixDataAccessor accessor = this.getDataAccssor(clusterId);
        HealthStat healthStat = (HealthStat)accessor.getProperty(accessor.keyBuilder().healthReport(instanceName, reportName));
        if (healthStat != null) {
            return this.JSONRepresentation(healthStat);
        }
        return this.notFound();
    }

    private boolean validInstance(JsonNode node, String instanceName) {
        return instanceName.equals(node.get(AbstractResource.Properties.id.name()).textValue());
    }

    private boolean validateDeltaTopologySettingInInstanceConfig(String clusterName, String instanceName, ConfigAccessor configAccessor, InstanceConfig newInstanceConfig, AbstractResource.Command command) {
        InstanceConfig originalInstanceConfigCopy = configAccessor.getInstanceConfig(clusterName, instanceName);
        if (command == AbstractResource.Command.delete) {
            for (Map.Entry entry : newInstanceConfig.getRecord().getSimpleFields().entrySet()) {
                originalInstanceConfigCopy.getRecord().getSimpleFields().remove(entry.getKey());
            }
        } else {
            originalInstanceConfigCopy.getRecord().update(newInstanceConfig.getRecord());
        }
        return originalInstanceConfigCopy.validateTopologySettingInInstanceConfig(configAccessor.getClusterConfig(clusterName), instanceName);
    }

    private static class MaintenanceOpInputFields {
        List<String> healthChecks = null;
        Map<String, String> healthCheckConfig = null;
        List<String> operations = null;
        Map<String, String> operationConfig = null;
        Set<String> nonBlockingHelixCheck = new HashSet<String>();
        boolean skipZKRead = false;
        boolean performOperation = true;

        private MaintenanceOpInputFields() {
        }
    }

    public static enum PerInstanceProperties {
        config,
        liveInstance,
        resource,
        resources,
        partitions,
        errors,
        new_messages,
        read_messages,
        total_message_count,
        read_message_count,
        healthreports,
        instanceTags,
        health_check_list,
        health_check_config,
        operation_list,
        operation_config,
        continueOnFailures,
        skipZKRead,
        performOperation;

    }
}

