/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.helix.rest.client.CustomRestClient;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CustomRestClientImpl
implements CustomRestClient {
    private static final Logger LOG = LoggerFactory.getLogger(CustomRestClientImpl.class);
    private static final String INSTANCE_HEALTH_STATUS = "/instanceHealthStatus";
    private static final String PARTITION_HEALTH_STATUS = "/partitionHealthStatus";
    private static final String AGGREGATED_HEALTH_STATUS = "/aggregatedHealthStatus";
    private static final String IS_HEALTHY_FIELD = "IS_HEALTHY";
    private static final String PARTITIONS = "partitions";
    private static final String ACCEPT_CONTENT_TYPE = "application/json";
    private static final String HEALTH_INSTANCES = "stoppableInstances";
    private static final String NON_STOPPABLE_INSTANCES = "nonStoppableInstancesWithReasons";
    private static final int MAX_REDIRECT = 3;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final HttpClient _httpClient;

    public CustomRestClientImpl(HttpClient httpClient) {
        this._httpClient = httpClient;
    }

    @Override
    public Map<String, Boolean> getInstanceStoppableCheck(String baseUrl, Map<String, String> customPayloads) throws IOException {
        String url = baseUrl + INSTANCE_HEALTH_STATUS;
        JsonConverter jsonConverter = this::extractBooleanMap;
        return this.handleResponse(this.post(url, Collections.unmodifiableMap(customPayloads)), jsonConverter);
    }

    @Override
    public Map<String, Boolean> getPartitionStoppableCheck(String baseUrl, List<String> partitions, Map<String, String> customPayloads) throws IOException {
        String url = baseUrl + PARTITION_HEALTH_STATUS;
        HashMap<String, Object> payLoads = new HashMap<String, Object>(customPayloads);
        if (partitions != null) {
            payLoads.put(PARTITIONS, partitions);
        }
        JsonConverter jsonConverter = this::extractPartitionBooleanMap;
        return this.handleResponse(this.post(url, payLoads), jsonConverter);
    }

    @Override
    public Map<String, List<String>> getAggregatedStoppableCheck(String baseUrl, List<String> instances, Set<String> toBeStoppedInstances, String clusterId, Map<String, String> customPayloads) throws IOException {
        String url = baseUrl + AGGREGATED_HEALTH_STATUS;
        HashMap<String, Object> payLoads = new HashMap<String, Object>(customPayloads);
        if (instances != null && !instances.isEmpty()) {
            payLoads.put("instances", instances);
        }
        Set<String> remainingToBeStoppedInstances = toBeStoppedInstances;
        if (instances != null && toBeStoppedInstances != null) {
            remainingToBeStoppedInstances = toBeStoppedInstances.stream().filter(ins -> !instances.contains(ins)).collect(Collectors.toSet());
        }
        if (remainingToBeStoppedInstances != null && !remainingToBeStoppedInstances.isEmpty()) {
            payLoads.put("to_be_stopped_instances", remainingToBeStoppedInstances);
        }
        if (clusterId != null) {
            payLoads.put("cluster_id", clusterId);
        }
        JsonConverter converter = this::extractAggregatedStatus;
        return this.handleResponse(this.post(url, payLoads), converter);
    }

    @VisibleForTesting
    protected JsonNode getJsonObject(HttpResponse httpResponse) throws IOException {
        HttpEntity httpEntity = httpResponse.getEntity();
        String str = EntityUtils.toString((HttpEntity)httpEntity);
        LOG.info("Converting Response Content {} to JsonNode", (Object)str);
        return OBJECT_MAPPER.readTree(str);
    }

    private <T> Map<String, T> handleResponse(HttpResponse httpResponse, JsonConverter<T> jsonConverter) throws IOException {
        int status = httpResponse.getStatusLine().getStatusCode();
        if (status == 200) {
            LOG.info("Expected HttpResponse statusCode: {}", (Object)200);
            return jsonConverter.convert(this.getJsonObject(httpResponse));
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
        throw new ClientProtocolException("Unexpected response status: " + status + ", reason: " + httpResponse.getStatusLine().getReasonPhrase());
    }

    @VisibleForTesting
    protected HttpResponse post(String url, Map<String, Object> payloads) throws IOException {
        HttpPost postRequest = new HttpPost(url);
        int retries = 0;
        HttpResponse response = null;
        while (retries < 3) {
            try {
                postRequest.setHeader("Accept", ACCEPT_CONTENT_TYPE);
                StringEntity entity = new StringEntity(OBJECT_MAPPER.writeValueAsString(payloads), ContentType.APPLICATION_JSON);
                postRequest.setEntity((HttpEntity)entity);
                LOG.info("Executing request: {}, headers: {}, entity: {}", new Object[]{postRequest.getRequestLine(), postRequest.getAllHeaders(), postRequest.getEntity()});
                response = this._httpClient.execute((HttpUriRequest)postRequest);
                int status = response.getStatusLine().getStatusCode();
                if (status == 200) {
                    return response;
                }
                if (status == 302) {
                    Header locationHeader = response.getFirstHeader("Location");
                    if (locationHeader != null) {
                        String redirectUrl = locationHeader.getValue();
                        LOG.info("Redirecting to: {}", (Object)redirectUrl);
                        postRequest = new HttpPost(redirectUrl);
                        LOG.info("Retrying redirect (attempt {} of {})", (Object)(++retries), (Object)3);
                        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                        continue;
                    }
                } else {
                    LOG.warn("Received non-200 and non-302 status code: {}, payloads: {}", (Object)status, payloads);
                    return response;
                }
                LOG.warn("Received 302 but no Location header is present, stopping retries.");
                break;
            }
            catch (IOException e) {
                postRequest.releaseConnection();
                throw e;
            }
        }
        return response;
    }

    private Map<String, Boolean> extractBooleanMap(JsonNode jsonNode) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        jsonNode.fields().forEachRemaining(kv -> result.put((String)kv.getKey(), ((JsonNode)kv.getValue()).asBoolean()));
        return result;
    }

    private Map<String, Boolean> extractPartitionBooleanMap(JsonNode jsonNode) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        jsonNode.fields().forEachRemaining(kv -> result.put((String)kv.getKey(), ((JsonNode)kv.getValue()).get(IS_HEALTHY_FIELD).asBoolean()));
        return result;
    }

    private Map<String, List<String>> extractAggregatedStatus(JsonNode jsonNode) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        jsonNode.fields().forEachRemaining(response -> {
            String key = (String)response.getKey();
            if (HEALTH_INSTANCES.equals(key)) {
                ((JsonNode)response.getValue()).forEach(instance -> result.put(instance.textValue(), Collections.emptyList()));
            }
            if (NON_STOPPABLE_INSTANCES.equals(key)) {
                ((JsonNode)response.getValue()).fields().forEachRemaining(instance -> result.put((String)instance.getKey(), Stream.of(((JsonNode)instance.getValue()).toString().split(",")).collect(Collectors.toCollection(ArrayList::new))));
            }
        });
        return result;
    }

    private static interface JsonConverter<T> {
        public Map<String, T> convert(JsonNode var1);
    }
}

